/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.ReflectionUtils;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopTask;
import org.gridgain.grid.hadoop.GridHadoopTaskContext;
import org.gridgain.grid.hadoop.GridHadoopTaskInfo;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Context;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;
import org.jetbrains.annotations.Nullable;

public abstract class GridHadoopV2Task
extends GridHadoopTask {
    private GridHadoopV2Context hadoopCtx;

    protected GridHadoopV2Task(GridHadoopTaskInfo taskInfo) {
        super(taskInfo);
    }

    public void run(GridHadoopTaskContext taskCtx) throws GridException {
        GridHadoopV2Job jobImpl = (GridHadoopV2Job)taskCtx.job();
        org.apache.hadoop.mapred.JobContext jobCtx = jobImpl.hadoopJobContext();
        this.hadoopCtx = new GridHadoopV2Context(jobCtx.getConfiguration(), taskCtx, (TaskAttemptID)jobImpl.attemptId(this.info()));
        this.run0(jobImpl, (JobContext)jobCtx, taskCtx);
    }

    protected abstract void run0(GridHadoopV2Job var1, JobContext var2, GridHadoopTaskContext var3) throws GridException;

    protected GridHadoopV2Context hadoopContext() {
        return this.hadoopCtx;
    }

    protected OutputFormat getOutputFormat(JobContext jobCtx) throws ClassNotFoundException {
        return (OutputFormat)ReflectionUtils.newInstance((Class)jobCtx.getOutputFormatClass(), (Configuration)jobCtx.getConfiguration());
    }

    protected OutputFormat prepareWriter(JobContext jobCtx) throws GridException, InterruptedException {
        try {
            OutputFormat outputFormat = this.getOutputFormat(jobCtx);
            assert (outputFormat != null);
            OutputCommitter outCommitter = outputFormat.getOutputCommitter((TaskAttemptContext)this.hadoopCtx);
            if (outCommitter != null) {
                outCommitter.setupTask((TaskAttemptContext)this.hadoopCtx);
            }
            RecordWriter writer = outputFormat.getRecordWriter((TaskAttemptContext)this.hadoopCtx);
            this.hadoopCtx.writer(writer);
            return outputFormat;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new GridException((Throwable)e);
        }
    }

    protected void closeWriter() throws IOException, InterruptedException {
        RecordWriter writer = this.hadoopCtx.writer();
        if (writer != null) {
            writer.close((TaskAttemptContext)this.hadoopCtx);
        }
    }

    protected void setup(@Nullable OutputFormat outputFormat) throws IOException, InterruptedException {
        if (this.hadoopCtx.writer() != null) {
            assert (outputFormat != null);
            outputFormat.getOutputCommitter((TaskAttemptContext)this.hadoopCtx).setupTask((TaskAttemptContext)this.hadoopCtx);
        }
    }

    protected void commit(@Nullable OutputFormat outputFormat) throws GridException, IOException, InterruptedException {
        if (this.hadoopCtx.writer() != null) {
            assert (outputFormat != null);
            OutputCommitter outputCommitter = outputFormat.getOutputCommitter((TaskAttemptContext)this.hadoopCtx);
            if (outputCommitter.needsTaskCommit((TaskAttemptContext)this.hadoopCtx)) {
                outputCommitter.commitTask((TaskAttemptContext)this.hadoopCtx);
            }
        }
    }

    protected void abort(@Nullable OutputFormat outputFormat) {
        if (this.hadoopCtx.writer() != null) {
            assert (outputFormat != null);
            try {
                outputFormat.getOutputCommitter((TaskAttemptContext)this.hadoopCtx).abortTask((TaskAttemptContext)this.hadoopCtx);
            }
            catch (IOException ignore) {
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void cancel() {
        this.hadoopCtx.cancel();
    }
}

