/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.hadoop.v2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopSerialization;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridHadoopWritableSerialization
implements GridHadoopSerialization {
    private final Class<? extends Writable> cls;

    public GridHadoopWritableSerialization(Class<? extends Writable> cls) {
        assert (cls != null);
        this.cls = cls;
    }

    public void write(DataOutput out, Object obj) throws GridException {
        assert (this.cls.isAssignableFrom(obj.getClass())) : this.cls + " " + obj.getClass();
        try {
            ((Writable)obj).write(out);
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
    }

    public Object read(DataInput in, @Nullable Object obj) throws GridException {
        Writable w = obj == null ? (Writable)U.newInstance(this.cls) : this.cls.cast(obj);
        try {
            w.readFields(in);
        }
        catch (IOException e) {
            throw new GridException((Throwable)e);
        }
        return w;
    }

    public void close() {
    }
}

