/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.visor.gui.dto;

import java.util.Collections;
import java.util.List;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.kernal.visor.gui.dto.VisorGgfsProfilerEntry;
import org.gridgain.grid.kernal.visor.gui.dto.VisorGgfsProfilerUniformityCounters;
import org.gridgain.grid.util.typedef.F;

public class VisorGgfsProfiler {
    public static final int UNIFORMITY_DFLT_BLOCK_SIZE = 4096;
    public static final int UNIFORMITY_BLOCKS = 100;

    public static VisorGgfsProfilerEntry aggregateGgfsProfilerEntries(List<VisorGgfsProfilerEntry> entries) {
        assert (!F.isEmpty(entries));
        if (entries.size() == 1) {
            return entries.get(0);
        }
        String path = entries.get(0).path();
        Collections.sort(entries, VisorGgfsProfilerEntry.ENTRY_TIMESTAMP_COMPARATOR);
        long timestamp = 0L;
        long size = 0L;
        long bytesRead = 0L;
        long readTime = 0L;
        long userReadTime = 0L;
        long bytesWritten = 0L;
        long writeTime = 0L;
        long userWriteTime = 0L;
        GridGgfsMode mode = null;
        VisorGgfsProfilerUniformityCounters counters = new VisorGgfsProfilerUniformityCounters();
        for (VisorGgfsProfilerEntry entry : entries) {
            timestamp = entry.timestamp();
            size = entry.size();
            mode = entry.mode();
            bytesRead += entry.bytesRead();
            readTime += entry.readTime();
            userReadTime += entry.userReadTime();
            bytesWritten += entry.bytesWritten();
            writeTime += entry.writeTime();
            userWriteTime += entry.userWriteTime();
            counters.aggregate(entry.counters());
        }
        return new VisorGgfsProfilerEntry(path, timestamp, mode, size, bytesRead, readTime, userReadTime, bytesWritten, writeTime, userWriteTime, counters);
    }
}

