/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.visor.gui.dto;

import java.io.Serializable;
import java.util.Comparator;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.kernal.visor.gui.dto.VisorGgfsProfilerUniformityCounters;
import org.gridgain.grid.util.typedef.internal.S;

public class VisorGgfsProfilerEntry
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final Comparator<VisorGgfsProfilerEntry> ENTRY_TIMESTAMP_COMPARATOR = new Comparator<VisorGgfsProfilerEntry>(){

        @Override
        public int compare(VisorGgfsProfilerEntry a, VisorGgfsProfilerEntry b) {
            return Long.compare(a.timestamp, b.timestamp);
        }
    };
    private final String path;
    private final long timestamp;
    private final GridGgfsMode mode;
    private final long size;
    private final long bytesRead;
    private final long readTime;
    private final long userReadTime;
    private final long bytesWritten;
    private final long writeTime;
    private final long userWriteTime;
    private double uniformity = -1.0;
    private final VisorGgfsProfilerUniformityCounters counters;
    private final long readSpeed;
    private final long writeSpeed;

    public VisorGgfsProfilerEntry(String path, long timestamp, GridGgfsMode mode, long size, long bytesRead, long readTime, long userReadTime, long bytesWritten, long writeTime, long userWriteTime, VisorGgfsProfilerUniformityCounters counters) {
        assert (counters != null);
        this.path = path;
        this.timestamp = timestamp;
        this.mode = mode;
        this.size = size;
        this.bytesRead = bytesRead;
        this.readTime = readTime;
        this.userReadTime = userReadTime;
        this.bytesWritten = bytesWritten;
        this.writeTime = writeTime;
        this.userWriteTime = userWriteTime;
        this.counters = counters;
        this.readSpeed = VisorGgfsProfilerEntry.speed(bytesRead, readTime);
        this.writeSpeed = VisorGgfsProfilerEntry.speed(bytesWritten, writeTime);
    }

    private static long speed(long bytes, long time) {
        if (time > 0L) {
            double bytesScaled = (double)bytes * 100000.0;
            double timeScaled = (double)time / 10000.0;
            return (long)(bytesScaled / timeScaled);
        }
        return -1L;
    }

    public String path() {
        return this.path;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public GridGgfsMode mode() {
        return this.mode;
    }

    public long size() {
        return this.size;
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long readTime() {
        return this.readTime;
    }

    public long userReadTime() {
        return this.userReadTime;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public long writeTime() {
        return this.writeTime;
    }

    public long userWriteTime() {
        return this.userWriteTime;
    }

    public double uniformity() {
        if (this.uniformity < 0.0) {
            this.uniformity = this.counters.calc();
        }
        return this.uniformity;
    }

    public VisorGgfsProfilerUniformityCounters counters() {
        return this.counters;
    }

    public long readSpeed() {
        return this.readSpeed;
    }

    public long writeSpeed() {
        return this.writeSpeed;
    }

    public String toString() {
        return S.toString(VisorGgfsProfilerEntry.class, (Object)this);
    }
}

