/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.visor.gui.tasks;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfs;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.kernal.visor.cmd.VisorJob;
import org.gridgain.grid.kernal.visor.cmd.VisorOneNodeTask;
import org.gridgain.grid.kernal.visor.gui.tasks.VisorHadoopTaskUtilsEnt;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.util.typedef.internal.S;

@GridInternal
public class VisorGgfsProfilerClearTask
extends VisorOneNodeTask<String, GridBiTuple<Integer, Integer>> {
    private static final long serialVersionUID = 0L;

    protected VisorGgfsProfilerClearJob job(String arg) {
        return new VisorGgfsProfilerClearJob(arg);
    }

    private static class VisorGgfsProfilerClearJob
    extends VisorJob<String, GridBiTuple<Integer, Integer>> {
        private static final long serialVersionUID = 0L;

        private VisorGgfsProfilerClearJob(String arg) {
            super((Object)arg);
        }

        protected GridBiTuple<Integer, Integer> run(String arg) throws GridException {
            int notDeleted;
            int deleted;
            block19: {
                deleted = 0;
                notDeleted = 0;
                try {
                    GridGgfs ggfs = this.g.ggfs(arg);
                    Path logsDir = VisorHadoopTaskUtilsEnt.resolveGgfsProfilerLogsDir(ggfs);
                    if (logsDir == null) break block19;
                    PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:ggfs-log-" + arg + "-*.csv");
                    try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(logsDir);){
                        for (Path p : dirStream) {
                            if (!matcher.matches(p.getFileName())) continue;
                            try {
                                Files.delete(p);
                                if (Files.exists(p, new LinkOption[0])) {
                                    ++notDeleted;
                                    continue;
                                }
                                ++deleted;
                            }
                            catch (NoSuchFileException ignored) {
                            }
                            catch (IOException io) {
                                ++notDeleted;
                                this.g.log().warning("Profiler log file was not deleted: " + p, (Throwable)io);
                            }
                        }
                    }
                }
                catch (IOException | IllegalArgumentException ioe) {
                    throw new GridException("Failed to clear profiler logs for GGFS: " + arg, (Throwable)ioe);
                }
            }
            return new GridBiTuple((Object)deleted, (Object)notDeleted);
        }

        public String toString() {
            return S.toString(VisorGgfsProfilerClearJob.class, (Object)((Object)this));
        }
    }
}

