/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.visor.gui.tasks;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.kernal.visor.cmd.VisorJob;
import org.gridgain.grid.kernal.visor.cmd.VisorOneNodeTask;
import org.gridgain.grid.kernal.visor.gui.dto.VisorGgfsProfiler;
import org.gridgain.grid.kernal.visor.gui.dto.VisorGgfsProfilerEntry;
import org.gridgain.grid.kernal.visor.gui.dto.VisorGgfsProfilerUniformityCounters;
import org.gridgain.grid.kernal.visor.gui.tasks.VisorHadoopTaskUtilsEnt;
import org.gridgain.grid.util.typedef.internal.S;

@GridInternal
public class VisorGgfsProfilerTask
extends VisorOneNodeTask<String, Collection<VisorGgfsProfilerEntry>> {
    private static final long serialVersionUID = 0L;
    private static final Comparator<VisorGgfsProfilerParsedLine> PARSED_LINE_BY_TS_COMPARATOR = new Comparator<VisorGgfsProfilerParsedLine>(){

        @Override
        public int compare(VisorGgfsProfilerParsedLine a, VisorGgfsProfilerParsedLine b) {
            return a.ts < b.ts ? -1 : (a.ts > b.ts ? 1 : 0);
        }
    };

    protected VisorGgfsProfilerJob job(String arg) {
        return new VisorGgfsProfilerJob(arg);
    }

    private static class VisorGgfsProfilerJob
    extends VisorJob<String, Collection<VisorGgfsProfilerEntry>> {
        private static final long serialVersionUID = 0L;

        private VisorGgfsProfilerJob(String arg) {
            super((Object)arg);
        }

        protected Collection<VisorGgfsProfilerEntry> run(String arg) throws GridException {
            try {
                Path logsDir = VisorHadoopTaskUtilsEnt.resolveGgfsProfilerLogsDir(this.g.ggfs(arg));
                if (logsDir != null) {
                    return this.parse(logsDir, arg);
                }
                return Collections.emptyList();
            }
            catch (IOException | IllegalArgumentException e) {
                throw new GridException("Failed to parse profiler logs for GGFS: " + arg, (Throwable)e);
            }
        }

        private boolean parseBoolean(String[] ss, int ix) {
            return ix < ss.length && "1".equals(ss[ix]);
        }

        private int parseInt(String[] ss, int ix, int dflt) {
            if (ss.length <= ix) {
                return dflt;
            }
            String s = ss[ix];
            return s.isEmpty() ? dflt : Integer.parseInt(s);
        }

        private long parseLong(String[] ss, int ix, long dflt) {
            if (ss.length <= ix) {
                return dflt;
            }
            String s = ss[ix];
            return s.isEmpty() ? dflt : Long.parseLong(s);
        }

        private String parseString(String[] ss, int ix) {
            if (ss.length <= ix) {
                return "";
            }
            String s = ss[ix];
            return s.isEmpty() ? "" : s;
        }

        private GridGgfsMode parseGgfsMode(String[] ss, int ix) {
            if (ss.length <= ix) {
                return null;
            }
            String s = ss[ix];
            return s.isEmpty() ? null : GridGgfsMode.valueOf((String)s);
        }

        private VisorGgfsProfilerParsedLine parseLine(String s) {
            int entryType;
            String[] ss = s.split(";");
            long streamId = this.parseLong(ss, 6, -1L);
            if (streamId >= 0L && VisorHadoopTaskUtilsEnt.LOG_TYPES.contains(entryType = this.parseInt(ss, 3, -1))) {
                return new VisorGgfsProfilerParsedLine(this.parseLong(ss, 0, 0L), entryType, this.parseString(ss, 4), this.parseGgfsMode(ss, 5), streamId, this.parseLong(ss, 8, 0L), this.parseBoolean(ss, 10), this.parseLong(ss, 13, 0L), this.parseLong(ss, 17, 0L), this.parseLong(ss, 18, 0L), this.parseLong(ss, 19, 0L));
            }
            return null;
        }

        private VisorGgfsProfilerEntry aggregateParsedLines(List<VisorGgfsProfilerParsedLine> lines) {
            VisorGgfsProfilerUniformityCounters counters = new VisorGgfsProfilerUniformityCounters();
            Collections.sort(lines, PARSED_LINE_BY_TS_COMPARATOR);
            String path = "";
            long ts = 0L;
            long size = 0L;
            long bytesRead = 0L;
            long readTime = 0L;
            long userReadTime = 0L;
            long bytesWritten = 0L;
            long writeTime = 0L;
            long userWriteTime = 0L;
            GridGgfsMode mode = null;
            block7: for (VisorGgfsProfilerParsedLine line : lines) {
                if (!line.path.isEmpty()) {
                    path = line.path;
                }
                ts = line.ts;
                if (line.mode != null) {
                    mode = line.mode;
                }
                switch (line.entryType) {
                    case 0: {
                        size = line.dataLen;
                        counters.invalidate(size);
                        continue block7;
                    }
                    case 1: {
                        if (!line.overwrite) continue block7;
                        size = 0L;
                        counters.invalidate(size);
                        continue block7;
                    }
                    case 7: {
                        bytesRead += line.totalBytes;
                        readTime += line.sysTime;
                        userReadTime += line.userTime;
                        counters.increment(line.pos, line.totalBytes);
                        continue block7;
                    }
                    case 8: {
                        bytesWritten += line.totalBytes;
                        writeTime += line.sysTime;
                        userWriteTime += line.userTime;
                        counters.invalidate(size += line.totalBytes);
                        continue block7;
                    }
                    case 2: {
                        counters.increment(line.pos, line.totalBytes);
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unexpected GGFS profiler log entry type: " + line.entryType);
            }
            return path.isEmpty() ? null : new VisorGgfsProfilerEntry(path, ts, mode, size, bytesRead, readTime, userReadTime, bytesWritten, writeTime, userWriteTime, counters);
        }

        /*
         * WARNING - void declaration
         */
        private Collection<VisorGgfsProfilerEntry> parseFile(Path p) throws IOException {
            ArrayList<VisorGgfsProfilerParsedLine> parsedLines;
            block23: {
                parsedLines = new ArrayList<VisorGgfsProfilerParsedLine>(512);
                try (BufferedReader br = Files.newBufferedReader(p, Charset.forName("UTF-8"));){
                    void var5_7;
                    String string = br.readLine();
                    if (string == null) break block23;
                    if (string.equalsIgnoreCase("Timestamp;ThreadID;PID;Type;Path;Mode;StreamId;BufSize;DataLen;Append;Overwrite;Replication;BlockSize;Position;ReadLen;SkipCnt;ReadLimit;UserTime;SystemTime;TotalBytes;DestPath;Recursive;List")) {
                        String string2 = br.readLine();
                    }
                    while (var5_7 != null) {
                        try {
                            VisorGgfsProfilerParsedLine ln = this.parseLine((String)var5_7);
                            if (ln != null) {
                                parsedLines.add(ln);
                            }
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                        String string3 = br.readLine();
                    }
                }
            }
            HashMap<Long, ArrayList<VisorGgfsProfilerParsedLine>> byStreamId = new HashMap<Long, ArrayList<VisorGgfsProfilerParsedLine>>();
            for (VisorGgfsProfilerParsedLine visorGgfsProfilerParsedLine : parsedLines) {
                ArrayList<VisorGgfsProfilerParsedLine> grp = (ArrayList<VisorGgfsProfilerParsedLine>)byStreamId.get(visorGgfsProfilerParsedLine.streamId);
                if (grp == null) {
                    grp = new ArrayList<VisorGgfsProfilerParsedLine>();
                    byStreamId.put(visorGgfsProfilerParsedLine.streamId, grp);
                }
                grp.add(visorGgfsProfilerParsedLine);
            }
            ArrayList<VisorGgfsProfilerEntry> entries = new ArrayList<VisorGgfsProfilerEntry>(byStreamId.size());
            for (List lines : byStreamId.values()) {
                VisorGgfsProfilerEntry entry = this.aggregateParsedLines(lines);
                if (entry == null) continue;
                entries.add(entry);
            }
            HashMap<String, ArrayList<VisorGgfsProfilerEntry>> hashMap = new HashMap<String, ArrayList<VisorGgfsProfilerEntry>>();
            for (VisorGgfsProfilerEntry entry : entries) {
                ArrayList<VisorGgfsProfilerEntry> grp = (ArrayList<VisorGgfsProfilerEntry>)hashMap.get(entry.path());
                if (grp == null) {
                    grp = new ArrayList<VisorGgfsProfilerEntry>();
                    hashMap.put(entry.path(), grp);
                }
                grp.add(entry);
            }
            ArrayList<VisorGgfsProfilerEntry> res = new ArrayList<VisorGgfsProfilerEntry>(hashMap.size());
            for (List lst : hashMap.values()) {
                res.add(VisorGgfsProfiler.aggregateGgfsProfilerEntries(lst));
            }
            return res;
        }

        private Collection<VisorGgfsProfilerEntry> parse(Path logDir, String ggfsName) throws IOException {
            ArrayList<VisorGgfsProfilerEntry> parsedFiles = new ArrayList<VisorGgfsProfilerEntry>(512);
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(logDir);){
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:ggfs-log-" + ggfsName + "-*.csv");
                for (Path p : dirStream) {
                    if (!matcher.matches(p.getFileName())) continue;
                    try {
                        parsedFiles.addAll(this.parseFile(p));
                    }
                    catch (NoSuchFileException ignored) {
                    }
                    catch (Exception e) {
                        this.g.log().warning("Failed to parse GGFS profiler log file: " + p, (Throwable)e);
                    }
                }
            }
            return parsedFiles;
        }

        public String toString() {
            return S.toString(VisorGgfsProfilerJob.class, (Object)((Object)this));
        }
    }

    private static class VisorGgfsProfilerParsedLine {
        private final long ts;
        private final int entryType;
        private final String path;
        private final GridGgfsMode mode;
        private final long streamId;
        private final long dataLen;
        private final boolean overwrite;
        private final long pos;
        private final long userTime;
        private final long sysTime;
        private final long totalBytes;

        private VisorGgfsProfilerParsedLine(long ts, int entryType, String path, GridGgfsMode mode, long streamId, long dataLen, boolean overwrite, long pos, long userTime, long sysTime, long totalBytes) {
            this.ts = ts;
            this.entryType = entryType;
            this.path = path;
            this.mode = mode;
            this.streamId = streamId;
            this.dataLen = dataLen;
            this.overwrite = overwrite;
            this.pos = pos;
            this.userTime = userTime;
            this.sysTime = sysTime;
            this.totalBytes = totalBytes;
        }
    }
}

