/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.util.ipc;

import java.util.Map;
import org.gridgain.grid.GridException;
import org.gridgain.grid.util.ipc.GridIpcServerEndpoint;
import org.gridgain.grid.util.ipc.loopback.GridIpcServerTcpEndpoint;
import org.gridgain.grid.util.ipc.shmem.GridIpcSharedMemoryServerEndpoint;
import org.gridgain.grid.util.typedef.internal.A;

public class GridIpcServerEndpointDeserializer {
    public static GridIpcServerEndpoint deserialize(Map<String, String> endpointCfg) throws GridException {
        A.notNull(endpointCfg, (String)"endpointCfg");
        String endpointType = endpointCfg.get("type");
        if (endpointType == null) {
            throw new GridException("Failed to create server endpoint (type is not specified)");
        }
        switch (endpointType) {
            case "shmem": {
                GridIpcSharedMemoryServerEndpoint endpoint = new GridIpcSharedMemoryServerEndpoint();
                endpoint.setupConfiguration(endpointCfg);
                return endpoint;
            }
            case "tcp": {
                GridIpcServerTcpEndpoint endpoint = new GridIpcServerTcpEndpoint();
                endpoint.setupConfiguration(endpointCfg);
                return endpoint;
            }
        }
        throw new GridException("Failed to create server endpoint (type is unknown): " + endpointType);
    }
}

