/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.hibernate;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.Callable;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridProjection;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheProjection;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.resources.GridInstanceResource;
import org.gridgain.grid.util.typedef.internal.U;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.jetbrains.annotations.Nullable;

public abstract class GridHibernateAccessStrategyAdapter {
    protected final GridCache<Object, Object> cache;
    protected final Grid grid;
    protected final GridLogger log;

    protected GridHibernateAccessStrategyAdapter(Grid grid, GridCache<Object, Object> cache) {
        this.cache = cache;
        this.grid = grid;
        this.log = grid.log();
    }

    @Nullable
    protected Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected void putFromLoad(Object key, Object val, boolean minimalPutOverride) throws CacheException {
        this.putFromLoad(key, val);
    }

    protected void putFromLoad(Object key, Object val) throws CacheException {
        try {
            this.cache.putx(key, val, new GridPredicate[0]);
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Nullable
    protected abstract SoftLock lock(Object var1) throws CacheException;

    protected abstract void unlock(Object var1, SoftLock var2) throws CacheException;

    protected abstract boolean update(Object var1, Object var2) throws CacheException;

    protected abstract boolean afterUpdate(Object var1, Object var2, SoftLock var3) throws CacheException;

    protected abstract boolean insert(Object var1, Object var2) throws CacheException;

    protected abstract boolean afterInsert(Object var1, Object var2) throws CacheException;

    protected abstract void remove(Object var1) throws CacheException;

    protected void evict(Object key) throws CacheException {
        GridHibernateAccessStrategyAdapter.evict((GridProjection)this.grid, this.cache, key);
    }

    protected void evictAll() throws CacheException {
        GridHibernateAccessStrategyAdapter.evictAll(this.cache);
    }

    @Nullable
    protected SoftLock lockRegion() throws CacheException {
        return null;
    }

    protected void unlockRegion(SoftLock lock) throws CacheException {
    }

    protected final void removeAll() throws CacheException {
        this.evictAll();
    }

    static void evict(GridProjection grid, GridCacheProjection<Object, Object> cache, Object key) throws CacheException {
        try {
            grid.forCache(cache.name(), new String[0]).compute().call((Callable)new ClearKeyCallable(key, cache.name())).get();
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    static void evictAll(GridCacheProjection<Object, Object> cache) throws CacheException {
        try {
            cache.globalClearAll();
        }
        catch (GridException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static class ClearKeyCallable
    implements Callable<Void>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        @GridInstanceResource
        private Grid grid;
        private Object key;
        private String cacheName;

        public ClearKeyCallable() {
        }

        private ClearKeyCallable(Object key, String cacheName) {
            this.key = key;
            this.cacheName = cacheName;
        }

        @Override
        public Void call() throws GridException {
            GridCache cache = this.grid.cache(this.cacheName);
            assert (cache != null);
            cache.clear(this.key);
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.key);
            U.writeString((DataOutput)out, (String)this.cacheName);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.key = in.readObject();
            this.cacheName = U.readString((DataInput)in);
        }
    }
}

