/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.coherence.cache.config;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Configurator;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;

public class Configuration {
    private static final String SPRING_CONFIG_XML = "spring-config.xml";
    public static String CONFIG_FILE_NAME = "coherence-utils.properties";
    public static String SYSPROP_CONFIG_FILE_NAME = "coherence-utils.configfile";
    private static final Map<String, Map<String, String>> PROPERTIES_MAP = new HashMap<String, Map<String, String>>();
    public static final Logger LOG = Logger.getLogger(Configurator.class);

    private static void loadPropertyFiles() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(SPRING_CONFIG_XML);
        try {
            Resource[] xmlResources;
            for (Resource r : xmlResources = context.getResources("classpath:/**/*.properties")) {
                Configuration.loadProperties(r);
            }
            Configuration.overrideWithSystemProperties();
            LOG.info((Object)("initialized Configurator with " + xmlResources.length + " config files plus system properies and environment varialbes\n " + PROPERTIES_MAP));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadProperties(Resource propertiesResource) throws IOException {
        LOG.info((Object)("loading configuration from " + propertiesResource.getFile().getAbsolutePath()));
        Properties properties = new Properties();
        properties.load(propertiesResource.getInputStream());
        PROPERTIES_MAP.put(propertiesResource.getFilename(), Configuration.asMap(properties));
    }

    private static Map<String, String> asMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            map.put(key, properties.getProperty(key));
        }
        return map;
    }

    private static void initializeConfigFileName() {
        if (System.getProperty(SYSPROP_CONFIG_FILE_NAME) != null) {
            CONFIG_FILE_NAME = System.getProperty(SYSPROP_CONFIG_FILE_NAME);
        }
        if (System.getenv(SYSPROP_CONFIG_FILE_NAME) != null) {
            CONFIG_FILE_NAME = System.getenv(SYSPROP_CONFIG_FILE_NAME);
        }
    }

    private static void put(String propName, String propValue) {
        Configuration.put(CONFIG_FILE_NAME, propName, propValue);
    }

    private static void put(String propFileName, String propName, String propValue) {
        Map<String, String> properties = Configuration.getPropertiesMap(propFileName);
        properties.put(propName, propValue);
    }

    private static void putAll(Map<String, String> properties) {
        Configuration.putAll(CONFIG_FILE_NAME, properties);
    }

    private static void putAll(String propFileName, Map<String, String> propertiesIncoming) {
        Map<String, String> properties = Configuration.getPropertiesMap(propFileName);
        properties.putAll(propertiesIncoming);
    }

    private static Map<String, String> getPropertiesMap(String propFileName) {
        Map<String, String> properties = PROPERTIES_MAP.get(propFileName);
        if (properties == null) {
            properties = new HashMap<String, String>();
            PROPERTIES_MAP.put(propFileName, properties);
        }
        return properties;
    }

    private static void overrideWithSystemProperties() {
        for (INBUILD_PROPERTIES ib : INBUILD_PROPERTIES.values()) {
            Configuration.put(ib.getSystemPropertyName(), ib.getDefaultValue());
        }
        Configuration.putAll(System.getenv());
        Configuration.putAll(Configuration.asMap(System.getProperties()));
    }

    public static String get(String fileName, String name) {
        Map<String, String> props = PROPERTIES_MAP.get(fileName);
        if (props != null) {
            return props.get(name);
        }
        LOG.info((Object)("properties " + fileName + " not loaded in " + PROPERTIES_MAP.keySet()));
        return Configuration.loadAndGet(fileName, name);
    }

    private static String loadAndGet(String fileName, String name) {
        LOG.info((Object)("attempting to load " + fileName + " from classpath " + fileName));
        Properties p = new Properties();
        try {
            p.load(Configuration.class.getClass().getClassLoader().getResourceAsStream(fileName));
        }
        catch (Exception e) {
            LOG.warn((Object)("couldn't read property file " + fileName + " for " + name));
        }
        String v = p.getProperty(name);
        if (v != null) {
            PROPERTIES_MAP.put(fileName, Configuration.asMap(p));
        }
        return v;
    }

    public static String get(String name) {
        return Configuration.get(CONFIG_FILE_NAME, name);
    }

    public static String getSchedulingCacheName() {
        return Configuration.get(INBUILD_PROPERTIES.SCHEDULING_CACHE_NAME.getSystemPropertyName());
    }

    public static Set<String> getPropertyFiles() {
        return PROPERTIES_MAP.keySet();
    }

    public static Set<String> getPropertyFiles(String fileName) {
        Map<String, String> m = PROPERTIES_MAP.get(fileName);
        if (m == null) {
            return new HashSet<String>();
        }
        return m.keySet();
    }

    static {
        Configuration.initializeConfigFileName();
        Configuration.loadPropertyFiles();
    }

    static enum INBUILD_PROPERTIES implements InbuildProperty
    {
        SCHEDULING_CACHE_NAME{

            @Override
            public String getDefaultValue() {
                return "scheduling";
            }

            @Override
            public String getSystemPropertyName() {
                return "coherence-utils.scheduling-cache-name";
            }
        };

    }

    private static interface InbuildProperty {
        public String getSystemPropertyName();

        public String getDefaultValue();
    }
}

