/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.coherence.cache.scheduling;

import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.MapEvent;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.gridvise.coherence.cache.listener.AbstractBackingMapListener;
import org.gridvise.coherence.cache.scheduling.ScheduledJob;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class SchedulerBackingMapListener
extends AbstractBackingMapListener<JobKey, ScheduledJob> {
    private static final Logger LOG = Logger.getLogger(SchedulerBackingMapListener.class);
    private Scheduler scheduler;

    public SchedulerBackingMapListener(BackingMapManagerContext context) {
        super(context);
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
            LOG.info((Object)"started scheduler");
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Failed to initialize Quartz scheduler", (Throwable)e);
        }
    }

    public void entryInserted(MapEvent event) {
        ScheduledJob sj = (ScheduledJob)this.getNewValue(event);
        JobDetail job = sj.getJob();
        try {
            this.scheduler.scheduleJob(job, sj.getTriggers().get(0));
            LOG.info((Object)("Scheduled job " + job));
        }
        catch (SchedulerException e) {
            LOG.error((Object)("Failed to schedule job " + job), (Throwable)e);
        }
    }

    public void entryUpdated(MapEvent event) {
        ScheduledJob sj = (ScheduledJob)this.getNewValue(event);
        JobDetail job = sj.getJob();
        try {
            this.scheduler.scheduleJobs(Collections.singletonMap(job, sj.getTriggers()), true);
            LOG.info((Object)("Rescheduled job " + job));
        }
        catch (SchedulerException e) {
            LOG.error((Object)("Failed to reschedule job " + job), (Throwable)e);
        }
    }

    public void entryDeleted(MapEvent event) {
        ScheduledJob sj = (ScheduledJob)this.getOldValue(event);
        JobDetail job = sj.getJob();
        try {
            this.scheduler.deleteJob(job.getKey());
            LOG.info((Object)("Unscheduled job " + job));
        }
        catch (SchedulerException e) {
            LOG.error((Object)("Failed to unschedule job " + job), (Throwable)e);
        }
    }
}

