/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer;

import java.io.File;
import java.io.IOException;
import org.grobid.core.GrobidModels;
import org.grobid.core.engines.tagging.GenericTagger;
import org.grobid.core.engines.tagging.TaggerFactory;
import org.grobid.core.exceptions.GrobidException;
import org.grobid.core.factory.GrobidFactory;
import org.grobid.core.utilities.GrobidProperties;
import org.grobid.trainer.GenericTrainer;
import org.grobid.trainer.Trainer;
import org.grobid.trainer.TrainerFactory;
import org.grobid.trainer.evaluation.EvaluationUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrainer
implements Trainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrainer.class);
    public static final String OLD_MODEL_EXT = ".old";
    public static final String NEW_MODEL_EXT = ".new";
    protected double epsilon = 0.0;
    protected int window = 0;
    protected GrobidModels model;
    private File trainDataPath;
    private File evalDataPath;
    private GenericTagger tagger;

    public AbstractTrainer(GrobidModels model) {
        GrobidFactory.getInstance().createEngine();
        this.model = model;
        this.trainDataPath = this.getTempTrainingDataPath();
        this.evalDataPath = this.getTempEvaluationDataPath();
    }

    @Override
    public void train() {
        File dataPath = this.trainDataPath;
        this.createCRFPPData(this.getCorpusPath(), dataPath);
        GenericTrainer trainer = TrainerFactory.getTrainer();
        if (this.epsilon != 0.0) {
            trainer.setEpsilon(this.epsilon);
        }
        if (this.window != 0) {
            trainer.setWindow(this.window);
        }
        File tempModelPath = new File(GrobidProperties.getModelPath((GrobidModels)this.model).getAbsolutePath() + NEW_MODEL_EXT);
        File oldModelPath = GrobidProperties.getModelPath((GrobidModels)this.model);
        trainer.train(this.getTemplatePath(), dataPath, tempModelPath, GrobidProperties.getNBThreads(), this.model);
        this.renameModels(oldModelPath, tempModelPath);
    }

    protected void renameModels(File oldModelPath, File tempModelPath) {
        if (oldModelPath.exists() && !oldModelPath.renameTo(new File(oldModelPath.getAbsolutePath() + OLD_MODEL_EXT))) {
            LOGGER.warn("Unable to rename old model file: " + oldModelPath.getAbsolutePath());
            return;
        }
        if (!tempModelPath.renameTo(oldModelPath)) {
            LOGGER.warn("Unable to rename new model file: " + tempModelPath);
        }
    }

    @Override
    public String evaluate() {
        this.createCRFPPData(this.getEvalCorpusPath(), this.evalDataPath);
        return EvaluationUtilities.evaluateStandard(this.evalDataPath.getAbsolutePath(), this.getTagger());
    }

    @Override
    public String splitTrainEvaluate(Double split) {
        File dataPath = this.trainDataPath;
        this.createCRFPPData(this.getCorpusPath(), dataPath, this.evalDataPath, split);
        GenericTrainer trainer = TrainerFactory.getTrainer();
        File tempModelPath = new File(GrobidProperties.getModelPath((GrobidModels)this.model).getAbsolutePath() + NEW_MODEL_EXT);
        File oldModelPath = GrobidProperties.getModelPath((GrobidModels)this.model);
        trainer.train(this.getTemplatePath(), dataPath, tempModelPath, GrobidProperties.getNBThreads(), this.model);
        this.renameModels(oldModelPath, tempModelPath);
        return EvaluationUtilities.evaluateStandard(this.evalDataPath.getAbsolutePath(), this.getTagger());
    }

    protected final File getTempTrainingDataPath() {
        try {
            return File.createTempFile(this.model.getModelName(), ".train", GrobidProperties.getTempPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a temporary training file for model: " + this.model);
        }
    }

    protected final File getTempEvaluationDataPath() {
        try {
            return File.createTempFile(this.model.getModelName(), ".test", GrobidProperties.getTempPath());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a temporary evaluation file for model: " + this.model);
        }
    }

    protected GenericTagger getTagger() {
        if (this.tagger == null) {
            this.tagger = TaggerFactory.getTagger((GrobidModels)this.model);
        }
        return this.tagger;
    }

    protected static File getFilePath2Resources() {
        File theFile = new File(GrobidProperties.get_GROBID_HOME_PATH().getAbsoluteFile() + File.separator + ".." + File.separator + "grobid-trainer" + File.separator + "resources");
        if (!theFile.exists()) {
            theFile = new File("resources");
        }
        return theFile;
    }

    protected final File getCorpusPath() {
        return GrobidProperties.getCorpusPath((File)AbstractTrainer.getFilePath2Resources(), (GrobidModels)this.model);
    }

    protected final File getTemplatePath() {
        return AbstractTrainer.getTemplatePath(this.model);
    }

    protected static File getTemplatePath(GrobidModels model) {
        return GrobidProperties.getTemplatePath((File)AbstractTrainer.getFilePath2Resources(), (GrobidModels)model);
    }

    protected File getEvalCorpusPath() {
        return GrobidProperties.getEvalCorpusPath((File)AbstractTrainer.getFilePath2Resources(), (GrobidModels)this.model);
    }

    public static File getEvalCorpusBasePath() {
        String path2Evelutation = AbstractTrainer.getFilePath2Resources().getAbsolutePath() + File.separator + "dataset" + File.separator + "patent" + File.separator + "evaluation";
        return new File(path2Evelutation);
    }

    @Override
    public GrobidModels getModel() {
        return this.model;
    }

    public static void runTraining(Trainer trainer) {
        long start = System.currentTimeMillis();
        trainer.train();
        long end = System.currentTimeMillis();
        System.out.println("Model for " + trainer.getModel() + " created in " + (end - start) + " ms");
    }

    public File getEvalDataPath() {
        return this.evalDataPath;
    }

    public static void runEvaluation(Trainer trainer) {
        long start = System.currentTimeMillis();
        try {
            String report = trainer.evaluate();
            System.out.println(report);
        }
        catch (Exception e) {
            throw new GrobidException("An exception occurred while evaluating Grobid.", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        System.out.println("Evaluation for " + trainer.getModel() + " model is realized in " + (end - start) + " ms");
    }

    public static void runSplitTrainingEvaluation(Trainer trainer, Double split) {
        long start = System.currentTimeMillis();
        try {
            String report = trainer.splitTrainEvaluate(split);
            System.out.println(report);
        }
        catch (Exception e) {
            throw new GrobidException("An exception occurred while evaluating Grobid.", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        System.out.println("Split, training and evaluation for " + trainer.getModel() + " model is realized in " + (end - start) + " ms");
    }
}

