/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer;

import java.io.File;
import org.chasen.crfpp.CRFPPTrainer;
import org.grobid.core.GrobidModels;
import org.grobid.trainer.GenericTrainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRFPPGenericTrainer
implements GenericTrainer {
    public static final Logger LOGGER = LoggerFactory.getLogger(CRFPPGenericTrainer.class);
    public static final String CRF = "crf";
    private final CRFPPTrainer crfppTrainer = new CRFPPTrainer();
    private double epsilon = 1.0E-5;
    private int window = 20;

    @Override
    public void train(File template, File trainingData, File outputModel, int numThreads, GrobidModels model) {
        this.crfppTrainer.train(template.getAbsolutePath(), trainingData.getAbsolutePath(), outputModel.getAbsolutePath(), numThreads);
        if (!this.crfppTrainer.what().isEmpty()) {
            LOGGER.warn("CRF++ Trainer warnings:\n" + this.crfppTrainer.what());
        } else {
            LOGGER.info("No CRF++ Trainer warnings!");
        }
    }

    @Override
    public String getName() {
        return CRF;
    }

    @Override
    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public void setWindow(int window) {
        this.window = window;
    }

    @Override
    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public int getWindow() {
        return this.window;
    }
}

