/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.grobid.core.GrobidModels;
import org.grobid.core.exceptions.GrobidException;
import org.grobid.core.features.FeaturesVectorChemicalEntity;
import org.grobid.core.utilities.OffsetPosition;
import org.grobid.trainer.AbstractTrainer;
import org.grobid.trainer.sax.ChemicalClassNamesSaxParser;
import org.grobid.trainer.sax.ChemicalFormulasSaxParser;
import org.grobid.trainer.sax.ChemicalLigandSaxParser;
import org.grobid.trainer.sax.ChemicalNameSaxParser;
import org.grobid.trainer.sax.ChemicalSubstancesSaxParser;
import org.grobid.trainer.sax.ChemicalWordsSaxParser;
import org.xml.sax.helpers.DefaultHandler;

public class ChemicalEntityTrainer
extends AbstractTrainer {
    public ChemicalEntityTrainer() {
        super(GrobidModels.ENTITIES_CHEMISTRY);
    }

    public int createCRFPPData2(File corpusDir, File modelOutputPath) {
        return this.createCRFPPData(corpusDir, modelOutputPath, null, 1.0);
    }

    @Override
    public int createCRFPPData(File corpusDir, File trainingOutputPath, File evalOutputPath, double splitRatio) {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int createCRFPPData(File corpusDir, File trainingOutputPath) {
        int totalExamples = 0;
        try {
            System.out.println("corpusDir: " + corpusDir);
            System.out.println("trainingOutputPath: " + trainingOutputPath);
            File[] refFiles = corpusDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".words.xml") && name.startsWith("WO");
                }
            });
            if (refFiles == null) {
                return 0;
            }
            System.out.println(refFiles.length + " tei files");
            OutputStreamWriter writer2 = new OutputStreamWriter((OutputStream)new FileOutputStream(trainingOutputPath), "UTF8");
            SAXParserFactory spf = SAXParserFactory.newInstance();
            ArrayList<ArrayList<String>> chemicalAnnotations = null;
            ArrayList<ArrayList<String>> chemicalFormulas = null;
            ArrayList<ArrayList<String>> chemicalSubstances = null;
            ArrayList<ArrayList<String>> chemicalClassNames = null;
            ArrayList<ArrayList<String>> chemicalLigand = null;
            for (int n = 0; n < refFiles.length; ++n) {
                File file;
                File thefile = refFiles[n];
                if (thefile.getName().endsWith(".words.xml")) {
                    SAXParser p2;
                    String name = thefile.getName().replace(".words.xml", "");
                    System.out.println(name);
                    File theOtherFile = new File(thefile.getPath().replace(".words.xml", ".HC.chemical-names.xml"));
                    if (theOtherFile.exists()) {
                        ChemicalNameSaxParser parser2 = new ChemicalNameSaxParser();
                        SAXParser p = spf.newSAXParser();
                        p.parse(thefile, (DefaultHandler)parser2);
                        chemicalAnnotations = parser2.getChemicalAnnotations();
                        totalExamples += parser2.getNumberEntities();
                    }
                    if ((theOtherFile = new File(thefile.getPath().replace(".words.xml", ".HC.formula-names.xml"))).exists()) {
                        ChemicalFormulasSaxParser parser3 = new ChemicalFormulasSaxParser();
                        p2 = spf.newSAXParser();
                        p2.parse(theOtherFile, (DefaultHandler)parser3);
                        chemicalFormulas = parser3.getChemicalFormulas();
                        totalExamples += parser3.getNumberEntities();
                    }
                    if ((theOtherFile = new File(thefile.getPath().replace(".words.xml", ".HC.substance-names.xml"))).exists()) {
                        ChemicalSubstancesSaxParser parser4 = new ChemicalSubstancesSaxParser();
                        p2 = spf.newSAXParser();
                        p2.parse(theOtherFile, (DefaultHandler)parser4);
                        chemicalSubstances = parser4.getChemicalSubstances();
                        totalExamples += parser4.getNumberEntities();
                    }
                    if ((theOtherFile = new File(thefile.getPath().replace(".words.xml", ".HC.class-names.xml"))).exists()) {
                        ChemicalClassNamesSaxParser parser5 = new ChemicalClassNamesSaxParser();
                        p2 = spf.newSAXParser();
                        p2.parse(theOtherFile, (DefaultHandler)parser5);
                        chemicalClassNames = parser5.getChemicalClassNames();
                        totalExamples += parser5.getNumberEntities();
                    }
                    if ((theOtherFile = new File(thefile.getPath().replace(".words.xml", ".HC.ligand.xml"))).exists()) {
                        ChemicalLigandSaxParser parser6 = new ChemicalLigandSaxParser();
                        p2 = spf.newSAXParser();
                        p2.parse(theOtherFile, (DefaultHandler)parser6);
                        chemicalLigand = parser6.getChemicalLigand();
                        totalExamples += parser6.getNumberEntities();
                    }
                }
                ArrayList<String> chemicalAnnotationsList = new ArrayList<String>();
                ArrayList<String> chemicalAnnotationsStartsList = new ArrayList<String>();
                if (chemicalAnnotations != null) {
                    for (ArrayList arrayList : chemicalAnnotations) {
                        void var20_28;
                        String first = ((String)arrayList.get(0)).trim();
                        String string = ((String)arrayList.get(1)).trim();
                        if (first.length() > string.length()) {
                            String string2 = (String)arrayList.get(0);
                            first = (String)arrayList.get(1);
                        } else if (first.length() == string.length() && first.compareToIgnoreCase(string) > 0) {
                            String string3 = (String)arrayList.get(0);
                            first = (String)arrayList.get(1);
                        }
                        chemicalAnnotationsStartsList.add(first);
                        if (!var20_28.equals(first)) {
                            String next = first;
                            while (!next.equals(var20_28)) {
                                int n2 = next.lastIndexOf("_");
                                String numb = next.substring(n2 + 1, next.length());
                                try {
                                    Integer n3 = Integer.parseInt(numb);
                                    next = next.substring(0, n2 + 1) + (n3 + 1);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)numberFormatException);
                                }
                                if (next.equals(first)) continue;
                                chemicalAnnotationsList.add(next);
                            }
                        }
                        chemicalAnnotationsList.add((String)var20_28);
                    }
                }
                ArrayList<String> chemicalFormulasList = new ArrayList<String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (chemicalFormulas != null) {
                    for (ArrayList arrayList2 : chemicalFormulas) {
                        void var22_37;
                        String first = ((String)arrayList2.get(0)).trim();
                        String string = ((String)arrayList2.get(1)).trim();
                        if (first.length() > string.length()) {
                            String string4 = (String)arrayList2.get(0);
                            first = (String)arrayList2.get(1);
                        } else if (first.length() == string.length() && first.compareToIgnoreCase(string) > 0) {
                            String string5 = (String)arrayList2.get(0);
                            first = (String)arrayList2.get(1);
                        }
                        arrayList.add(first);
                        if (!var22_37.equals(first)) {
                            String next = first;
                            while (!next.equals(var22_37)) {
                                int n4 = next.lastIndexOf("_");
                                String numb = next.substring(n4 + 1, next.length());
                                try {
                                    Integer n5 = Integer.parseInt(numb);
                                    next = next.substring(0, n4 + 1) + (n5 + 1);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)numberFormatException);
                                }
                                if (next.equals(first)) continue;
                                chemicalFormulasList.add(next);
                            }
                        }
                        chemicalFormulasList.add((String)var22_37);
                    }
                }
                ArrayList<String> chemicalSubstancesList = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                if (chemicalSubstances != null) {
                    for (ArrayList arrayList4 : chemicalSubstances) {
                        void var24_49;
                        String first = ((String)arrayList4.get(0)).trim();
                        String string = ((String)arrayList4.get(1)).trim();
                        if (first.length() > string.length()) {
                            String string6 = (String)arrayList4.get(0);
                            first = (String)arrayList4.get(1);
                        } else if (first.length() == string.length() && first.compareToIgnoreCase(string) > 0) {
                            String string7 = (String)arrayList4.get(0);
                            first = (String)arrayList4.get(1);
                        }
                        arrayList3.add(first);
                        if (!var24_49.equals(first)) {
                            String next = first;
                            while (!next.equals(var24_49)) {
                                int n6 = next.lastIndexOf("_");
                                String numb = next.substring(n6 + 1, next.length());
                                try {
                                    Integer numbi = Integer.parseInt(numb);
                                    next = next.substring(0, n6 + 1) + (numbi + 1);
                                }
                                catch (NumberFormatException e) {
                                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
                                }
                                if (next.equals(first)) continue;
                                chemicalSubstancesList.add(next);
                            }
                        }
                        chemicalSubstancesList.add((String)var24_49);
                    }
                }
                ArrayList<String> chemicalClassNamesList = new ArrayList<String>();
                ArrayList<String> arrayList5 = new ArrayList<String>();
                if (chemicalClassNames != null) {
                    for (ArrayList arrayList6 : chemicalClassNames) {
                        void var26_62;
                        String first = ((String)arrayList6.get(0)).trim();
                        String string = ((String)arrayList6.get(1)).trim();
                        if (first.length() > string.length()) {
                            String string8 = (String)arrayList6.get(0);
                            first = (String)arrayList6.get(1);
                        } else if (first.length() == string.length() && first.compareToIgnoreCase(string) > 0) {
                            String string9 = (String)arrayList6.get(0);
                            first = (String)arrayList6.get(1);
                        }
                        arrayList5.add(first);
                        if (!var26_62.equals(first)) {
                            String next = first;
                            while (!next.equals(var26_62)) {
                                int ind = next.lastIndexOf("_");
                                String numb = next.substring(ind + 1, next.length());
                                try {
                                    Integer numbi = Integer.parseInt(numb);
                                    next = next.substring(0, ind + 1) + (numbi + 1);
                                }
                                catch (NumberFormatException e) {
                                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
                                }
                                if (next.equals(first)) continue;
                                chemicalClassNamesList.add(next);
                            }
                        }
                        chemicalClassNamesList.add((String)var26_62);
                    }
                }
                ArrayList<String> chemicalLigandList = new ArrayList<String>();
                ArrayList<String> arrayList7 = new ArrayList<String>();
                if (chemicalLigand != null) {
                    for (ArrayList arrayList8 : chemicalLigand) {
                        String first = ((String)arrayList8.get(0)).trim();
                        String last = ((String)arrayList8.get(1)).trim();
                        if (first.length() > last.length()) {
                            last = (String)arrayList8.get(0);
                            first = (String)arrayList8.get(1);
                        } else if (first.length() == last.length() && first.compareToIgnoreCase(last) > 0) {
                            last = (String)arrayList8.get(0);
                            first = (String)arrayList8.get(1);
                        }
                        arrayList7.add(first);
                        if (!last.equals(first)) {
                            String next = first;
                            while (!next.equals(last)) {
                                int ind = next.lastIndexOf("_");
                                String numb = next.substring(ind + 1, next.length());
                                try {
                                    Integer numbi = Integer.parseInt(numb);
                                    next = next.substring(0, ind + 1) + (numbi + 1);
                                }
                                catch (NumberFormatException e) {
                                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
                                }
                                if (next.equals(first)) continue;
                                chemicalLigandList.add(next);
                            }
                        }
                        chemicalLigandList.add(last);
                    }
                }
                ChemicalWordsSaxParser parser = new ChemicalWordsSaxParser();
                parser.setChemicalAnnotations(chemicalAnnotationsList, chemicalAnnotationsStartsList);
                parser.setChemicalFormulas(chemicalFormulasList, arrayList);
                parser.setChemicalSubstances(chemicalSubstancesList, arrayList3);
                parser.setChemicalClassNames(chemicalClassNamesList, arrayList5);
                parser.setChemicalLigand(chemicalLigandList, arrayList7);
                try {
                    file = new File(thefile.getParent() + "/" + thefile.getName().replace(".HC.chemical-names.xml", ".words.xml"));
                }
                catch (Exception e) {
                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
                }
                if (file == null) continue;
                SAXParser p = spf.newSAXParser();
                p.parse(file, (DefaultHandler)parser);
                List<String> labeled = parser.getLabeledResult();
                List<OffsetPosition> chemicalTokenPositions = null;
                List<OffsetPosition> chemicalNamesTokenPositions = null;
                this.addFeatures(labeled, writer2, chemicalTokenPositions, chemicalNamesTokenPositions);
                writer2.write("\n");
            }
            ((Writer)writer2).close();
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
        return totalExamples;
    }

    public void addFeatures(List<String> texts, Writer writer, List<OffsetPosition> chemicalTokenPositions, List<OffsetPosition> chemicalNamesTokenPositions) {
        int totalLine = texts.size();
        int posit = 0;
        boolean isChemicalToken = false;
        boolean isChemicalNameToken = false;
        try {
            for (String line : texts) {
                FeaturesVectorChemicalEntity featuresVector = FeaturesVectorChemicalEntity.addFeaturesChemicalEntities((String)line, (int)totalLine, (int)posit, (boolean)isChemicalToken, (boolean)isChemicalNameToken);
                if (featuresVector.label == null) continue;
                writer.write(featuresVector.printVector());
                writer.flush();
                ++posit;
            }
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ChemicalEntityTrainer trainer = new ChemicalEntityTrainer();
        AbstractTrainer.runTraining(trainer);
        AbstractTrainer.runEvaluation(trainer);
    }
}

