/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.grobid.core.GrobidModels;
import org.grobid.core.exceptions.GrobidException;
import org.grobid.core.features.FeaturesVectorName;
import org.grobid.core.mock.MockContext;
import org.grobid.core.utilities.GrobidProperties;
import org.grobid.trainer.AbstractTrainer;
import org.grobid.trainer.sax.TEIAuthorSaxParser;
import org.xml.sax.helpers.DefaultHandler;

public class NameCitationTrainer
extends AbstractTrainer {
    public NameCitationTrainer() {
        super(GrobidModels.NAMES_CITATION);
    }

    @Override
    public int createCRFPPData(File corpusDir, File modelOutputPath) {
        return this.createCRFPPData(corpusDir, modelOutputPath, null, 1.0);
    }

    @Override
    public int createCRFPPData(File corpusDir, File trainingOutputPath, File evalOutputPath, double splitRatio) {
        int totalExamples = 0;
        try {
            File[] refFiles;
            System.out.println("sourcePathLabel: " + corpusDir);
            if (trainingOutputPath != null) {
                System.out.println("outputPath for training data: " + trainingOutputPath);
            }
            if (evalOutputPath != null) {
                System.out.println("outputPath for evaluation data: " + evalOutputPath);
            }
            if ((refFiles = corpusDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            })) == null) {
                throw new IllegalStateException("Folder " + corpusDir.getAbsolutePath() + " does not seem to contain training data. Please check");
            }
            System.out.println(refFiles.length + " tei files");
            FileOutputStream os2 = null;
            OutputStreamWriter writer2 = null;
            if (trainingOutputPath != null) {
                os2 = new FileOutputStream(trainingOutputPath);
                writer2 = new OutputStreamWriter((OutputStream)os2, "UTF8");
            }
            FileOutputStream os3 = null;
            OutputStreamWriter writer3 = null;
            if (evalOutputPath != null) {
                os3 = new FileOutputStream(evalOutputPath);
                writer3 = new OutputStreamWriter((OutputStream)os3, "UTF8");
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            for (int n = 0; n < refFiles.length; ++n) {
                File teifile = refFiles[n];
                String name = teifile.getName();
                TEIAuthorSaxParser parser2 = new TEIAuthorSaxParser();
                SAXParser p = spf.newSAXParser();
                p.parse(teifile, (DefaultHandler)parser2);
                ArrayList<String> labeled = parser2.getLabeledResult();
                totalExamples += parser2.n;
                String names = FeaturesVectorName.addFeaturesName(labeled);
                String[] chunks = names.split("\n \n");
                for (int i = 0; i < chunks.length; ++i) {
                    String chunk = chunks[i];
                    if (writer2 == null && writer3 != null) {
                        writer3.write(chunk + "\n \n");
                    }
                    if (writer2 != null && writer3 == null) {
                        writer2.write(chunk + "\n \n");
                        continue;
                    }
                    if (Math.random() <= splitRatio) {
                        writer2.write(chunk + "\n \n");
                        continue;
                    }
                    writer3.write(chunk + "\n \n");
                }
            }
            if (writer2 != null) {
                ((Writer)writer2).close();
                ((OutputStream)os2).close();
            }
            if (writer3 != null) {
                ((Writer)writer3).close();
                ((OutputStream)os3).close();
            }
        }
        catch (Exception e) {
            throw new GrobidException("An exception occurred while running Grobid.", (Throwable)e);
        }
        return totalExamples;
    }

    public static void main(String[] args) throws Exception {
        MockContext.setInitialContext();
        GrobidProperties.getInstance();
        NameCitationTrainer trainer = new NameCitationTrainer();
        AbstractTrainer.runTraining(trainer);
        AbstractTrainer.runEvaluation(trainer);
        MockContext.destroyInitialContext();
    }
}

