/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer;

import java.io.File;
import org.grobid.core.mock.MockContext;
import org.grobid.core.utilities.GrobidProperties;
import org.grobid.trainer.AbstractTrainer;
import org.grobid.trainer.AffiliationAddressTrainer;
import org.grobid.trainer.ChemicalEntityTrainer;
import org.grobid.trainer.CitationTrainer;
import org.grobid.trainer.DateTrainer;
import org.grobid.trainer.EbookTrainer;
import org.grobid.trainer.FulltextTrainer;
import org.grobid.trainer.HeaderTrainer;
import org.grobid.trainer.NameCitationTrainer;
import org.grobid.trainer.NameHeaderTrainer;
import org.grobid.trainer.PatentParserTrainer;
import org.grobid.trainer.ReferenceSegmenterTrainer;
import org.grobid.trainer.SegmentationTrainer;

public class TrainerRunner {
    protected static void initProcess(String path2GbdHome, String path2GbdProperties) {
        try {
            MockContext.setInitialContext((String)path2GbdHome, (String)path2GbdProperties);
        }
        catch (Exception exp) {
            System.err.println("Grobid initialisation failed: " + exp);
        }
        GrobidProperties.getInstance();
    }

    public static void main(String[] args) {
        AbstractTrainer trainer;
        if (args.length < 4) {
            throw new IllegalStateException("Usage: {0 - train, 1 - evaluate, 2 - split, train and evaluate} {affiliation,chemical,date,citation,ebook,fulltext,header,name-citation,name-header,patent} -gH /path/to/Grobid/home -s { [0.0 - 1.0] - split ratio, optional}");
        }
        RunType mode = RunType.getRunType(Integer.parseInt(args[0]));
        if (mode == RunType.SPLIT && args.length < 6) {
            throw new IllegalStateException("Usage: {0 - train, 1 - evaluate, 2 - split, train and evaluate} {affiliation,chemical,date,citation,ebook,fulltext,header,name-citation,name-header,patent} -gH /path/to/Grobid/home -s { [0.0 - 1.0] - split ratio, optional}");
        }
        String path2GbdHome = null;
        Double split = 0.0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-gH")) {
                if (i + 1 == args.length) {
                    throw new IllegalStateException("Missing path to Grobid home. ");
                }
                path2GbdHome = args[i + 1];
                continue;
            }
            if (!args[i].equals("-s")) continue;
            if (i + 1 == args.length) {
                throw new IllegalStateException("Missing split ratio value. ");
            }
            String splitRatio = args[i + 1];
            try {
                split = Double.parseDouble(args[i + 1]);
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid split value: " + args[i + 1]);
            }
        }
        if (path2GbdHome == null) {
            throw new IllegalStateException("Usage: {0 - train, 1 - evaluate, 2 - split, train and evaluate} {affiliation,chemical,date,citation,ebook,fulltext,header,name-citation,name-header,patent} -gH /path/to/Grobid/home -s { [0.0 - 1.0] - split ratio, optional}");
        }
        String path2GbdProperties = path2GbdHome + File.separator + "config" + File.separator + "grobid.properties";
        System.out.println("path2GbdHome=" + path2GbdHome + "   path2GbdProperties=" + path2GbdProperties);
        TrainerRunner.initProcess(path2GbdHome, path2GbdProperties);
        String model = args[1];
        if (model.equals("affiliation") || model.equals("affiliation-address")) {
            trainer = new AffiliationAddressTrainer();
        } else if (model.equals("chemical")) {
            trainer = new ChemicalEntityTrainer();
        } else if (model.equals("date")) {
            trainer = new DateTrainer();
        } else if (model.equals("citation")) {
            trainer = new CitationTrainer();
        } else if (model.equals("ebook")) {
            trainer = new EbookTrainer();
        } else if (model.equals("fulltext")) {
            trainer = new FulltextTrainer();
        } else if (model.equals("header")) {
            trainer = new HeaderTrainer();
        } else if (model.equals("name-citation")) {
            trainer = new NameCitationTrainer();
        } else if (model.equals("name-header")) {
            trainer = new NameHeaderTrainer();
        } else if (model.equals("patent")) {
            trainer = new PatentParserTrainer();
        } else if (model.equals("segmentation")) {
            trainer = new SegmentationTrainer();
        } else if (model.equals("reference-segmenter")) {
            trainer = new ReferenceSegmenterTrainer();
        } else {
            throw new IllegalStateException("The model " + model + " is unknown.");
        }
        switch (mode) {
            case TRAIN: {
                AbstractTrainer.runTraining(trainer);
                break;
            }
            case EVAL: {
                AbstractTrainer.runEvaluation(trainer);
                break;
            }
            case SPLIT: {
                AbstractTrainer.runSplitTrainingEvaluation(trainer, split);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid RunType: " + mode.name());
            }
        }
    }

    static enum RunType {
        TRAIN,
        EVAL,
        SPLIT;


        public static RunType getRunType(int i) {
            for (RunType t : RunType.values()) {
                if (t.ordinal() != i) continue;
                return t;
            }
            throw new IllegalStateException("Unsupported RunType with ordinal " + i);
        }
    }
}

