/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer;

import java.io.File;
import java.math.BigDecimal;
import org.grobid.core.GrobidModels;
import org.grobid.core.jni.WapitiModel;
import org.grobid.trainer.GenericTrainer;

public class WapitiTrainer
implements GenericTrainer {
    public static final String WAPITI = "wapiti";
    private double epsilon = 1.0E-5;
    private int window = 20;

    @Override
    public void train(File template, File trainingData, File outputModel, int numThreads, GrobidModels model) {
        System.out.println("epsilon: " + this.epsilon);
        System.out.println("window: " + this.window);
        System.out.println("nb threads: " + numThreads);
        WapitiModel.train((File)template, (File)trainingData, (File)outputModel, (String)("--nthread " + numThreads + " -e " + BigDecimal.valueOf(this.epsilon).toPlainString() + " -w " + this.window + ""));
    }

    @Override
    public String getName() {
        return WAPITI;
    }

    @Override
    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public void setWindow(int window) {
        this.window = window;
    }

    @Override
    public double getEpsilon() {
        return this.epsilon;
    }

    @Override
    public int getWindow() {
        return this.window;
    }
}

