/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.evaluation;

import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.grobid.core.engines.CitationParser;
import org.grobid.core.engines.EngineParsers;
import org.grobid.core.exceptions.GrobidException;
import org.grobid.core.features.FeaturesVectorCitation;
import org.grobid.core.utilities.OffsetPosition;
import org.grobid.trainer.sax.TEICitationSaxParser;
import org.grobid.trainer.sax.TEIHeaderSaxParser;
import org.xml.sax.helpers.DefaultHandler;

public class Evaluation {
    private CitationParser citationParser = null;
    private String evaluationCitationPath = null;
    private String evaluationHeaderPathTEI = null;

    private void setPropertyInfo() {
    }

    public Evaluation() {
        this.setPropertyInfo();
    }

    public String evaluateCitation() {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> counterObserved = new ArrayList<Integer>();
        ArrayList<Integer> counterExpected = new ArrayList<Integer>();
        ArrayList<Integer> counterFalsePositive = new ArrayList<Integer>();
        ArrayList<Integer> counterFalseNegative = new ArrayList<Integer>();
        StringBuilder report = new StringBuilder();
        try {
            int i;
            if (this.citationParser == null) {
                this.citationParser = new CitationParser(new EngineParsers());
            }
            TEICitationSaxParser parser = new TEICitationSaxParser();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser par = spf.newSAXParser();
            par.parse(this.evaluationCitationPath, (DefaultHandler)parser);
            ArrayList<String> labeled = parser.getLabeledResult();
            int nbTestExamples = parser.nbCitations;
            System.out.println(nbTestExamples + " evaluation text reference strings.");
            List<List<OffsetPosition>> journalsPositions = parser.journalsPositions;
            List<List<OffsetPosition>> abbrevJournalsPositions = parser.abbrevJournalsPositions;
            List<List<OffsetPosition>> conferencesPositions = parser.conferencesPositions;
            List<List<OffsetPosition>> publishersPositions = parser.publishersPositions;
            String citation = FeaturesVectorCitation.addFeaturesCitation(labeled, journalsPositions, abbrevJournalsPositions, conferencesPositions, publishersPositions);
            String res = this.citationParser.label(citation);
            StringTokenizer st = new StringTokenizer(res, "\n");
            int z = 0;
            while (st.hasMoreTokens()) {
                Integer newCount;
                Integer count;
                String l2 = labeled.get(z).trim();
                if (l2.length() == 0) {
                    l2 = labeled.get(++z).trim();
                }
                String l = st.nextToken();
                StringTokenizer st2 = new StringTokenizer(l, "\t");
                String obtainedLabel = null;
                String expectedLabel = null;
                while (st2.hasMoreTokens()) {
                    obtainedLabel = st2.nextToken().trim();
                    if (!obtainedLabel.startsWith("I-")) continue;
                    obtainedLabel = obtainedLabel.substring(2, obtainedLabel.length());
                }
                int ind = l2.indexOf(" ");
                if (ind != -1 && (expectedLabel = l2.substring(ind, l2.length()).trim()).startsWith("I-")) {
                    expectedLabel = expectedLabel.substring(2, expectedLabel.length());
                }
                if (expectedLabel == null | obtainedLabel == null) continue;
                int indbis = labels.indexOf(expectedLabel);
                if (indbis != -1) {
                    Integer newCount2;
                    Integer count2;
                    if (expectedLabel.equals(obtainedLabel)) {
                        count2 = (Integer)counterObserved.get(indbis);
                        newCount2 = count2 + 1;
                        counterObserved.set(indbis, newCount2);
                    } else {
                        int ind2 = labels.indexOf(obtainedLabel);
                        if (ind2 != -1) {
                            count = (Integer)counterFalsePositive.get(ind2);
                            newCount = count + 1;
                            counterFalsePositive.set(ind2, newCount);
                        } else {
                            labels.add(obtainedLabel);
                            counterFalsePositive.add(1);
                            counterObserved.add(0);
                            counterExpected.add(0);
                            counterFalseNegative.add(0);
                        }
                        Integer count22 = (Integer)counterFalseNegative.get(indbis);
                        Integer newCount22 = count22 + 1;
                        counterFalseNegative.set(indbis, newCount22);
                    }
                    count2 = (Integer)counterExpected.get(indbis);
                    newCount2 = count2 + 1;
                    counterExpected.set(indbis, newCount2);
                } else {
                    labels.add(expectedLabel);
                    if (expectedLabel.equals(obtainedLabel)) {
                        counterObserved.add(1);
                        counterFalsePositive.add(0);
                        counterFalseNegative.add(0);
                    } else {
                        counterObserved.add(0);
                        counterFalsePositive.add(0);
                        counterFalseNegative.add(1);
                        int ind2 = labels.indexOf(obtainedLabel);
                        if (ind2 != -1) {
                            count = (Integer)counterFalsePositive.get(ind2);
                            newCount = count + 1;
                            counterFalsePositive.set(ind2, newCount);
                        } else {
                            labels.add(obtainedLabel);
                            counterFalsePositive.add(1);
                            counterObserved.add(0);
                            counterExpected.add(0);
                            counterFalseNegative.add(0);
                        }
                    }
                    counterExpected.add(1);
                }
                ++z;
            }
            report.append("\nWord-level results\n");
            report.append("\nlabel\t\taccuracy\tprecision\trecall\t\tf1\n\n");
            int cumulated_tp = 0;
            int cumulated_fp = 0;
            int cumulated_tn = 0;
            int cumulated_fn = 0;
            double cumulated_f0 = 0.0;
            int totalTokens = 0;
            DecimalFormat df = new DecimalFormat("#.####");
            for (i = 0; i < labels.size(); ++i) {
                totalTokens += ((Integer)counterExpected.get(i)).intValue();
            }
            System.out.println("total: " + totalTokens + " tokens.");
            for (i = 0; i < labels.size(); ++i) {
                String label = (String)labels.get(i);
                report.append(label);
                if (label.length() <= 11) {
                    report.append("\t");
                }
                int tp = (Integer)counterObserved.get(i);
                int fp = (Integer)counterFalsePositive.get(i);
                int fn = (Integer)counterFalseNegative.get(i);
                int tn = totalTokens - tp - (fp + fn);
                double accuracy = (double)(tp + tn) / (double)(tp + fp + tn + fn);
                report.append("\t").append(df.format(accuracy));
                double precision = (double)tp / (double)(tp + fp);
                report.append("\t\t").append(df.format(precision));
                double recall = (double)tp / (double)(tp + fn);
                report.append("\t\t").append(df.format(recall));
                double f0 = 2.0 * precision * recall / (precision + recall);
                report.append("\t\t").append(df.format(f0));
                report.append("\n");
                cumulated_tp += tp;
                cumulated_fp += fp;
                cumulated_tn += tn;
                cumulated_fn += fn;
                cumulated_f0 += f0;
            }
            report.append("\n");
            report.append("all labels\t");
            double accuracy = (double)(cumulated_tp + cumulated_tn) / (double)(cumulated_tp + cumulated_fp + cumulated_tn + cumulated_fn);
            report.append("\t").append(df.format(accuracy));
            double precision = (double)cumulated_tp / (double)(cumulated_tp + cumulated_fp);
            report.append("\t\t").append(df.format(precision));
            double recall = (double)cumulated_tp / (double)(cumulated_tp + cumulated_fn);
            report.append("\t\t").append(df.format(recall));
            double f0 = cumulated_f0 / (double)labels.size();
            report.append("\t\t").append(df.format(f0));
            report.append("\n");
        }
        catch (Exception e) {
            throw new GrobidException("An exception occurred while running Grobid.", (Throwable)e);
        }
        return report.toString();
    }

    public String evaluateHeader() {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> counterObserved = new ArrayList<Integer>();
        ArrayList<Integer> counterExpected = new ArrayList<Integer>();
        ArrayList<Integer> counterFalsePositive = new ArrayList<Integer>();
        ArrayList<Integer> counterFalseNegative = new ArrayList<Integer>();
        StringBuilder report = new StringBuilder();
        try {
            int i;
            File file = new File(this.evaluationHeaderPathTEI);
            File[] refFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".tei");
                }
            });
            if (refFiles == null) {
                return null;
            }
            for (int n = 0; n < refFiles.length; ++n) {
                Integer newCount;
                Integer count;
                File teifile = refFiles[n];
                String name = teifile.getName();
                TEIHeaderSaxParser parser2 = new TEIHeaderSaxParser();
                parser2.setFileName(name);
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser par = spf.newSAXParser();
                par.parse(teifile, (DefaultHandler)parser2);
                String l = "";
                if (l.length() == 0) continue;
                StringTokenizer st = new StringTokenizer(l, "\t");
                String currentToken = null;
                String previousToken = null;
                while (st.hasMoreTokens()) {
                    currentToken = st.nextToken();
                    if (!st.hasMoreTokens()) continue;
                    previousToken = currentToken;
                }
                if (previousToken == null | currentToken == null) continue;
                int ind = labels.indexOf(previousToken);
                if (ind != -1) {
                    Integer newCount2;
                    Integer count2;
                    if (previousToken.equals(currentToken)) {
                        count2 = (Integer)counterObserved.get(ind);
                        newCount2 = count2 + 1;
                        counterObserved.set(ind, newCount2);
                    } else {
                        int ind2 = labels.indexOf(currentToken);
                        if (ind2 != -1) {
                            count = (Integer)counterFalsePositive.get(ind2);
                            newCount = count + 1;
                            counterFalsePositive.set(ind2, newCount);
                        } else {
                            labels.add(currentToken);
                            counterFalsePositive.add(1);
                            counterObserved.add(0);
                            counterExpected.add(0);
                            counterFalseNegative.add(0);
                        }
                        Integer count22 = (Integer)counterFalseNegative.get(ind);
                        Integer newCount22 = count22 + 1;
                        counterFalseNegative.set(ind, newCount22);
                    }
                    count2 = (Integer)counterExpected.get(ind);
                    newCount2 = count2 + 1;
                    counterExpected.set(ind, newCount2);
                    continue;
                }
                labels.add(previousToken);
                if (previousToken.equals(currentToken)) {
                    counterObserved.add(1);
                    counterFalsePositive.add(0);
                    counterFalseNegative.add(0);
                } else {
                    counterObserved.add(0);
                    counterFalsePositive.add(0);
                    counterFalseNegative.add(1);
                    int ind2 = labels.indexOf(currentToken);
                    if (ind2 != -1) {
                        count = (Integer)counterFalsePositive.get(ind2);
                        newCount = count + 1;
                        counterFalsePositive.set(ind2, newCount);
                    } else {
                        labels.add(currentToken);
                        counterFalsePositive.add(1);
                        counterObserved.add(0);
                        counterExpected.add(0);
                        counterFalseNegative.add(0);
                    }
                }
                counterExpected.add(1);
            }
            report.append("\nWord-level results\n");
            report.append("\nlabel\t\taccuracy\tprecision\trecall\t\tf1\n\n");
            int cumulated_tp = 0;
            int cumulated_fp = 0;
            int cumulated_tn = 0;
            int cumulated_fn = 0;
            double cumulated_f0 = 0.0;
            int totalTokens = 0;
            DecimalFormat df = new DecimalFormat("#.####");
            for (i = 0; i < labels.size(); ++i) {
                totalTokens += ((Integer)counterExpected.get(i)).intValue();
            }
            System.out.println("total: " + totalTokens);
            for (i = 0; i < labels.size(); ++i) {
                String label = (String)labels.get(i);
                report.append(label);
                if (label.length() < 11) {
                    report.append("\t");
                }
                int tp = (Integer)counterObserved.get(i);
                int fp = (Integer)counterFalsePositive.get(i);
                int fn = (Integer)counterFalseNegative.get(i);
                int tn = totalTokens - tp - (fp + fn);
                int all = (Integer)counterExpected.get(i);
                System.out.println(label + "*****: " + "true positives: " + tp + "\nfalse positives:" + fp + "\ntrue negatives: " + tn + "\nfalse negatives: " + fn);
                System.out.println("all: " + all);
                double accuracy = (double)(tp + tn) / (double)(tp + fp + tn + fn);
                report.append("\t").append(df.format(accuracy));
                double precision = (double)tp / (double)(tp + fp);
                report.append("\t\t").append(df.format(precision));
                double recall = (double)tp / (double)(tp + fn);
                report.append("\t\t").append(df.format(recall));
                double f0 = 2.0 * precision * recall / (precision + recall);
                report.append("\t\t").append(df.format(f0));
                report.append("\n");
                cumulated_tp += tp;
                cumulated_fp += fp;
                cumulated_tn += tn;
                cumulated_fn += fn;
                cumulated_f0 += f0;
            }
            report.append("\n");
            report.append("all labels\t");
            double accuracy = (double)(cumulated_tp + cumulated_tn) / (double)(cumulated_tp + cumulated_fp + cumulated_tn + cumulated_fn);
            report.append("\t").append(df.format(accuracy));
            double precision = (double)cumulated_tp / (double)(cumulated_tp + cumulated_fp);
            report.append("\t\t").append(df.format(precision));
            double recall = (double)cumulated_tp / (double)(cumulated_tp + cumulated_fn);
            report.append("\t\t").append(df.format(recall));
            double f0 = cumulated_f0 / (double)labels.size();
            report.append("\t\t").append(df.format(f0));
            report.append("\n");
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
        return report.toString();
    }

    public static void main(String[] args) {
        Evaluation util;
        try {
            util = new Evaluation();
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
        if (args.length > 0) {
            try {
                if (args[0].equals("citation")) {
                    System.out.print("Evaluate results for " + args[0] + " model\n");
                    System.out.println(util.evaluateCitation());
                } else if (args[0].equals("header")) {
                    System.out.print("Evaluate results for " + args[0] + " model\n");
                    System.out.println(util.evaluateHeader());
                }
            }
            catch (Exception e) {
                throw new GrobidException("An exception occurred while running Grobid.", (Throwable)e);
            }
        }
    }
}

