/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.evaluation;

import com.google.common.base.Function;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.chasen.crfpp.Tagger;
import org.grobid.core.engines.tagging.GenericTagger;
import org.grobid.core.engines.tagging.GrobidCRFEngine;
import org.grobid.core.exceptions.GrobidException;
import org.grobid.core.utilities.GrobidProperties;
import org.grobid.core.utilities.TextUtilities;

public class EvaluationUtilities {
    public static String taggerRun(List<String> ress, Tagger tagger) {
        tagger.clear();
        StringBuilder res = new StringBuilder();
        ArrayList<String> pretags = new ArrayList<String>();
        for (String piece : ress) {
            if (piece.trim().length() == 0) {
                if (!tagger.parse()) {
                    throw new RuntimeException("CRF++ parsing failed.");
                }
                int i = 0;
                while ((long)i < tagger.size()) {
                    int j = 0;
                    while ((long)j < tagger.xsize()) {
                        res.append(tagger.x((long)i, (long)j)).append("\t");
                        ++j;
                    }
                    res.append((String)pretags.get(i)).append("\t");
                    res.append(tagger.y2((long)i));
                    res.append("\n");
                    ++i;
                }
                res.append(" \n");
                tagger.clear();
                pretags = new ArrayList();
                continue;
            }
            tagger.add(piece);
            tagger.add("\n");
            StringTokenizer tokenizer = new StringTokenizer(piece, " \t");
            while (tokenizer.hasMoreTokens()) {
                String toke = tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) continue;
                pretags.add(toke);
            }
        }
        if (!tagger.parse()) {
            throw new RuntimeException("CRF++ parsing failed.");
        }
        int i = 0;
        while ((long)i < tagger.size()) {
            int j = 0;
            while ((long)j < tagger.xsize()) {
                res.append(tagger.x((long)i, (long)j)).append("\t");
                ++j;
            }
            res.append((String)pretags.get(i)).append("\t");
            res.append(tagger.y2((long)i));
            res.append("\n");
            ++i;
        }
        res.append("\n");
        return res.toString();
    }

    public static String evaluateStandard(String path, final GenericTagger tagger) {
        return EvaluationUtilities.evaluateStandard(path, new Function<List<String>, String>(){

            public String apply(List<String> strings) {
                return tagger.label(strings);
            }
        });
    }

    public static String evaluateStandard(String path, Function<List<String>, String> taggerFunction) {
        StringBuilder report = new StringBuilder();
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> counterObserved = new ArrayList<Integer>();
        ArrayList<Integer> counterExpected = new ArrayList<Integer>();
        ArrayList<Integer> counterFalsePositive = new ArrayList<Integer>();
        ArrayList<Integer> counterFalseNegative = new ArrayList<Integer>();
        ArrayList<String> labels2 = new ArrayList<String>();
        ArrayList<Integer> counterObserved2 = new ArrayList<Integer>();
        ArrayList<Integer> counterExpected2 = new ArrayList<Integer>();
        ArrayList<Integer> counterFalsePositive2 = new ArrayList<Integer>();
        ArrayList<Integer> counterFalseNegative2 = new ArrayList<Integer>();
        try {
            Integer val;
            BufferedReader bufReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            String theResult = null;
            String line = null;
            long time = 0L;
            ArrayList<String> citationBlocks = new ArrayList<String>();
            ArrayList<String> expected = new ArrayList<String>();
            if (GrobidProperties.getGrobidCRFEngine() == GrobidCRFEngine.CRFPP) {
                StringBuffer buffer = new StringBuffer();
                time = System.currentTimeMillis();
                while ((line = bufReader.readLine()) != null) {
                    if (line.trim().length() == 0) {
                        buffer.append((String)taggerFunction.apply(citationBlocks));
                        buffer.append("\n");
                        citationBlocks = new ArrayList();
                        continue;
                    }
                    citationBlocks.add(line);
                    int ind = line.lastIndexOf(" ");
                    if (ind == -1) {
                        ind = line.lastIndexOf("\t");
                    }
                    if (ind == -1) continue;
                    expected.add(line.substring(ind + 1, line.length()));
                }
                theResult = buffer.toString();
            } else {
                while ((line = bufReader.readLine()) != null) {
                    citationBlocks.add(line);
                }
                time = System.currentTimeMillis();
                theResult = (String)taggerFunction.apply(citationBlocks);
            }
            bufReader.close();
            System.out.println("Labeling took: " + (System.currentTimeMillis() - time) + " ms");
            StringTokenizer stt = new StringTokenizer(theResult, "\n");
            int e = 0;
            while (stt.hasMoreTokens()) {
                Integer count;
                line = stt.nextToken();
                if (line.trim().length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line, "\t ");
                String currentToken = null;
                String previousToken = null;
                while (st.hasMoreTokens()) {
                    currentToken = st.nextToken();
                    if (currentToken != null && (currentToken.startsWith("I-") || currentToken.startsWith("E-"))) {
                        currentToken = currentToken.substring(2, currentToken.length());
                    }
                    if (!st.hasMoreTokens()) continue;
                    previousToken = currentToken;
                }
                if (GrobidProperties.getGrobidCRFEngine() == GrobidCRFEngine.CRFPP) {
                    previousToken = (String)expected.get(e);
                    if (previousToken.startsWith("I-") || previousToken.startsWith("E-")) {
                        previousToken = previousToken.substring(2, previousToken.length());
                    }
                    ++e;
                }
                if (previousToken == null || currentToken == null) continue;
                int ind = labels.indexOf(previousToken);
                if (ind != -1) {
                    Integer count2;
                    if (previousToken.equals(currentToken)) {
                        count2 = counterObserved.get(ind);
                        counterObserved.set(ind, count2 + 1);
                    } else {
                        int ind2 = labels.indexOf(currentToken);
                        if (ind2 != -1) {
                            count = counterFalsePositive.get(ind2);
                            counterFalsePositive.set(ind2, count + 1);
                        } else {
                            labels.add(currentToken);
                            counterFalsePositive.add(1);
                            counterObserved.add(0);
                            counterExpected.add(0);
                            counterFalseNegative.add(0);
                        }
                        Integer count22 = counterFalseNegative.get(ind);
                        counterFalseNegative.set(ind, count22 + 1);
                    }
                    count2 = counterExpected.get(ind);
                    counterExpected.set(ind, count2 + 1);
                    continue;
                }
                labels.add(previousToken);
                if (previousToken.equals(currentToken)) {
                    counterObserved.add(1);
                    counterFalsePositive.add(0);
                    counterFalseNegative.add(0);
                } else {
                    counterObserved.add(0);
                    counterFalsePositive.add(0);
                    counterFalseNegative.add(1);
                    int ind2 = labels.indexOf(currentToken);
                    if (ind2 != -1) {
                        count = counterFalsePositive.get(ind2);
                        Integer newCount = count + 1;
                        counterFalsePositive.set(ind2, newCount);
                    } else {
                        labels.add(currentToken);
                        counterFalsePositive.add(1);
                        counterObserved.add(0);
                        counterExpected.add(0);
                        counterFalseNegative.add(0);
                    }
                }
                counterExpected.add(1);
            }
            bufReader.close();
            boolean i = false;
            report.append("\n===== Token-level results =====\n\n");
            report.append(EvaluationUtilities.computeMetrics(labels, counterObserved, counterExpected, counterFalsePositive, counterFalseNegative));
            boolean allGood = true;
            String lastPreviousToken = null;
            String lastCurrentToken = null;
            stt = new StringTokenizer(theResult, "\n");
            e = 0;
            while (stt.hasMoreTokens()) {
                Integer val2;
                int index;
                line = stt.nextToken();
                if (line.trim().length() == 0 && lastPreviousToken != null && lastCurrentToken != null) {
                    int index2 = labels2.indexOf(lastPreviousToken);
                    if (index2 == -1) {
                        labels2.add(lastPreviousToken);
                        counterObserved2.add(0);
                        counterExpected2.add(0);
                        counterFalsePositive2.add(0);
                        counterFalseNegative2.add(0);
                        index2 = labels2.indexOf(lastPreviousToken);
                    }
                    if (allGood) {
                        val = counterObserved2.get(index2);
                        counterObserved2.set(index2, val + 1);
                    } else {
                        val = counterFalseNegative2.get(index2);
                        counterFalseNegative2.set(index2, val + 1);
                    }
                    val = counterExpected2.get(index2);
                    counterExpected2.set(index2, val + 1);
                    index2 = labels2.indexOf(lastCurrentToken);
                    if (index2 == -1) {
                        labels2.add(lastCurrentToken);
                        counterObserved2.add(0);
                        counterExpected2.add(0);
                        counterFalsePositive2.add(0);
                        counterFalseNegative2.add(0);
                        index2 = labels2.indexOf(lastCurrentToken);
                    }
                    if (!allGood) {
                        val = counterFalsePositive2.get(index2);
                        counterFalsePositive2.set(index2, val + 1);
                    }
                    allGood = true;
                    lastPreviousToken = null;
                    lastCurrentToken = null;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, "\t ");
                String currentToken = null;
                String previousToken = null;
                while (st.hasMoreTokens()) {
                    currentToken = st.nextToken();
                    if (currentToken != null && (currentToken.startsWith("I-") || currentToken.startsWith("E-"))) {
                        currentToken = currentToken.substring(2, currentToken.length());
                    }
                    if (!st.hasMoreTokens()) continue;
                    previousToken = currentToken;
                }
                if (GrobidProperties.getGrobidCRFEngine() == GrobidCRFEngine.CRFPP) {
                    previousToken = (String)expected.get(e);
                    if (previousToken.startsWith("I-") || previousToken.startsWith("E-")) {
                        previousToken = previousToken.substring(2, previousToken.length());
                    }
                    ++e;
                }
                if (previousToken == null || currentToken == null) {
                    lastPreviousToken = null;
                    lastCurrentToken = null;
                    continue;
                }
                if (lastPreviousToken != null && !previousToken.equals(lastPreviousToken)) {
                    if (!labels2.contains(lastPreviousToken)) {
                        labels2.add(lastPreviousToken);
                        counterObserved2.add(0);
                        counterExpected2.add(0);
                        counterFalsePositive2.add(0);
                        counterFalseNegative2.add(0);
                    }
                    index = labels2.indexOf(lastPreviousToken);
                    if (allGood) {
                        val2 = counterObserved2.get(index);
                        counterObserved2.set(index, val2 + 1);
                    } else {
                        val2 = counterFalseNegative2.get(index);
                        counterFalseNegative2.set(index, val2 + 1);
                    }
                    val2 = counterExpected2.get(index);
                    counterExpected2.set(index, val2 + 1);
                }
                if (lastCurrentToken != null && !currentToken.equals(lastCurrentToken)) {
                    if (!labels2.contains(lastCurrentToken)) {
                        labels2.add(lastCurrentToken);
                        counterObserved2.add(0);
                        counterExpected2.add(0);
                        counterFalsePositive2.add(0);
                        counterFalseNegative2.add(0);
                    }
                    index = labels2.indexOf(lastCurrentToken);
                    if (!allGood) {
                        val2 = counterFalsePositive2.get(index);
                        counterFalsePositive2.set(index, val2 + 1);
                    }
                }
                if (lastPreviousToken != null && !previousToken.equals(lastPreviousToken) || lastCurrentToken != null && !currentToken.equals(lastCurrentToken)) {
                    allGood = true;
                }
                if (!currentToken.equals(previousToken)) {
                    allGood = false;
                }
                lastPreviousToken = previousToken;
                lastCurrentToken = currentToken;
            }
            if (lastPreviousToken != null && lastCurrentToken != null) {
                int index = labels2.indexOf(lastPreviousToken);
                if (index == -1) {
                    labels2.add(lastPreviousToken);
                    counterObserved2.add(0);
                    counterExpected2.add(0);
                    counterFalsePositive2.add(0);
                    counterFalseNegative2.add(0);
                    index = labels2.indexOf(lastPreviousToken);
                }
                if (allGood) {
                    val = counterObserved2.get(index);
                    counterObserved2.set(index, val + 1);
                } else {
                    val = counterFalseNegative2.get(index);
                    counterFalseNegative2.set(index, val + 1);
                }
                val = counterExpected2.get(index);
                counterExpected2.set(index, val + 1);
                index = labels2.indexOf(lastCurrentToken);
                if (index == -1) {
                    labels2.add(lastCurrentToken);
                    counterObserved2.add(0);
                    counterExpected2.add(0);
                    counterFalsePositive2.add(0);
                    counterFalseNegative2.add(0);
                    index = labels2.indexOf(lastCurrentToken);
                }
                if (!allGood) {
                    val = counterFalsePositive2.get(index);
                    counterFalsePositive2.set(index, val + 1);
                }
            }
            report.append("\n===== Field-level results =====\n");
            report.append(EvaluationUtilities.computeMetrics(labels2, counterObserved2, counterExpected2, counterFalsePositive2, counterFalseNegative2));
            theResult = theResult.replace("\n\n", "\n \n");
            stt = new StringTokenizer(theResult, "\n");
            allGood = true;
            int correctInstance = 0;
            int totalInstance = 0;
            e = 0;
            while (stt.hasMoreTokens()) {
                line = stt.nextToken();
                if (line.trim().length() == 0 || !stt.hasMoreTokens()) {
                    ++totalInstance;
                    if (allGood) {
                        ++correctInstance;
                    }
                    allGood = true;
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, "\t ");
                String currentToken = null;
                String previousToken = null;
                while (st.hasMoreTokens()) {
                    currentToken = st.nextToken();
                    if (currentToken != null && (currentToken.startsWith("I-") || currentToken.startsWith("E-"))) {
                        currentToken = currentToken.substring(2, currentToken.length());
                    }
                    if (!st.hasMoreTokens()) continue;
                    previousToken = currentToken;
                }
                if (GrobidProperties.getGrobidCRFEngine() == GrobidCRFEngine.CRFPP) {
                    previousToken = (String)expected.get(e);
                    if (previousToken.startsWith("I-") || previousToken.startsWith("E-")) {
                        previousToken = previousToken.substring(2, previousToken.length());
                    }
                    ++e;
                }
                if (currentToken.equals(previousToken)) continue;
                allGood = false;
            }
            report.append("\n===== Instance-level results =====\n\n");
            report.append("Total expected instances: \t\t").append(totalInstance).append("\n");
            report.append("Correct instances: \t\t").append(correctInstance).append("\n");
            double accuracy = (double)correctInstance / (double)totalInstance;
            report.append("Instance-level recall:\t").append(TextUtilities.formatTwoDecimals((double)(accuracy * 100.0))).append("\n\n");
        }
        catch (Exception e) {
            throw new GrobidException("An exception occurred while evaluating Grobid.", (Throwable)e);
        }
        return report.toString();
    }

    public static String computeMetrics(List<String> labels, List<Integer> counterObserved, List<Integer> counterExpected, List<Integer> counterFalsePositive, List<Integer> counterFalseNegative) {
        int i;
        StringBuilder report = new StringBuilder();
        report.append("\nlabel\t\taccuracy\tprecision\trecall\t\tf1\n\n");
        int cumulated_tp = 0;
        int cumulated_fp = 0;
        int cumulated_tn = 0;
        int cumulated_fn = 0;
        double cumulated_f0 = 0.0;
        double cumulated_accuracy = 0.0;
        double cumulated_precision = 0.0;
        double cumulated_recall = 0.0;
        int cumulated_all = 0;
        int totalValidFields = 0;
        int totalFields = 0;
        for (i = 0; i < labels.size(); ++i) {
            totalFields += counterExpected.get(i).intValue();
        }
        for (i = 0; i < labels.size(); ++i) {
            totalFields += counterFalsePositive.get(i).intValue();
        }
        double accuracy = 0.0;
        double precision = 0.0;
        double recall = 0.0;
        double f0 = 0.0;
        i = 0;
        while (i < labels.size()) {
            String label = labels.get(i).trim();
            if (label.equals("<other>") || label.equals("base")) {
                ++i;
                continue;
            }
            report.append(label);
            if (label.length() < 12) {
                report.append("\t");
            }
            int tp = counterObserved.get(i);
            int fp = counterFalsePositive.get(i);
            int fn = counterFalseNegative.get(i);
            int tn = totalFields - tp - (fp + fn);
            int all = counterExpected.get(i);
            if (all != 0) {
                ++totalValidFields;
            }
            accuracy = (double)(tp + tn) / (double)(tp + fp + tn + fn);
            report.append("\t").append(TextUtilities.formatTwoDecimals((double)(accuracy * 100.0)));
            precision = 0.0;
            precision = tp + fp == 0 ? 0.0 : (double)tp / (double)(tp + fp);
            report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(precision * 100.0)));
            recall = 0.0;
            recall = tp == 0 || all == 0 ? 0.0 : (double)tp / (double)all;
            report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0)));
            f0 = 0.0;
            f0 = precision + recall == 0.0 ? 0.0 : 2.0 * precision * recall / (precision + recall);
            report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(f0 * 100.0)));
            report.append("\n");
            cumulated_tp += tp;
            cumulated_fp += fp;
            cumulated_tn += tn;
            cumulated_fn += fn;
            if (all != 0) {
                cumulated_all += all;
                cumulated_f0 += f0;
                cumulated_accuracy += accuracy;
                cumulated_precision += precision;
                cumulated_recall += recall;
            }
            ++i;
        }
        report.append("\n");
        report.append("all fields\t");
        accuracy = (double)(cumulated_tp + cumulated_tn) / (double)(cumulated_tp + cumulated_fp + cumulated_tn + cumulated_fn);
        if (accuracy > 1.0) {
            accuracy = 1.0;
        }
        report.append("\t").append(TextUtilities.formatTwoDecimals((double)(accuracy * 100.0)));
        precision = (double)cumulated_tp / (double)(cumulated_tp + cumulated_fp);
        if (precision > 1.0) {
            precision = 1.0;
        }
        report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(precision * 100.0)));
        recall = (double)cumulated_tp / (double)cumulated_all;
        if (recall > 1.0) {
            recall = 1.0;
        }
        report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append(" ");
        f0 = 2.0 * precision * recall / (precision + recall);
        report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(f0 * 100.0)));
        report.append("\t(micro average)");
        report.append("\n");
        report.append("\t\t");
        accuracy = cumulated_accuracy / (double)totalValidFields;
        if (accuracy > 1.0) {
            accuracy = 1.0;
        }
        report.append("\t").append(TextUtilities.formatTwoDecimals((double)(accuracy * 100.0)));
        precision = cumulated_precision / (double)totalValidFields;
        if (precision > 1.0) {
            precision = 1.0;
        }
        report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(precision * 100.0)));
        recall = cumulated_recall / (double)totalValidFields;
        if (recall > 1.0) {
            recall = 1.0;
        }
        report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0)));
        f0 = cumulated_f0 / (double)totalValidFields;
        report.append("\t\t").append(TextUtilities.formatTwoDecimals((double)(f0 * 100.0)));
        report.append("\t(macro average)");
        report.append("\n");
        return report.toString();
    }
}

