/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.evaluation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.grobid.core.GrobidModels;
import org.grobid.core.engines.tagging.GenericTagger;
import org.grobid.core.engines.tagging.TaggerFactory;
import org.grobid.core.exceptions.GrobidException;
import org.grobid.core.utilities.GrobidProperties;
import org.grobid.core.utilities.TextUtilities;
import org.grobid.trainer.AbstractTrainer;
import org.grobid.trainer.PatentParserTrainer;

public class PatentEvaluation {
    private String evaluationPath = AbstractTrainer.getEvalCorpusBasePath().getAbsolutePath();
    private GenericTagger taggerPatent = null;
    private GenericTagger taggerNPL = null;
    private GenericTagger taggerAll = null;
    private String outputPath;

    public PatentEvaluation() {
        GrobidProperties.getInstance();
        this.outputPath = GrobidProperties.getTempPath().getAbsolutePath();
        this.taggerNPL = TaggerFactory.getTagger((GrobidModels)GrobidModels.PATENT_NPL);
        this.taggerPatent = TaggerFactory.getTagger((GrobidModels)GrobidModels.PATENT_PATENT);
        this.taggerAll = TaggerFactory.getTagger((GrobidModels)GrobidModels.PATENT_ALL);
    }

    public String evaluate(int type) {
        PatentParserTrainer ppt = new PatentParserTrainer();
        if (type == 0) {
            GenericTagger tagger = this.taggerPatent;
            String setName = "patent";
        } else if (type == 1) {
            GenericTagger tagger = this.taggerNPL;
            String setName = "npl";
        } else if (type == 2) {
            GenericTagger tagger = this.taggerAll;
            String setName = "all";
        } else {
            throw new GrobidException("An exception occured while evaluating Grobid. The parameter type is undefined.");
        }
        return this.evaluate();
    }

    public String evaluate() {
        StringBuilder report = new StringBuilder();
        PatentParserTrainer ppt = new PatentParserTrainer();
        ppt.createDataSet("test", null, this.evaluationPath, this.outputPath, 1);
        ArrayList<GenericTagger> taggers = new ArrayList<GenericTagger>();
        taggers.add(this.taggerNPL);
        taggers.add(this.taggerPatent);
        taggers.add(this.taggerAll);
        for (GenericTagger tagger : taggers) {
            int totalExpected = 0;
            int totalCorrect = 0;
            int totalSuggested = 0;
            int totalInstanceExpected = 0;
            int totalInstanceCorrect = 0;
            boolean totalInstanceSuggested = false;
            int totalNPLExpected = 0;
            int totalNPLCorrect = 0;
            int totalNPLSuggested = 0;
            int totalInstanceNPLExpected = 0;
            int totalInstanceNPLCorrect = 0;
            boolean totalInstanceNPLSuggested = false;
            int totalPatentExpected = 0;
            int totalPatentCorrect = 0;
            int totalPatentSuggested = 0;
            int totalInstancePatentExpected = 0;
            int totalInstancePatentCorrect = 0;
            boolean totalInstancePatentSuggested = false;
            try {
                BufferedReader bufReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.outputPath + "/all.test"), "UTF-8"));
                String line = null;
                ArrayList<String> patentBlocks = new ArrayList<String>();
                while ((line = bufReader.readLine()) != null) {
                    patentBlocks.add(line);
                }
                bufReader.close();
                String theResult = tagger.label(patentBlocks);
                StringTokenizer stt = new StringTokenizer(theResult, "\n");
                String previousExpectedLabel = null;
                String previousSuggestedLabel = null;
                boolean instanceCorrect = true;
                while (stt.hasMoreTokens()) {
                    line = stt.nextToken();
                    StringTokenizer st = new StringTokenizer(line, "\t");
                    String expected = null;
                    String actual = null;
                    String word = null;
                    boolean start = true;
                    boolean failure = false;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (start) {
                            word = token.trim();
                            start = false;
                        }
                        expected = actual;
                        actual = token.trim();
                    }
                    if (expected == null || actual == null) continue;
                    if (!expected.equals("<other>")) {
                        ++totalExpected;
                        if (expected.endsWith("refPatent>")) {
                            ++totalPatentExpected;
                        } else if (expected.endsWith("refNPL>")) {
                            ++totalNPLExpected;
                        } else {
                            report.append("WARNING bizarre suggested tag: " + expected + "\n");
                        }
                    }
                    if (!actual.equals("<other>")) {
                        ++totalSuggested;
                        if (actual.endsWith("refPatent>")) {
                            ++totalPatentSuggested;
                        } else if (actual.endsWith("refNPL>")) {
                            ++totalNPLSuggested;
                        } else {
                            report.append("WARNING bizarre suggested tag: " + actual + "\n");
                        }
                    }
                    if (actual.endsWith("refPatent>")) {
                        actual = "refPatent";
                    } else if (actual.endsWith("refNPL>")) {
                        actual = "refNPL";
                    }
                    if (expected.endsWith("refPatent>")) {
                        expected = "refPatent";
                    } else if (expected.endsWith("refNPL>")) {
                        expected = "refNPL";
                    }
                    if (actual.equals("<other>")) {
                        actual = "other";
                    }
                    if (expected.equals("<other>")) {
                        expected = "other";
                    }
                    if (expected.equals(actual)) {
                        if (!actual.equals("other") && !expected.equals("other")) {
                            ++totalCorrect;
                            if (expected.startsWith("refPatent")) {
                                ++totalPatentCorrect;
                            } else if (expected.startsWith("refNPL")) {
                                ++totalNPLCorrect;
                            }
                        }
                    } else {
                        failure = true;
                    }
                    if (!expected.equals("other")) {
                        if (previousExpectedLabel == null || !expected.equals(previousExpectedLabel)) {
                            if (previousExpectedLabel != null && !previousExpectedLabel.equals("other") && instanceCorrect) {
                                if (previousExpectedLabel.startsWith("refPatent")) {
                                    ++totalInstancePatentCorrect;
                                } else if (previousExpectedLabel.startsWith("refNPL")) {
                                    ++totalInstanceNPLCorrect;
                                }
                            }
                            ++totalInstanceExpected;
                            if (expected.startsWith("refPatent")) {
                                ++totalInstancePatentExpected;
                            } else if (expected.startsWith("refNPL")) {
                                ++totalInstanceNPLExpected;
                            }
                            instanceCorrect = true;
                        }
                    } else if (previousExpectedLabel != null && !previousExpectedLabel.equals("other")) {
                        if (instanceCorrect) {
                            ++totalInstanceCorrect;
                            if (previousExpectedLabel.startsWith("refPatent")) {
                                ++totalInstancePatentCorrect;
                            } else if (previousExpectedLabel.startsWith("refNPL")) {
                                ++totalInstanceNPLCorrect;
                            }
                        }
                        instanceCorrect = true;
                    }
                    if (failure) {
                        instanceCorrect = false;
                    }
                    previousExpectedLabel = expected;
                    previousSuggestedLabel = actual;
                }
            }
            catch (Exception e) {
                throw new GrobidException("An exception occured while evaluating Grobid.", (Throwable)e);
            }
            if (tagger == this.taggerNPL) {
                report.append("\n\n*********************************************\n");
                report.append("****** NPL reference extraction model *******\n");
                report.append("*********************************************\n");
            } else if (tagger == this.taggerPatent) {
                report.append("\n\n************************************************\n");
                report.append("****** patent reference extraction model *******\n");
                report.append("************************************************\n");
            } else if (tagger == this.taggerAll) {
                report.append("\n\n*************************************************************\n");
                report.append("****** combined NPL+patent reference extraction model *******\n");
                report.append("*************************************************************\n");
            }
            if (tagger == this.taggerAll) {
                report.append("\n======== GENERAL TAG EVALUATION ========\n");
                report.append("Total expected tags: ").append(totalExpected).append("\n");
                report.append("Total suggested tags: ").append(totalSuggested).append("\n");
                report.append("Total correct tags (Correct Positive): ").append(totalCorrect).append("\n");
                report.append("Total incorrect tags (False Positive + False Negative): ").append(Math.abs(totalSuggested - totalCorrect)).append("\n");
                double precision = (double)totalCorrect / (double)totalSuggested;
                double recall = (double)totalCorrect / (double)totalExpected;
                double f = 2.0 * precision * recall / (precision + recall);
                report.append("Precision\t= ").append(TextUtilities.formatTwoDecimals((double)(precision * 100.0))).append("\n");
                report.append("Recall\t= ").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append("\n");
                report.append("F-score\t= ").append(TextUtilities.formatTwoDecimals((double)(f * 100.0))).append("\n");
            }
            if (tagger != this.taggerPatent) {
                report.append("\n======== TAG NPL EVALUATION ========\n");
                report.append("Total expected tags: ").append(totalNPLExpected).append("\n");
                report.append("Total suggested tags: ").append(totalNPLSuggested).append("\n");
                report.append("Total correct tags (Correct Positive): ").append(totalNPLCorrect).append("\n");
                report.append("Total incorrect tags (False Positive + False Negative): ").append(Math.abs(totalNPLSuggested - totalNPLCorrect)).append("\n");
                double precision = (double)totalNPLCorrect / (double)totalNPLSuggested;
                double recall = (double)totalNPLCorrect / (double)totalNPLExpected;
                double f = 2.0 * precision * recall / (precision + recall);
                report.append("Precision\t= ").append(TextUtilities.formatTwoDecimals((double)(precision * 100.0))).append("\n");
                report.append("Recall\t= ").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append("\n");
                report.append("F-score\t= ").append(TextUtilities.formatTwoDecimals((double)(f * 100.0))).append("\n");
            }
            if (tagger != this.taggerNPL) {
                report.append("\n======== TAG PATENT EVALUATION ========\n");
                report.append("Total expected tags: ").append(totalPatentExpected).append("\n");
                report.append("Total suggested tags: ").append(totalPatentSuggested).append("\n");
                report.append("Total correct tags (Correct Positive): ").append(totalPatentCorrect).append("\n");
                report.append("Total incorrect tags (False Positive + False Negative): ").append(Math.abs(totalPatentSuggested - totalPatentCorrect)).append("\n");
                double precision = (double)totalPatentCorrect / (double)totalPatentSuggested;
                double recall = (double)totalPatentCorrect / (double)totalPatentExpected;
                double f = 2.0 * precision * recall / (precision + recall);
                report.append("Precision\t= ").append(TextUtilities.formatTwoDecimals((double)(precision * 100.0))).append("\n");
                report.append("Recall\t= ").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append("\n");
                report.append("F-score\t= ").append(TextUtilities.formatTwoDecimals((double)(f * 100.0))).append("\n");
            }
            if (tagger == this.taggerAll) {
                report.append("\n======== GENERAL INSTANCE EVALUATION ========\n");
                report.append("Total expected instances: ").append(totalInstanceExpected).append("\n");
                report.append("Total correct instances: ").append(totalInstanceCorrect).append("\n");
                double recall = (double)totalInstanceCorrect / (double)totalInstanceExpected;
                report.append("Instance Accuracy = ").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append("\n");
            }
            if (tagger != this.taggerPatent) {
                report.append("\n======== INSTANCE NPL EVALUATION ========\n");
                report.append("Total expected instances: ").append(totalInstanceNPLExpected).append("\n");
                report.append("Total correct instances: ").append(totalInstanceNPLCorrect).append("\n");
                double recall = (double)totalInstanceNPLCorrect / (double)totalInstanceNPLExpected;
                report.append("Instance accuracy = ").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append("\n");
            }
            if (tagger == this.taggerNPL) continue;
            report.append("\n======== INSTANCE PATENT EVALUATION ========\n");
            report.append("Total expected instances: ").append(totalInstancePatentExpected).append("\n");
            report.append("Total correct instances: ").append(totalInstancePatentCorrect).append("\n");
            double recall = (double)totalInstancePatentCorrect / (double)totalInstancePatentExpected;
            report.append("Instance accuracy = ").append(TextUtilities.formatTwoDecimals((double)(recall * 100.0))).append("\n\n");
        }
        return report.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void evaluateGold(File path) {
        try {
            void var42_117;
            void var40_108;
            void var38_99;
            void var36_90;
            void var34_81;
            void var32_72;
            String s;
            TreeMap rfap_reference = new TreeMap();
            TreeMap rf_reference = new TreeMap();
            TreeMap rfap_ace = new TreeMap();
            TreeMap rf_ace = new TreeMap();
            TreeMap rfap_Ddoc = new TreeMap();
            TreeMap rf_Ddoc = new TreeMap();
            TreeMap rfap = new TreeMap();
            TreeMap rf = new TreeMap();
            String dossierName = null;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.evaluationPath + "/gold/REF_20100426.txt"), "UTF8"));
            ArrayList<String> resap_reference = null;
            ArrayList<String> res_reference = null;
            while ((s = br.readLine()) != null) {
                String[] pats;
                if (s.length() == 0) continue;
                if (s.startsWith("RFAP:")) {
                    resap_reference = new ArrayList<String>();
                    s = s.substring(5, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || resap_reference.contains(pat)) continue;
                        resap_reference.add(pat);
                    }
                    continue;
                }
                if (s.startsWith("RF:")) {
                    res_reference = new ArrayList<String>();
                    s = s.substring(3, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || res_reference.contains(pat)) continue;
                        res_reference.add(pat);
                    }
                    continue;
                }
                if (dossierName != null) {
                    rfap_reference.put(dossierName, resap_reference);
                    rf_reference.put(dossierName, res_reference);
                }
                dossierName = s.trim();
                dossierName = dossierName.replace(".txt", "");
            }
            rfap_reference.put(dossierName, resap_reference);
            rf_reference.put(dossierName, res_reference);
            br.close();
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.evaluationPath + "/ACE_20100426.txt"), "UTF8"));
            ArrayList<String> resap_ace = null;
            ArrayList<String> res_ace = null;
            dossierName = null;
            while ((s = br.readLine()) != null) {
                String[] pats;
                if (s.length() == 0) continue;
                if (s.startsWith("RFAP:")) {
                    resap_ace = new ArrayList<String>();
                    s = s.substring(5, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || resap_ace.contains(pat)) continue;
                        resap_ace.add(pat);
                    }
                    continue;
                }
                if (s.startsWith("RF:")) {
                    res_ace = new ArrayList<String>();
                    s = s.substring(3, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || res_ace.contains(pat)) continue;
                        res_ace.add(pat);
                    }
                    continue;
                }
                if (dossierName != null) {
                    rfap_ace.put(dossierName, resap_ace);
                    rf_ace.put(dossierName, res_ace);
                }
                dossierName = s.trim();
                dossierName = dossierName.replace(".txt", "");
            }
            rfap_ace.put(dossierName, resap_ace);
            rf_ace.put(dossierName, res_ace);
            br.close();
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.evaluationPath + "/Ddoc_20100426.txt"), "UTF8"));
            ArrayList<String> resap_Ddoc = null;
            ArrayList<String> res_Ddoc = null;
            dossierName = null;
            while ((s = br.readLine()) != null) {
                String[] pats;
                if (s.length() == 0) continue;
                if (s.startsWith("RFAP:")) {
                    resap_Ddoc = new ArrayList<String>();
                    s = s.substring(5, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || resap_Ddoc.contains(pat)) continue;
                        resap_Ddoc.add(pat);
                    }
                    continue;
                }
                if (s.startsWith("RF:")) {
                    res_Ddoc = new ArrayList<String>();
                    s = s.substring(3, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || res_Ddoc.contains(pat)) continue;
                        res_Ddoc.add(pat);
                    }
                    continue;
                }
                if (dossierName != null) {
                    rfap_Ddoc.put(dossierName, resap_Ddoc);
                    rf_Ddoc.put(dossierName, res_Ddoc);
                }
                dossierName = s.trim();
                dossierName = dossierName.replace(".txt", "");
            }
            rfap_Ddoc.put(dossierName, resap_Ddoc);
            rf_Ddoc.put(dossierName, res_Ddoc);
            br.close();
            BufferedReader br2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.getParent() + "/report.txt"), "UTF8"));
            dossierName = null;
            ArrayList<String> resap = null;
            ArrayList<String> res = null;
            while ((s = br2.readLine()) != null) {
                String[] pats;
                if (s.length() == 0) continue;
                if (s.startsWith("RFAP:")) {
                    resap = new ArrayList<String>();
                    s = s.substring(5, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || resap.contains(pat)) continue;
                        resap.add(pat);
                    }
                    continue;
                }
                if (s.startsWith("RF:")) {
                    res = new ArrayList<String>();
                    s = s.substring(3, s.length());
                    for (String pat : pats = s.split(" ")) {
                        if (pat == null || pat.length() <= 0 || res.contains(pat)) continue;
                        res.add(pat);
                    }
                    continue;
                }
                if (dossierName != null) {
                    rfap.put(dossierName, resap);
                    rf.put(dossierName, res);
                }
                dossierName = s.trim();
                dossierName = dossierName.replace(".txt", "");
            }
            rfap.put(dossierName, resap);
            rf.put(dossierName, res);
            br2.close();
            int count_rfap_reference = 0;
            for (Map.Entry entry : rfap_reference.entrySet()) {
                ArrayList liste = (ArrayList)entry.getValue();
                count_rfap_reference += liste.size();
            }
            int count_rf_reference = 0;
            int nbDossier = 0;
            for (Map.Entry entry : rf_reference.entrySet()) {
                ArrayList liste = (ArrayList)entry.getValue();
                count_rf_reference += liste.size();
                ++nbDossier;
            }
            System.out.println("Ref. data: " + count_rfap_reference + " serials and " + count_rf_reference + " publications, total: " + (count_rfap_reference + count_rf_reference) + " in " + nbDossier + " dossiers");
            int count_rfap_ace = 0;
            int count_rfap_ace_correct = 0;
            for (Map.Entry entry : rfap_ace.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rfap_reference.get(dossierName);
                ArrayList liste = (ArrayList)entry.getValue();
                count_rfap_ace += liste.size();
                for (String string : liste) {
                    if (!referenceListe.contains(string)) continue;
                    ++count_rfap_ace_correct;
                }
            }
            int count_rf_ace = 0;
            int count_rf_ace_correct = 0;
            nbDossier = 0;
            for (Map.Entry entry : rf_ace.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rf_reference.get(dossierName);
                ArrayList arrayList = (ArrayList)entry.getValue();
                count_rf_ace += arrayList.size();
                for (String string : arrayList) {
                    if (!referenceListe.contains(string)) continue;
                    ++count_rf_ace_correct;
                }
                ++nbDossier;
            }
            System.out.println("ACE data: " + count_rfap_ace + " (" + count_rfap_ace_correct + " correct) serials and " + count_rf_ace + " (" + count_rf_ace_correct + " correct) publications, total: " + (count_rfap_ace + count_rf_ace) + " in " + nbDossier + " dossiers");
            int count_rfap_Ddoc = 0;
            int count_rfap_Ddoc_correct = 0;
            for (Map.Entry entry : rfap_Ddoc.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rfap_reference.get(dossierName);
                ArrayList arrayList = (ArrayList)entry.getValue();
                count_rfap_Ddoc += arrayList.size();
                for (String string : arrayList) {
                    if (!referenceListe.contains(string)) continue;
                    ++count_rfap_Ddoc_correct;
                }
            }
            int count_rf_Ddoc = 0;
            boolean bl = false;
            nbDossier = 0;
            for (Map.Entry entry : rf_Ddoc.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rf_reference.get(dossierName);
                ArrayList arrayList = (ArrayList)entry.getValue();
                count_rf_Ddoc += arrayList.size();
                for (String string : arrayList) {
                    if (!referenceListe.contains(string)) continue;
                    ++var32_72;
                }
                ++nbDossier;
            }
            System.out.println("Ddoc data: " + count_rfap_Ddoc + " (" + count_rfap_Ddoc_correct + " correct) serials and " + count_rf_Ddoc + " (" + (int)var32_72 + " correct) publications, total: " + (count_rfap_Ddoc + count_rf_Ddoc) + " in " + nbDossier + " dossiers");
            int count_rfap = 0;
            boolean bl2 = false;
            for (Map.Entry entry : rfap.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rfap_reference.get(dossierName);
                if (referenceListe == null) continue;
                ArrayList arrayList = (ArrayList)entry.getValue();
                count_rfap += arrayList.size();
                for (String string : arrayList) {
                    if (!referenceListe.contains(string)) continue;
                    ++var34_81;
                }
            }
            int count_rf = 0;
            boolean bl3 = false;
            nbDossier = 0;
            for (Map.Entry entry : rf.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rf_reference.get(dossierName);
                if (referenceListe != null) {
                    ArrayList arrayList = (ArrayList)entry.getValue();
                    count_rf += arrayList.size();
                    for (String string : arrayList) {
                        if (!referenceListe.contains(string)) continue;
                        ++var36_90;
                    }
                    ++nbDossier;
                    continue;
                }
                System.out.println("WARNING! file " + dossierName + " in GROBID's results but not in reference results");
            }
            System.out.println("GROBID data: " + count_rfap + " (" + (int)var34_81 + " correct) serials and " + count_rf + " (" + (int)var36_90 + " correct) publications, total: " + (count_rfap + count_rf) + " in " + nbDossier + " dossiers");
            int count_rfap_DdocIGROBID = 0;
            boolean bl4 = false;
            for (Map.Entry entry : rfap_Ddoc.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rfap_reference.get(dossierName);
                ArrayList arrayList = (ArrayList)entry.getValue();
                ArrayList listeGrobid = (ArrayList)rfap.get(dossierName);
                if (listeGrobid == null) {
                    System.out.println("WARNING! file " + dossierName + " in Ddoc results but not in GROBID's one");
                    continue;
                }
                ArrayList<String> liste2 = new ArrayList<String>();
                for (String string : arrayList) {
                    if (!listeGrobid.contains(string)) continue;
                    liste2.add(string);
                }
                count_rfap_DdocIGROBID += liste2.size();
                for (String string : liste2) {
                    if (!referenceListe.contains(string)) continue;
                    ++var38_99;
                }
            }
            int count_rf_DdocIGROBID = 0;
            boolean bl5 = false;
            nbDossier = 0;
            for (Map.Entry entry : rf_Ddoc.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rf_reference.get(dossierName);
                ArrayList liste = (ArrayList)entry.getValue();
                ArrayList listeGrobid = (ArrayList)rf.get(dossierName);
                if (listeGrobid == null) {
                    System.out.println("WARNING! file " + dossierName + " in Ddoc results but not in GROBID's one");
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String toto : liste) {
                    if (!listeGrobid.contains(toto)) continue;
                    arrayList.add(toto);
                }
                count_rf_DdocIGROBID += arrayList.size();
                for (String pat : arrayList) {
                    if (!referenceListe.contains(pat)) continue;
                    ++var40_108;
                }
                ++nbDossier;
            }
            System.out.println("Ddoc+GROBID data: " + count_rfap_DdocIGROBID + " (" + (int)var38_99 + " correct) serials and " + count_rf_DdocIGROBID + " (" + (int)var40_108 + " correct) publications, total: " + (count_rfap_DdocIGROBID + count_rf_DdocIGROBID) + " in " + nbDossier + " dossiers");
            int count_rfap_DdocUGROBID = 0;
            boolean bl6 = false;
            for (Map.Entry entry : rfap_Ddoc.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rfap_reference.get(dossierName);
                ArrayList arrayList = (ArrayList)entry.getValue();
                ArrayList listeGrobid = (ArrayList)rfap.get(dossierName);
                if (listeGrobid == null) {
                    System.out.println("WARNING! file " + dossierName + " in Ddoc results but not in GROBID's one");
                    continue;
                }
                for (String toto : listeGrobid) {
                    if (arrayList.contains(toto)) continue;
                    arrayList.add(toto);
                }
                count_rfap_DdocUGROBID += arrayList.size();
                for (String pat : arrayList) {
                    if (!referenceListe.contains(pat)) continue;
                    ++var42_117;
                }
            }
            int count_rf_DdocUGROBID = 0;
            int count_rf_DdocUGROBID_correct = 0;
            nbDossier = 0;
            for (Map.Entry entry : rf_Ddoc.entrySet()) {
                dossierName = (String)entry.getKey();
                ArrayList referenceListe = (ArrayList)rf_reference.get(dossierName);
                ArrayList liste = (ArrayList)entry.getValue();
                ArrayList listeGrobid = (ArrayList)rf.get(dossierName);
                if (listeGrobid == null) {
                    System.out.println("WARNING! file " + dossierName + " in Ddoc results but not in GROBID's one");
                    continue;
                }
                for (String toto : listeGrobid) {
                    if (liste.contains(toto)) continue;
                    liste.add(toto);
                }
                count_rf_DdocUGROBID += liste.size();
                for (String pat : liste) {
                    if (!referenceListe.contains(pat)) continue;
                    ++count_rf_DdocUGROBID_correct;
                }
                ++nbDossier;
            }
            System.out.println("Ddoc|GROBID data: " + count_rfap_DdocUGROBID + " (" + (int)var42_117 + " correct) serials and " + count_rf_DdocUGROBID + " (" + count_rf_DdocUGROBID_correct + " correct) publications, total: " + (count_rfap_DdocUGROBID + count_rf_DdocUGROBID) + " in " + nbDossier + " dossiers");
            double ace_rfap_precision = (double)count_rfap_ace_correct / (double)count_rfap_ace;
            double ace_rfap_recall = (double)count_rfap_ace_correct / (double)count_rfap_reference;
            double ace_rfap_f = 2.0 * ace_rfap_precision * ace_rfap_recall / (ace_rfap_precision + ace_rfap_recall);
            double ace_rf_precision = (double)count_rf_ace_correct / (double)count_rf_ace;
            double ace_rf_recall = (double)count_rf_ace_correct / (double)count_rf_reference;
            double ace_rf_f = 2.0 * ace_rf_precision * ace_rf_recall / (ace_rf_precision + ace_rf_recall);
            double ace_rfall_precision = (double)(count_rfap_ace_correct + count_rf_ace_correct) / (double)(count_rfap_ace + count_rf_ace);
            double ace_rfall_recall = (double)(count_rfap_ace_correct + count_rf_ace_correct) / (double)(count_rfap_reference + count_rf_reference);
            double ace_rfall_f = 2.0 * ace_rfall_precision * ace_rfall_recall / (ace_rfall_precision + ace_rfall_recall);
            double Ddoc_rfap_precision = (double)count_rfap_Ddoc_correct / (double)count_rfap_Ddoc;
            double Ddoc_rfap_recall = (double)count_rfap_Ddoc_correct / (double)count_rfap_reference;
            double Ddoc_rfap_f = 2.0 * Ddoc_rfap_precision * Ddoc_rfap_recall / (Ddoc_rfap_precision + Ddoc_rfap_recall);
            double Ddoc_rf_precision = (double)var32_72 / (double)count_rf_Ddoc;
            double Ddoc_rf_recall = (double)var32_72 / (double)count_rf_reference;
            double Ddoc_rf_f = 2.0 * Ddoc_rf_precision * Ddoc_rf_recall / (Ddoc_rf_precision + Ddoc_rf_recall);
            double Ddoc_rfall_precision = (double)(count_rfap_Ddoc_correct + var32_72) / (double)(count_rfap_Ddoc + count_rf_Ddoc);
            double Ddoc_rfall_recall = (double)(count_rfap_Ddoc_correct + var32_72) / (double)(count_rfap_reference + count_rf_reference);
            double Ddoc_rfall_f = 2.0 * Ddoc_rfall_precision * Ddoc_rfall_recall / (Ddoc_rfall_precision + Ddoc_rfall_recall);
            double grobid_rfap_precision = (double)var34_81 / (double)count_rfap;
            double grobid_rfap_recall = (double)var34_81 / (double)count_rfap_reference;
            double grobid_rfap_f = 2.0 * grobid_rfap_precision * grobid_rfap_recall / (grobid_rfap_precision + grobid_rfap_recall);
            double grobid_rf_precision = (double)var36_90 / (double)count_rf;
            double grobid_rf_recall = (double)var36_90 / (double)count_rf_reference;
            double grobid_rf_f = 2.0 * grobid_rf_precision * grobid_rf_recall / (grobid_rf_precision + grobid_rf_recall);
            double grobid_rfall_precision = (double)(var34_81 + var36_90) / (double)(count_rf + count_rfap);
            double grobid_rfall_recall = (double)(var34_81 + var36_90) / (double)(count_rfap_reference + count_rf_reference);
            double grobid_rfall_f = 2.0 * grobid_rfall_precision * grobid_rfall_recall / (grobid_rfall_precision + grobid_rfall_recall);
            double DdocIGROBID_rfap_precision = (double)var38_99 / (double)count_rfap_DdocIGROBID;
            double DdocIGROBID_rfap_recall = (double)var38_99 / (double)count_rfap_reference;
            double DdocIGROBID_rfap_f = 2.0 * DdocIGROBID_rfap_precision * DdocIGROBID_rfap_recall / (DdocIGROBID_rfap_precision + DdocIGROBID_rfap_recall);
            double DdocIGROBID_rf_precision = (double)var40_108 / (double)count_rf_DdocIGROBID;
            double DdocIGROBID_rf_recall = (double)var40_108 / (double)count_rf_reference;
            double DdocIGROBID_rf_f = 2.0 * DdocIGROBID_rf_precision * DdocIGROBID_rf_recall / (DdocIGROBID_rf_precision + DdocIGROBID_rf_recall);
            double DdocIGROBID_rfall_precision = (double)(var38_99 + var40_108) / (double)(count_rfap_DdocIGROBID + count_rf_DdocIGROBID);
            double DdocIGROBID_rfall_recall = (double)(var38_99 + var40_108) / (double)(count_rfap_reference + count_rf_reference);
            double DdocIGROBID_rfall_f = 2.0 * DdocIGROBID_rfall_precision * DdocIGROBID_rfall_recall / (DdocIGROBID_rfall_precision + DdocIGROBID_rfall_recall);
            double DdocUGROBID_rfap_precision = (double)var42_117 / (double)count_rfap_DdocUGROBID;
            double DdocUGROBID_rfap_recall = (double)var42_117 / (double)count_rfap_reference;
            double DdocUGROBID_rfap_f = 2.0 * DdocUGROBID_rfap_precision * DdocUGROBID_rfap_recall / (DdocUGROBID_rfap_precision + DdocUGROBID_rfap_recall);
            double DdocUGROBID_rf_precision = (double)count_rf_DdocUGROBID_correct / (double)count_rf_DdocUGROBID;
            double DdocUGROBID_rf_recall = (double)count_rf_DdocUGROBID_correct / (double)count_rf_reference;
            double DdocUGROBID_rf_f = 2.0 * DdocUGROBID_rf_precision * DdocUGROBID_rf_recall / (DdocUGROBID_rf_precision + DdocUGROBID_rf_recall);
            double DdocUGROBID_rfall_precision = (double)(var42_117 + count_rf_DdocUGROBID_correct) / (double)(count_rfap_DdocUGROBID + count_rf_DdocUGROBID);
            double DdocUGROBID_rfall_recall = (double)(var42_117 + count_rf_DdocUGROBID_correct) / (double)(count_rfap_reference + count_rf_reference);
            double DdocUGROBID_rfall_f = 2.0 * DdocUGROBID_rfall_precision * DdocUGROBID_rfall_recall / (DdocUGROBID_rfall_precision + DdocUGROBID_rfall_recall);
            System.out.println("___________________________________________________________");
            System.out.println("RFAP: ");
            System.out.println("\t\tPrecision\tRecall\t\tF-score");
            System.out.println("ACE\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rfap_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rfap_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rfap_f * 100.0)));
            System.out.println("Ddoc\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rfap_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rfap_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rfap_f * 100.0)));
            System.out.println("GROBID\t" + TextUtilities.formatTwoDecimals((double)(grobid_rfap_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(grobid_rfap_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(grobid_rfap_f * 100.0)));
            System.out.println("Ddoc+GROBID\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rfap_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rfap_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rfap_f * 100.0)));
            System.out.println("Ddoc|GROBID\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rfap_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rfap_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rfap_f * 100.0)));
            System.out.println("\n___________________________________________________________");
            System.out.println("RF: ");
            System.out.println("\t\tPrecision\tRecall\t\tF-score");
            System.out.println("ACE\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rf_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rf_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rf_f * 100.0)));
            System.out.println("Ddoc\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rf_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rf_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rf_f * 100.0)));
            System.out.println("GROBID\t" + TextUtilities.formatTwoDecimals((double)(grobid_rf_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(grobid_rf_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(grobid_rf_f * 100.0)));
            System.out.println("Ddoc+GROBID\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rf_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rf_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rf_f * 100.0)));
            System.out.println("Ddoc|GROBID\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rf_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rf_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rf_f * 100.0)));
            System.out.println("\n___________________________________________________________");
            System.out.println("All: ");
            System.out.println("\t\tPrecision\tRecall\t\tF-score");
            System.out.println("ACE\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rfall_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rfall_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(ace_rfall_f * 100.0)));
            System.out.println("Ddoc\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rfall_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rfall_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(Ddoc_rfall_f * 100.0)));
            System.out.println("GROBID\t" + TextUtilities.formatTwoDecimals((double)(grobid_rfall_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(grobid_rfall_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(grobid_rfall_f * 100.0)));
            System.out.println("Ddoc+GROBID\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rfall_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rfall_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocIGROBID_rfall_f * 100.0)));
            System.out.println("Ddod|GROBID\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rfall_precision * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rfall_recall * 100.0)) + "\t\t" + TextUtilities.formatTwoDecimals((double)(DdocUGROBID_rfall_f * 100.0)));
            File fileOut = new File(path.getParent() + "/reference.txt");
            FileOutputStream os = new FileOutputStream(fileOut, false);
            OutputStreamWriter referenceWriter = new OutputStreamWriter((OutputStream)os, "UTF-8");
            System.out.println("Reference data in " + path.getParent() + "/reference.txt");
            for (Map.Entry entry : rf_reference.entrySet()) {
                dossierName = (String)entry.getKey();
                referenceWriter.write(dossierName + ".txt\n");
                ArrayList referenceListe1 = (ArrayList)rfap_reference.get(dossierName);
                ArrayList liste = (ArrayList)entry.getValue();
                referenceWriter.write("RFAP: ");
                for (String toto : referenceListe1) {
                    referenceWriter.write(toto + " ");
                }
                referenceWriter.write("\nRF: ");
                for (String toto : liste) {
                    referenceWriter.write(toto + " ");
                }
                referenceWriter.write("\n");
            }
            ((Writer)referenceWriter).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GrobidException("An exception occurred while evaluating Grobid.", (Throwable)e);
        }
    }
}

