/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.evaluation;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.grobid.core.engines.Engine;
import org.grobid.core.exceptions.GrobidResourceException;
import org.grobid.core.factory.GrobidFactory;
import org.grobid.core.mock.MockContext;
import org.grobid.core.utilities.GrobidProperties;
import org.grobid.trainer.evaluation.utilities.FieldSpecification;

public class PubMedCentralEvaluation {
    private static String pubMedCentralPath = null;
    private Engine engine = null;
    public static final int GROBID = 0;
    public static final int PDFX = 1;
    public static final int CERMINE = 2;
    public static final int HEADER = 0;
    public static final int CITATION = 1;
    public static final int FULLTEXT = 2;
    public double fileRatio = 1.0;
    public static final double minLevenshteinDistance = 0.8;
    public static final double minRatcliffObershelpSimilarity = 0.95;
    private List<String> headerLabels = null;
    private List<String> fulltextLabels = null;
    private List<String> citationsLabels = null;
    private List<FieldSpecification> headerFields = null;
    private List<FieldSpecification> fulltextFields = null;
    private List<FieldSpecification> citationsFields = null;

    public PubMedCentralEvaluation(String path) {
        pubMedCentralPath = path;
        File pubMedCentralFile = new File(path);
        if (!pubMedCentralFile.exists()) {
            System.out.println("Path to PubMedCentral is not valid !");
            pubMedCentralPath = null;
        }
        String pGrobidHome = "../grobid-home";
        String pGrobidProperties = "../grobid-home/config/grobid.properties";
        try {
            MockContext.setInitialContext((String)pGrobidHome, (String)pGrobidProperties);
            GrobidProperties.getInstance();
            System.out.println(">>>>>>>> GROBID_HOME=" + GrobidProperties.get_GROBID_HOME_PATH());
            this.engine = GrobidFactory.getInstance().createEngine();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.headerFields = new ArrayList<FieldSpecification>();
        this.fulltextFields = new ArrayList<FieldSpecification>();
        this.citationsFields = new ArrayList<FieldSpecification>();
        this.headerLabels = new ArrayList<String>();
        this.fulltextLabels = new ArrayList<String>();
        this.citationsLabels = new ArrayList<String>();
        FieldSpecification.setUpFields(this.headerFields, this.fulltextFields, this.citationsFields, this.headerLabels, this.fulltextLabels, this.citationsLabels);
    }

    public String evaluationGrobid(boolean forceRun) throws Exception {
        if (pubMedCentralPath == null) {
            throw new GrobidResourceException("Path to PubMedCentral is not correctly set");
        }
        StringBuilder report = new StringBuilder();
        if (forceRun) {
            File input = new File(pubMedCentralPath);
            File[] refFiles = input.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory();
                }
            });
            if (refFiles == null) {
                report.append("No file in dataset");
                return report.toString();
            }
            int n = 0;
            for (File dir : refFiles) {
                File[] refFiles2 = dir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".pdf") || name.endsWith(".PDF");
                    }
                });
                if (refFiles2 == null) {
                    System.out.println("warning: no PDF found under " + dir.getPath());
                    continue;
                }
                if (refFiles2.length != 1) {
                    System.out.println("warning: more than one PDF found under " + dir.getPath());
                    System.out.println("processing only the first one...");
                }
                File pdfFile = refFiles2[0];
                try {
                    System.out.println(n + " - " + pdfFile.getPath());
                    String tei = this.engine.fullTextToTEI(pdfFile.getPath(), false, false);
                    File resultTEI = new File(dir.getPath() + "/" + pdfFile.getName().replace(".pdf", ".tei.xml"));
                    FileUtils.writeStringToFile((File)resultTEI, (String)tei, (String)"UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n;
            }
        }
        report.append("\n======= Header metadata ======= \n");
        report.append(this.evaluationRun(0, 0));
        report.append("\n======= Citation metadata ======= \n");
        report.append(this.evaluationRun(0, 1));
        report.append("\n======= Fulltext structures ======= \n");
        return report.toString();
    }

    public String evaluationPDFX() throws Exception {
        if (pubMedCentralPath == null) {
            throw new GrobidResourceException("Path to PubMedCentral is not correctly set");
        }
        StringBuilder report = new StringBuilder();
        report.append("\n======= Header metadata ======= \n");
        report.append(this.evaluationRun(1, 0));
        report.append("\n======= Citation metadata ======= \n");
        report.append(this.evaluationRun(1, 1));
        report.append("\n======= Header structures ======= \n");
        report.append(this.evaluationRun(1, 2));
        return report.toString();
    }

    public String evaluationCermine(boolean forceRun) throws Exception {
        if (pubMedCentralPath == null) {
            throw new GrobidResourceException("Path to PubMedCentral is not correctly set");
        }
        StringBuilder report = new StringBuilder();
        if (forceRun) {
            // empty if block
        }
        report.append("\n======= Header metadata ======= \n");
        report.append(this.evaluationRun(2, 0));
        report.append("\n======= Citation metadata ======= \n");
        report.append(this.evaluationRun(2, 1));
        report.append("\n======= Header structures ======= \n");
        report.append(this.evaluationRun(2, 2));
        return report.toString();
    }

    /*
     * Exception decompiling
     */
    private String evaluationRun(int runType, int sectionType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        try {
            MockContext.destroyInitialContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initFields(int nbFields, List<Integer> counterExpected, List<Integer> counterObserved, List<Integer> counterFalsePositive, List<Integer> counterFalseNegative) {
        for (int p = 0; p < nbFields; ++p) {
            counterExpected.add(0);
            counterObserved.add(0);
            counterFalsePositive.add(0);
            counterFalseNegative.add(0);
        }
    }

    private static String basicNormalization(String string) {
        string = string.trim();
        string = string.replace("\n", " ");
        string = string.replaceAll("\t", " ");
        string = string.replaceAll(" ( )*", " ");
        return string.trim();
    }

    private static String removeFullPunct(String string) {
        StringBuilder result = new StringBuilder();
        string = string.toLowerCase();
        String allMismatchToIgnore = "([ ,:;?.!/)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660 \t\n\r\u00a0";
        for (int i = 0; i < string.length(); ++i) {
            if (allMismatchToIgnore.indexOf(string.charAt(i)) != -1) continue;
            result.append(string.charAt(i));
        }
        return result.toString();
    }

    public static void main(String[] args) {
        String fileRatioString;
        String runGrobid;
        if (args.length > 3 || args.length == 0) {
            System.err.println("usage: command [path to the PubMedCentral dataset] [0|1]");
        }
        boolean runGrobidVal = true;
        String pubMedCentralPath = args[0];
        if (pubMedCentralPath == null || pubMedCentralPath.length() == 0) {
            System.err.println("Path to PubMedCentral is not correctly set");
        }
        if ((runGrobid = args[1]).equals("0")) {
            runGrobidVal = false;
        } else if (runGrobid.equals("1")) {
            runGrobidVal = true;
        } else {
            System.err.println("Invalid value for last argument (run): [0|1]");
        }
        double fileRatio = 1.0;
        if (args.length > 1 && (fileRatioString = args[2]) != null && fileRatioString.length() > 0) {
            try {
                fileRatio = Double.parseDouble(fileRatioString);
            }
            catch (Exception e) {
                System.err.println("Invalid argument fileRatio, must be a double, e.g. 0.1");
            }
        }
        try {
            File pmcPath = new File(pubMedCentralPath);
            if (!pmcPath.exists()) {
                System.err.println("Path to PubMedCentral does not exist");
                return;
            }
            if (!pmcPath.isDirectory()) {
                System.err.println("Path to PubMedCentral is not a directory");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PubMedCentralEvaluation eval = new PubMedCentralEvaluation(pubMedCentralPath);
            eval.fileRatio = fileRatio;
            String report = eval.evaluationGrobid(runGrobidVal);
            System.out.println(report);
            eval.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

