/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import org.grobid.core.exceptions.GrobidException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChemicalClassNamesSaxParser
extends DefaultHandler {
    private ArrayList<ArrayList<String>> chemicalWords = null;
    private ArrayList<String> localChemicalWords = null;
    private int numberEntities = 0;

    public ArrayList<ArrayList<String>> getChemicalClassNames() {
        return this.chemicalWords;
    }

    public int getNumberEntities() {
        return this.numberEntities;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (qName.equals("class-name")) {
                if (this.localChemicalWords != null && this.localChemicalWords.size() > 0) {
                    String idd1 = null;
                    String idd2 = null;
                    for (String idd : this.localChemicalWords) {
                        if (idd1 == null) {
                            idd1 = idd;
                        }
                        if (idd2 == null) {
                            idd2 = idd;
                        }
                        if (idd.length() < idd1.length()) {
                            idd1 = idd;
                            continue;
                        }
                        if (idd.length() > idd2.length()) {
                            idd2 = idd;
                            continue;
                        }
                        if (idd.compareToIgnoreCase(idd1) < 0) {
                            idd1 = idd;
                            continue;
                        }
                        if (idd.compareToIgnoreCase(idd2) <= 0) continue;
                        idd2 = idd;
                    }
                    this.localChemicalWords = new ArrayList();
                    this.localChemicalWords.add(idd1);
                    this.localChemicalWords.add(idd2);
                    this.chemicalWords.add(this.localChemicalWords);
                    this.localChemicalWords = null;
                }
                ++this.numberEntities;
            }
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (qName.equals("nite:root")) {
                this.chemicalWords = new ArrayList();
            } else if (qName.equals("class-name")) {
                this.localChemicalWords = new ArrayList();
            } else if (qName.equals("nite:child")) {
                int length = atts.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    if (name == null || value == null || !name.equals("href")) continue;
                    int ind = value.indexOf("..");
                    if (ind != -1) {
                        int ind1 = value.indexOf("(");
                        int ind2 = value.indexOf(")");
                        String idd1 = value.substring(ind1 + 1, ind2);
                        this.localChemicalWords.add(idd1);
                        ind1 = value.indexOf("(", ind1 + 1);
                        ind2 = value.indexOf(")", ind2 + 1);
                        String idd2 = value.substring(ind1 + 1, ind2);
                        this.localChemicalWords.add(idd2);
                        continue;
                    }
                    ind = value.indexOf("(");
                    String idd = value.substring(ind + 1, value.length() - 1);
                    this.localChemicalWords.add(idd);
                }
            }
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
    }
}

