/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import java.util.List;
import org.grobid.core.exceptions.GrobidException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ChemicalWordsSaxParser
extends DefaultHandler {
    private List<String> chemicalAnnotations = null;
    private List<String> chemicalAnnotationsStarts = null;
    private List<String> chemicalFormulas = null;
    private List<String> chemicalFormulasStarts = null;
    private List<String> chemicalSubstances = null;
    private List<String> chemicalSubstancesStarts = null;
    private List<String> chemicalClassNames = null;
    private List<String> chemicalClassNamesStarts = null;
    private List<String> chemicalLigand = null;
    private List<String> chemicalLigandStarts = null;
    private List<String> labeledResult = null;
    private StringBuffer accumulator = new StringBuffer();
    private String localID = null;

    public void setChemicalAnnotations(List<String> annotations, List<String> annotationsStarts) {
        this.chemicalAnnotations = annotations;
        this.chemicalAnnotationsStarts = annotationsStarts;
    }

    public void setChemicalFormulas(List<String> formulas, List<String> formulasStarts) {
        this.chemicalFormulas = formulas;
        this.chemicalFormulasStarts = formulasStarts;
    }

    public void setChemicalSubstances(List<String> substances, List<String> substancesStarts) {
        this.chemicalSubstances = substances;
        this.chemicalSubstancesStarts = substancesStarts;
    }

    public void setChemicalClassNames(List<String> classNames, List<String> classNamesStarts) {
        this.chemicalClassNames = classNames;
        this.chemicalClassNamesStarts = classNamesStarts;
    }

    public void setChemicalLigand(List<String> ligand, List<String> ligandStarts) {
        this.chemicalLigand = ligand;
        this.chemicalLigandStarts = ligandStarts;
    }

    public List<String> getLabeledResult() {
        return this.labeledResult;
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (qName.equals("word")) {
                String word = this.getText();
                String label = null;
                label = this.chemicalAnnotationsStarts.contains(this.localID) || this.chemicalFormulasStarts.contains(this.localID) || this.chemicalSubstancesStarts.contains(this.localID) || this.chemicalClassNamesStarts.contains(this.localID) || this.chemicalLigandStarts.contains(this.localID) ? "I-<chemName>" : (this.chemicalAnnotations.contains(this.localID) || this.chemicalFormulas.contains(this.localID) || this.chemicalSubstances.contains(this.localID) || this.chemicalClassNames.contains(this.localID) || this.chemicalLigand.contains(this.localID) ? "<chemName>" : "<other>");
                this.labeledResult.add(word + "\t" + label);
            }
            this.accumulator.setLength(0);
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if (qName.equals("nite:root")) {
                this.labeledResult = new ArrayList<String>();
            } else if (qName.equals("word")) {
                int length = atts.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    if (name == null || value == null || !name.equals("nite:id")) continue;
                    this.localID = value;
                }
            }
        }
        catch (Exception e) {
            throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
        }
    }
}

