/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.grobid.core.data.Person;
import org.grobid.core.exceptions.GrobidException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MPDL_METS_SaxParser
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private ArrayList<Person> authors = null;
    private ArrayList<String> subjects = null;
    private ArrayList<String> files = null;
    private ArrayList<String> keywords = null;
    private String mods_title = null;
    private String mods_identifier = null;
    private String mods_start = null;
    private String mods_end = null;
    private String mods_language = "de";
    private String mods_genre = null;
    private String author_family = null;
    private String author_given = null;
    private String mods_displayForm = null;
    private boolean author = false;
    private boolean family = false;
    private boolean given = false;
    private boolean displayForm = false;
    private boolean outputFile = false;
    ArrayList<String> titles = new ArrayList();
    ArrayList<String> ids = new ArrayList();
    private String output = null;

    public MPDL_METS_SaxParser() {
    }

    public MPDL_METS_SaxParser(String outp) {
        this.output = outp;
        this.outputFile = true;
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    public void setOutputFile(boolean b) {
        this.outputFile = b;
    }

    public ArrayList<String> getModsTitles() {
        return this.titles;
    }

    public ArrayList<String> getIds() {
        return this.ids;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("mods:title")) {
            this.mods_title = this.getText();
            this.titles.add(this.mods_title);
            this.ids.add(this.mods_identifier);
            this.mods_title = this.mods_title.replace("\n", "<lb/>");
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:identifier")) {
            this.mods_identifier = this.getText();
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:start")) {
            this.mods_start = this.getText();
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:language")) {
            this.mods_language = this.getText();
            this.mods_language = this.mods_language.equals("De") ? "de" : (this.mods_language.equals("En") ? "en" : "de");
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:end")) {
            this.mods_end = this.getText();
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:name")) {
            Person aut = new Person();
            aut.setFirstName(this.author_given);
            aut.setLastName(this.author_family);
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:namePart")) {
            if (this.family) {
                this.author_family = this.getText();
                this.family = false;
            } else if (this.given) {
                this.author_given = this.getText();
                this.given = false;
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:displayForm")) {
            this.mods_displayForm = this.getText();
            this.accumulator.setLength(0);
        } else if (qName.equals("mods:mods")) {
            try {
                if (this.outputFile) {
                    File outFile = new File(this.output + "/" + this.mods_identifier + "-train.tei");
                    FileOutputStream os = new FileOutputStream(outFile);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
                    writer.write("<tei>\n\t<teiHeader>\n\t<fileDesc xml:id=\"" + this.mods_identifier + "\"/>\n\t</teiHeader>\n\t<text xml:lang=\"" + this.mods_language + "\">\n");
                    writer.write("\t\t<front>\n\t\t\t<titlePage>\n\t\t\t\t<docTitle>\n");
                    writer.write("\t\t\t\t\t<titlePart type=\"main\">" + this.mods_title + "</titlePart>\n");
                    writer.write("\t\t\t\t</docTitle>\n");
                    writer.write("\t\t\t\t<byline><docAuthor>" + this.mods_displayForm + "</docAuthor><lb/></byline>\n");
                    writer.write("\t\t\t\t<byline><affiliation><lb/></affiliation></byline>\n");
                    writer.write("\t\t\t\t<docImprint>(<title level=\"j\">Z. Naturforschg.</title> <biblScope type=\"vol\"></biblScope>, <biblScope type=\"pp\"></biblScope> [<date></date>]; <note>eingegangen am</note>)<lb/></docImprint>\n");
                    writer.write("\t\t\t</titlePage>\n");
                    writer.write("\t\t\t<div type=\"abstract\"><lb/></div>\n");
                    writer.write("\t\t\t<div type=\"intro\"></div>\n");
                    writer.write("\t\t</front>\n\t</text>\n</tei>\n");
                    ((Writer)writer).close();
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {
                throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
            }
            this.accumulator.setLength(0);
        }
        this.accumulator.setLength(0);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("mods:namePart")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || !name.equals("type")) continue;
                if (value.equals("family")) {
                    this.family = true;
                    this.given = false;
                    continue;
                }
                if (!value.equals("given")) continue;
                this.given = true;
                this.family = false;
            }
            this.accumulator.setLength(0);
        } else if (!qName.equals("mods:mods")) {
            this.accumulator.setLength(0);
        }
    }
}

