/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import org.grobid.core.data.Affiliation;
import org.grobid.core.data.BiblioItem;
import org.grobid.core.data.Person;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NLMHeaderSaxHandler
extends DefaultHandler {
    private BiblioItem biblio = null;
    private ArrayList<Person> authors = null;
    private ArrayList<String> editors = null;
    private Person author = null;
    private Affiliation affiliation = null;
    private StringBuffer accumulator = new StringBuffer();
    private String media = null;
    private String current_id = null;
    public boolean journalMetadataBlock = false;
    public boolean journalIssueBlock = false;
    public boolean journalArticleBlock = false;
    public boolean conferencePaperBlock = false;
    public boolean proceedingsMetadataBlock = false;
    public boolean contentItemBlock = false;
    public boolean eventMetadataBlock = false;
    public boolean bookMetadataBlock = false;
    public boolean serieMetadataBlock = false;
    public boolean pubDateMetadataBlock = false;
    public boolean affiliationMetadataBlock = false;
    public boolean online = false;
    public boolean date_accepted = false;
    public boolean date_submitted = false;
    public boolean authorBlock = false;
    public boolean editorBlock = false;
    public boolean firstAuthor = false;

    public NLMHeaderSaxHandler() {
    }

    public NLMHeaderSaxHandler(BiblioItem b) {
        this.biblio = b;
    }

    public BiblioItem getBiblio() {
        return this.biblio;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.accumulator.append(ch, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("journal-title")) {
            this.biblio.setJournal(this.getText());
            this.biblio.setItem(1);
        } else if (qName.equals("abbrev-journal-title")) {
            this.biblio.setJournalAbbrev(this.getText());
            this.biblio.setItem(1);
        } else if (qName.equals("issn")) {
            String issn = this.getText();
            this.biblio.setItem(1);
            if (this.media != null) {
                if (this.media.equals("print")) {
                    this.biblio.setISSN(issn);
                } else {
                    this.biblio.setISSNe(issn);
                }
            } else {
                this.biblio.setISSN(issn);
            }
        } else if (qName.equals("publisher-name")) {
            String publisher = this.getText();
            this.biblio.setPublisher(publisher);
        } else if (qName.equals("article-id ")) {
            if (this.current_id != null && this.current_id.equals("doi")) {
                String doi = this.getText();
                this.biblio.setDOI(doi);
                this.biblio.setError(false);
            }
        } else if (qName.equals("article-title")) {
            this.biblio.setArticleTitle(this.getText());
        } else if (qName.equals("contrib")) {
            this.authorBlock = false;
            this.editorBlock = false;
            if (this.authorBlock) {
                this.authors.add(this.author);
            }
            this.author = null;
        } else if (qName.equals("given_names")) {
            String sauce = this.getText();
            if (this.authorBlock) {
                if (this.author == null) {
                    this.author = new Person();
                }
                this.author.setFirstName(sauce);
            }
        } else if (qName.equals("surname")) {
            String sauce = this.getText();
            if (this.authorBlock && !sauce.equals("Unknown")) {
                if (this.author == null) {
                    this.author = new Person();
                }
                this.author.setLastName(sauce);
            }
        } else if (qName.equals("volume")) {
            String volume = this.getText();
            if (volume != null && volume.length() > 0) {
                this.biblio.setVolume(volume);
            }
        } else if (qName.equals("issue")) {
            String issue = this.getText();
            if (issue != null && issue.length() > 0) {
                this.biblio.setNumber(issue);
                this.biblio.setIssue(issue);
            }
        } else if (qName.equals("fpage")) {
            String page = this.getText();
            if (page != null && page.length() > 0) {
                if (page.startsWith("L") | page.startsWith("l")) {
                    page = page.substring(1, page.length());
                }
                this.biblio.setBeginPage(Integer.parseInt(page));
            }
        } else if (qName.equals("pub-date ")) {
            this.pubDateMetadataBlock = false;
        } else if (qName.equals("year")) {
            String year = this.getText();
            if (this.online) {
                this.biblio.setE_Year(year);
            } else if (this.date_accepted) {
                this.biblio.setA_Year(year);
            } else {
                this.biblio.setYear(year);
            }
        } else if (qName.equals("month")) {
            String month = this.getText();
            if (this.online) {
                this.biblio.setE_Month(month);
            } else if (this.date_accepted) {
                this.biblio.setA_Month(month);
            } else {
                this.biblio.setMonth(month);
            }
        } else if (qName.equals("day")) {
            String day = this.getText();
            if (this.online) {
                this.biblio.setE_Day(day);
            } else if (this.date_accepted) {
                this.biblio.setA_Day(day);
            } else {
                this.biblio.setDay(day);
            }
        } else if (qName.equals("p")) {
            String paragraph = this.getText();
            if (paragraph != null && paragraph.length() > 0) {
                if (this.biblio.getAbstract() == null) {
                    this.biblio.setAbstract(paragraph);
                } else {
                    this.biblio.setAbstract(this.biblio.getAbstract() + "\n" + paragraph);
                }
            }
        } else if (qName.equals("aff")) {
            this.affiliationMetadataBlock = false;
            if (this.author != null && this.affiliation != null) {
                this.author.addAffiliation(this.affiliation);
            }
            this.affiliation = null;
        } else if (qName.equals("country")) {
            if (this.affiliationMetadataBlock) {
                if (this.affiliation == null) {
                    this.affiliation = new Affiliation();
                }
                this.affiliation.setCountry(this.getText());
            }
        } else if (qName.equals("email")) {
            if (this.affiliationMetadataBlock && this.author != null) {
                this.author.setEmail(this.getText());
            }
        } else if (qName.equals("contrib-group")) {
            this.biblio.setFullAuthors(this.authors);
        } else if (qName.equals("date")) {
            this.pubDateMetadataBlock = false;
            this.date_accepted = false;
            this.date_submitted = false;
        }
        this.accumulator.setLength(0);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("article")) {
            int length = atts.getLength();
            if (this.biblio == null) {
                this.biblio = new BiblioItem();
            }
            for (int i = 0; i < length; ++i) {
                String value;
                String name = atts.getQName(i);
                if (!(name != null & (value = atts.getValue(i)) != null) || !name.equals("xml:lang")) continue;
                this.biblio.setLanguage(value);
            }
        } else if (qName.equals("issn")) {
            int length = atts.getLength();
            this.biblio.setItem(1);
            for (int i = 0; i < length; ++i) {
                String value;
                String name = atts.getQName(i);
                if (!(name != null & (value = atts.getValue(i)) != null) || !name.equals("pub-type")) continue;
                if (value.equals("ppub")) {
                    this.media = "print";
                    continue;
                }
                if (!value.equals("epub")) continue;
                this.media = "digital";
            }
        } else if (qName.equals("article-id ")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String value;
                String name = atts.getQName(i);
                if (!(name != null & (value = atts.getValue(i)) != null) || !name.equals("pub-id-type") || !value.equals("doi")) continue;
                this.current_id = "doi";
            }
        } else if (qName.equals("contrib-group")) {
            this.authors = new ArrayList(0);
            this.editors = new ArrayList(0);
        } else if (qName.equals("contrib")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String value;
                String name = atts.getQName(i);
                if (!(name != null & (value = atts.getValue(i)) != null) || !name.equals("contrib-type")) continue;
                if (value.equals("author")) {
                    this.authorBlock = true;
                    continue;
                }
                if (!value.equals("editor")) continue;
                this.editorBlock = true;
            }
        } else if (qName.equals("pub-date")) {
            this.pubDateMetadataBlock = true;
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String value;
                String name = atts.getQName(i);
                if (!(name != null & (value = atts.getValue(i)) != null) || !name.equals("pub-type")) continue;
                if (value.equals("ppub")) {
                    this.online = false;
                    continue;
                }
                if (!value.equals("epub")) continue;
                this.online = true;
            }
        } else if (qName.equals("aff")) {
            this.affiliationMetadataBlock = true;
        } else if (qName.equals("date")) {
            this.pubDateMetadataBlock = true;
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String value;
                String name = atts.getQName(i);
                if (!(name != null & (value = atts.getValue(i)) != null) || !name.equals("date-type") || !value.equals("accepted")) continue;
                this.date_accepted = true;
            }
        }
        this.accumulator.setLength(0);
    }
}

