/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.grobid.core.lexicon.Lexicon;
import org.grobid.core.utilities.OffsetPosition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEIAffiliationAddressSaxParser
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private StringBuffer allContent = new StringBuffer();
    private String output = null;
    private String currentTag = null;
    private ArrayList<String> labeled = null;
    public List<List<OffsetPosition>> placesPositions = null;
    private Writer writerCORA = null;
    public int n = 0;
    public Lexicon lexicon = Lexicon.getInstance();

    public void setTEIHeaderOutput(Writer writ) {
        this.writerCORA = writ;
    }

    public TEIAffiliationAddressSaxParser() {
        this.labeled = new ArrayList();
        this.placesPositions = new ArrayList<List<OffsetPosition>>();
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    public ArrayList<String> getLabeledResult() {
        return this.labeled;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("addrLine") | qName.equals("settlement") | qName.equals("region") | qName.equals("postCode") | qName.equals("postBox") | qName.equals("marker") | (qName.equals("country") | qName.equals("orgName"))) {
            String text = this.getText();
            this.writeField(text);
            if (this.allContent != null) {
                if (this.allContent.length() != 0) {
                    this.allContent.append(" ");
                }
                this.allContent.append(text);
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("lb") | qName.equals("pb")) {
            this.accumulator.append(" @newline ");
        } else if (qName.equals("affiliation")) {
            String text = this.getText();
            if (text.length() > 0) {
                this.currentTag = "<other>";
                this.writeField(text);
                if (this.allContent != null) {
                    if (this.allContent.length() != 0) {
                        this.allContent.append(" ");
                    }
                    this.allContent.append(text);
                }
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("author")) {
            String text = this.getText();
            if (text.length() > 0) {
                this.currentTag = "<other>";
                this.writeField(text);
                if (this.allContent != null) {
                    if (this.allContent.length() != 0) {
                        this.allContent.append(" ");
                    }
                    this.allContent.append(text);
                }
            }
            this.labeled.add("\n \n");
            String allString = this.allContent.toString().trim();
            allString = allString.replace("@newline", "");
            List toto = this.lexicon.inCityNames(allString);
            this.placesPositions.add(toto);
            this.allContent = null;
            allString = null;
            this.accumulator.setLength(0);
        } else {
            this.accumulator.setLength(0);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!qName.equals("lb") & !qName.equals("pb")) {
            String text = this.getText();
            if (text.length() > 0) {
                this.currentTag = "<other>";
                this.writeField(text);
                if (this.allContent != null) {
                    if (this.allContent.length() != 0) {
                        this.allContent.append(" ");
                    }
                    this.allContent.append(text);
                }
            }
            this.accumulator.setLength(0);
        }
        if (qName.equals("orgName")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || !name.equals("type")) continue;
                this.currentTag = value.equals("department") ? "<department>" : (value.equals("institution") ? "<institution>" : (value.equals("laboratory") ? "<laboratory>" : null));
            }
        } else if (qName.equals("affiliation")) {
            this.currentTag = null;
            this.accumulator.setLength(0);
            ++this.n;
        } else if (qName.equals("addrLine") | qName.equals("addrline")) {
            this.currentTag = "<addrLine>";
        } else if (qName.equals("settlement")) {
            this.currentTag = "<settlement>";
        } else if (qName.equals("region")) {
            this.currentTag = "<region>";
        } else if (qName.equals("postCode") | qName.equals("postcode")) {
            this.currentTag = "<postCode>";
        } else if (qName.equals("postBox") | qName.equals("postbox")) {
            this.currentTag = "<postBox>";
        } else if (qName.equals("country")) {
            this.currentTag = "<country>";
        } else if (qName.equals("marker")) {
            this.currentTag = "<marker>";
        } else if (qName.equals("author")) {
            this.accumulator = new StringBuffer();
            this.allContent = new StringBuffer();
        }
    }

    private void writeField(String text) {
        StringTokenizer st = new StringTokenizer(text, " \n\t([ ,:;?.!/)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660", true);
        boolean begin = true;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.length() == 0) continue;
            if (tok.equals("@newline")) {
                this.labeled.add("@newline");
            } else if (tok.equals("+PAGE+")) {
                this.labeled.add("@newline");
            } else {
                String content = tok;
                boolean i = false;
                if (content.length() > 0) {
                    if (begin) {
                        this.labeled.add(content + " I-" + this.currentTag);
                        begin = false;
                    } else {
                        this.labeled.add(content + " " + this.currentTag);
                    }
                }
            }
            begin = false;
        }
    }
}

