/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import java.util.List;
import org.grobid.core.utilities.TextUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEIAuthorSaxParser
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private String output = null;
    private String currentTag = null;
    private ArrayList<String> labeled = new ArrayList();
    private String title = null;
    private String affiliation = null;
    private String address = null;
    private String note = null;
    private String keywords = null;
    public int n = 0;

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    public ArrayList<String> getLabeledResult() {
        return this.labeled;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ((qName.equals("forename") | qName.equals("middlename") | qName.equals("title") | qName.equals("suffix") | qName.equals("surname") | qName.equals("lastname") | qName.equals("marker") | qName.equals("roleName")) & this.currentTag != null) {
            String text = this.getText();
            this.writeField(text);
        } else if (qName.equals("lb")) {
            this.accumulator.append(" +L+ ");
        } else if (qName.equals("pb")) {
            this.accumulator.append(" +PAGE+ ");
        } else if (qName.equals("author")) {
            String text = this.getText();
            if (text.length() > 0) {
                this.currentTag = "<other>";
                this.writeField(text);
            }
            this.labeled.add("\n \n");
            ++this.n;
        }
        this.accumulator.setLength(0);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String text = this.getText();
        if (text.length() > 0) {
            this.currentTag = "<other>";
            this.writeField(text);
        }
        this.accumulator.setLength(0);
        if (qName.equals("title") | qName.equals("roleName")) {
            this.currentTag = "<title>";
        } else if (qName.equals("marker")) {
            this.currentTag = "<marker>";
        } else if (qName.equals("surname") | qName.equals("lastname")) {
            this.currentTag = "<surname>";
        } else if (qName.equals("middlename")) {
            this.currentTag = "<middlename>";
        } else if (qName.equals("forename")) {
            this.currentTag = "<forename>";
        } else if (qName.equals("suffix")) {
            this.currentTag = "<suffix>";
        }
    }

    private void writeField(String text) {
        List tokens = TextUtilities.segment((String)text, (String)" ,:;?.!)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660");
        boolean begin = true;
        for (String tok : tokens) {
            if ((tok = tok.trim()).length() == 0) continue;
            boolean punct1 = false;
            if (tok.equals("+L+")) {
                this.labeled.add("@newline\n");
            } else if (tok.equals("+PAGE+")) {
                this.labeled.add("@newline\n");
            } else {
                String content = tok;
                for (int i = 0; i < " ,:;?.!)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660".length(); ++i) {
                    if (tok.length() <= 0 || tok.charAt(tok.length() - 1) != " ,:;?.!)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660".charAt(i)) continue;
                    punct1 = true;
                    content = tok.substring(0, tok.length() - 1);
                    break;
                }
                if (tok.length() > 0) {
                    if (tok.startsWith("(") & tok.length() > 1) {
                        content = punct1 ? tok.substring(1, tok.length() - 1) : tok.substring(1, tok.length());
                        if (begin) {
                            this.labeled.add("( I-" + this.currentTag + "\n");
                            begin = false;
                        } else {
                            this.labeled.add("( " + this.currentTag + "\n");
                        }
                    } else if (tok.startsWith("[") & tok.length() > 1) {
                        content = punct1 ? tok.substring(1, tok.length() - 1) : tok.substring(1, tok.length());
                        if (begin) {
                            this.labeled.add("[ I-" + this.currentTag + "\n");
                            begin = false;
                        } else {
                            this.labeled.add("[ " + this.currentTag + "\n");
                        }
                    } else if (tok.startsWith("\"") & tok.length() > 1) {
                        content = punct1 ? tok.substring(1, tok.length() - 1) : tok.substring(1, tok.length());
                        if (begin) {
                            this.labeled.add("\" I-" + this.currentTag + "\n");
                            begin = false;
                        } else {
                            this.labeled.add("\" " + this.currentTag + "\n");
                        }
                    }
                }
                if (content.length() > 0) {
                    if (begin) {
                        this.labeled.add(content + " I-" + this.currentTag + "\n");
                        begin = false;
                    } else {
                        this.labeled.add(content + " " + this.currentTag + "\n");
                    }
                }
                if (punct1) {
                    if (begin) {
                        this.labeled.add(tok.charAt(tok.length() - 1) + " I-" + this.currentTag + "\n");
                        begin = false;
                    } else {
                        this.labeled.add(tok.charAt(tok.length() - 1) + " " + this.currentTag + "\n");
                    }
                }
            }
            begin = false;
        }
    }
}

