/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEICitationOpenEdition
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private StringBuffer buffer = new StringBuffer();
    private boolean isUrl = false;
    private boolean isIssue = false;

    public String getTEI() {
        return this.buffer.toString();
    }

    public void cleanBuffer() {
        this.buffer = new StringBuffer();
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String text = this.getText();
        if (text.length() > 0) {
            this.buffer.append(text);
        }
        this.accumulator.setLength(0);
        if (qName.equals("bibl")) {
            this.buffer.append("</bibl>\n");
        } else if (qName.equals("title")) {
            this.buffer.append("</title>");
        } else if (qName.equals("author")) {
            this.buffer.append("</author>");
        } else if (qName.equals("editor")) {
            this.buffer.append("</editor>");
        } else if (qName.equals("date")) {
            this.buffer.append("</date>");
        } else if (qName.equals("biblScope")) {
            this.buffer.append("</biblScope>");
            if (this.isIssue) {
                this.isIssue = false;
                if (text.indexOf("(") != -1) {
                    System.err.println("warning, issue mixed with volume: " + text);
                }
            }
        } else if (qName.equals("publisher") || qName.equals("distributor") || qName.equals("sponsor")) {
            this.buffer.append("</publisher>");
        } else if (qName.equals("pubPlace")) {
            this.buffer.append("</pubPlace>");
        } else if (qName.equals("orgName")) {
            this.buffer.append("</orgName>");
        } else if (qName.equals("meeting")) {
            this.buffer.append("</title>");
        } else if (qName.equals("ref")) {
            if (this.isUrl) {
                this.buffer.append("</ptr>");
                this.isUrl = false;
            }
        } else if (qName.equals("extent")) {
            this.buffer.append("</biblScope>");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String text = this.getText();
        if (text.length() > 0) {
            this.buffer.append(text);
        }
        this.accumulator.setLength(0);
        if (qName.equals("bibl")) {
            this.buffer.append("/n/t/t<bibl>");
        } else if (qName.equals("title")) {
            int length = atts.getLength();
            this.buffer.append("<title");
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || value == null || !name.equals("level")) continue;
                if (value.equals("u")) {
                    this.buffer.append(" level=\"m\">");
                    continue;
                }
                if (value.equals("s")) {
                    this.buffer.append(" level=\"j\">");
                    continue;
                }
                this.buffer.append(" level=\"" + value + "\">");
            }
            this.buffer.append(">");
        } else if (qName.equals("author")) {
            this.buffer.append("<author>");
        } else if (qName.equals("editor")) {
            this.buffer.append("<editor>");
        } else if (qName.equals("date")) {
            this.buffer.append("<date>");
        } else if (qName.equals("meeting")) {
            this.buffer.append("<title level=\"m\">");
        } else if (qName.equals("publisher") || qName.equals("distributor") || qName.equals("sponsor")) {
            this.buffer.append("<publisher>");
        } else if (qName.equals("pubPlace")) {
            this.buffer.append("<pubPlace>");
        } else if (qName.equals("orgName")) {
            this.buffer.append("<orgName>");
        } else if (qName.equals("biblScope")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || value == null || !name.equals("type")) continue;
                if (value.equals("vol")) {
                    this.buffer.append("<biblScope type=\"vol\">");
                    continue;
                }
                if (value.equals("issue")) {
                    this.buffer.append("<biblScope type=\"issue\">");
                    this.isIssue = true;
                    continue;
                }
                if (value.equals("pp")) {
                    this.buffer.append("<biblScope type=\"pp\">");
                    continue;
                }
                System.err.println("warning, unexpected attribute value: " + name + "=" + value);
            }
        } else if (qName.equals("extent")) {
            this.buffer.append("<biblScope type=\"pp\">");
        } else if (qName.equals("lb")) {
            this.buffer.append(" ");
        } else if (!(qName.equals("surname") || qName.equals("forename") || qName.equals("c") || qName.equals("edition") || qName.equals("abbr") || qName.equals("hi") || qName.equals("nameLink") || qName.equals("settlement") || qName.equals("country") || qName.equals("region"))) {
            if (qName.equals("ref")) {
                int length = atts.getLength();
                if (length == 0) {
                    this.buffer.append("<ptr type=\"url\">");
                    this.isUrl = true;
                }
            } else {
                System.err.println("warning, unexpected element value: " + qName);
            }
        }
    }
}

