/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEIEbookSaxParser
extends DefaultHandler {
    private StringBuffer accumulator = null;
    private String output = null;
    private Stack<String> currentTags = null;
    private ArrayList<String> labeled = new ArrayList();

    public TEIEbookSaxParser() {
        this.currentTags = new Stack();
        this.accumulator = new StringBuffer();
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
        System.out.println(this.accumulator.toString());
    }

    public String getText() {
        if (this.accumulator != null) {
            return this.accumulator.toString().trim();
        }
        return null;
    }

    public ArrayList<String> getLabeledResult() {
        return this.labeled;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!qName.equals("lb") & !qName.equals("pb")) {
            this.writeData(qName, true);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("lb")) {
            this.accumulator.append(" +L+ ");
        } else if (qName.equals("pb")) {
            this.accumulator.append(" +PAGE+ ");
        } else {
            String text = this.getText();
            if (text != null && text.length() > 0) {
                this.writeData(qName, false);
            }
            this.accumulator.setLength(0);
            if (qName.equals("header")) {
                this.currentTags.push("<header>");
            } else if (qName.equals("other")) {
                this.currentTags.push("<other>");
            } else if (qName.equals("page_header")) {
                this.currentTags.push("<page_header>");
            } else if (qName.equals("page_footnote")) {
                this.currentTags.push("<page_footnote>");
            } else if (qName.equals("page") | qName.equals("pages")) {
                this.currentTags.push("<page>");
            } else if (qName.equals("reference")) {
                this.currentTags.push("<reference>");
            } else if (qName.equals("toc")) {
                this.currentTags.push("<toc>");
            } else if (qName.equals("index")) {
                this.currentTags.push("<index>");
            } else if (qName.equals("section")) {
                this.currentTags.push("<section>");
            }
        }
    }

    private void writeData(String qName, boolean pop) {
        if (qName.equals("header") | qName.equals("other") | qName.equals("page_header") | qName.equals("page_footnote") | qName.equals("page") | qName.equals("pages") | qName.equals("reference") | qName.equals("toc") | qName.equals("index") | qName.equals("section")) {
            String currentTag = null;
            currentTag = pop ? this.currentTags.pop() : this.currentTags.peek();
            String text = this.getText();
            StringTokenizer st = new StringTokenizer(text, " \n\t([ ,:;?.!/)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660", true);
            boolean begin = true;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.length() == 0) continue;
                if (tok.equals("+L+")) {
                    this.labeled.add("@newline\n");
                } else if (tok.equals("+PAGE+")) {
                    this.labeled.add("@newpage\n");
                } else {
                    String content = tok;
                    boolean i = false;
                    if (content.length() > 0) {
                        if (begin) {
                            this.labeled.add(content + " I-" + currentTag + "\n");
                            begin = false;
                        } else {
                            this.labeled.add(content + " " + currentTag + "\n");
                        }
                    }
                }
                begin = false;
            }
            this.accumulator.setLength(0);
        }
    }
}

