/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEIHeaderSaxParser
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private String output = null;
    private String currentTag = null;
    private String title = null;
    private String affiliation = null;
    private String address = null;
    private String note = null;
    private String keywords = null;
    private String dateString = null;
    private String fileName = null;
    private String pdfName = null;
    private ArrayList<String> labeled = new ArrayList();

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public String getAddress() {
        return this.address;
    }

    public String getNote() {
        return this.note;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getPDFName() {
        return this.pdfName;
    }

    public String getDate() {
        return this.dateString;
    }

    public ArrayList<String> getLabeledResult() {
        return this.labeled;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("titlePart")) {
            this.title = this.getText();
        }
        if (qName.equals("affiliation")) {
            this.affiliation = this.getText();
        }
        if (qName.equals("address")) {
            this.address = this.getText();
            if (this.address.trim().length() == 0) {
                this.address = null;
            }
        }
        if (qName.equals("note")) {
            this.note = this.getText();
        }
        if (qName.equals("keywords")) {
            this.keywords = this.getText();
        }
        if (qName.equals("date")) {
            this.dateString = this.getText();
        }
        if (qName.equals("titlePart") | qName.equals("note") | qName.equals("docAuthor") | qName.equals("affiliation") | qName.equals("address") | qName.equals("email") | qName.equals("idno") | qName.equals("date") | qName.equals("biblScope") | qName.equals("keywords") | qName.equals("reference") | qName.equals("degree") | qName.equals("keyword") | qName.equals("ptr") | qName.equals("div") | qName.equals("web") | qName.equals("english-title") | qName.equals("title") | qName.equals("introduction") | qName.equals("intro")) {
            String text = this.getText();
            StringTokenizer st = new StringTokenizer(text, " \n\t([ ,:;?.!/)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660", true);
            boolean begin = true;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.length() == 0) continue;
                if (tok.equals("+L+")) {
                    this.labeled.add("@newline\n");
                } else if (tok.equals("+PAGE+")) {
                    this.labeled.add("@newline\n");
                } else {
                    String content = tok;
                    boolean i = false;
                    if (content.length() > 0) {
                        if (begin) {
                            this.labeled.add(content + " I-" + this.currentTag + "\n");
                            begin = false;
                        } else {
                            this.labeled.add(content + " " + this.currentTag + "\n");
                        }
                    }
                }
                begin = false;
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("lb")) {
            this.accumulator.append(" +L+ ");
        } else if (qName.equals("pb")) {
            this.accumulator.append(" +PAGE+ ");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        block21: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block28: {
                                                    block27: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block20: {
                                                                                if (!qName.equals("div")) break block20;
                                                                                int length = atts.getLength();
                                                                                for (int i = 0; i < length; ++i) {
                                                                                    String name = atts.getQName(i);
                                                                                    String value = atts.getValue(i);
                                                                                    if (name == null || !name.equals("type")) continue;
                                                                                    if (value.equals("abstract")) {
                                                                                        this.currentTag = "<abstract>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("intro") | value.equals("introduction")) {
                                                                                        this.currentTag = "<intro>";
                                                                                        continue;
                                                                                    }
                                                                                    if (!value.equals("paragraph")) continue;
                                                                                    this.currentTag = "<other>";
                                                                                }
                                                                                break block21;
                                                                            }
                                                                            if (!qName.equals("note")) break block22;
                                                                            int length = atts.getLength();
                                                                            this.currentTag = "<note>";
                                                                            for (int i = 0; i < length; ++i) {
                                                                                String name = atts.getQName(i);
                                                                                String value = atts.getValue(i);
                                                                                if (name != null) {
                                                                                    if (!name.equals("type")) continue;
                                                                                    if (value.equals("phone")) {
                                                                                        this.currentTag = "<phone>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("degree")) {
                                                                                        this.currentTag = "<degree>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("dedication")) {
                                                                                        this.currentTag = "<dedication>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("submission")) {
                                                                                        this.currentTag = "<submission>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("english-title")) {
                                                                                        this.currentTag = "<entitle>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("other")) {
                                                                                        this.currentTag = "<note>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("reference")) {
                                                                                        this.currentTag = "<reference>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("copyright")) {
                                                                                        this.currentTag = "<copyright>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("grant")) {
                                                                                        this.currentTag = "<grant>";
                                                                                        continue;
                                                                                    }
                                                                                    if (value.equals("acknowledgment")) {
                                                                                        this.currentTag = "<note>";
                                                                                        continue;
                                                                                    }
                                                                                    this.currentTag = "<note>";
                                                                                    continue;
                                                                                }
                                                                                this.currentTag = "<note>";
                                                                            }
                                                                            this.accumulator.setLength(0);
                                                                            break block21;
                                                                        }
                                                                        if (!qName.equals("ptr")) break block23;
                                                                        int length = atts.getLength();
                                                                        for (int i = 0; i < length; ++i) {
                                                                            String name = atts.getQName(i);
                                                                            String value = atts.getValue(i);
                                                                            if (name == null || !name.equals("type") || !value.equals("web")) continue;
                                                                            this.currentTag = "<web>";
                                                                        }
                                                                        break block21;
                                                                    }
                                                                    if (!qName.equals("biblScope")) break block24;
                                                                    int length = atts.getLength();
                                                                    for (int i = 0; i < length; ++i) {
                                                                        String name = atts.getQName(i);
                                                                        String value = atts.getValue(i);
                                                                        if (name == null || !name.equals("type")) continue;
                                                                        if (value.equals("vol")) {
                                                                            this.currentTag = "<volume>";
                                                                            continue;
                                                                        }
                                                                        if (!value.equals("pp")) continue;
                                                                        this.currentTag = "<pages>";
                                                                    }
                                                                    break block21;
                                                                }
                                                                if (!qName.equals("titlePart")) break block25;
                                                                this.currentTag = "<title>";
                                                                this.accumulator.setLength(0);
                                                                break block21;
                                                            }
                                                            if (!qName.equals("idno")) break block26;
                                                            this.currentTag = "<pubnum>";
                                                            break block21;
                                                        }
                                                        if (!qName.equals("reference")) break block27;
                                                        this.currentTag = "<reference>";
                                                        break block21;
                                                    }
                                                    if (!qName.equals("degree")) break block28;
                                                    this.currentTag = "<degree>";
                                                    break block21;
                                                }
                                                if (!qName.equals("docAuthor")) break block29;
                                                this.currentTag = "<author>";
                                                break block21;
                                            }
                                            if (!qName.equals("web")) break block30;
                                            this.currentTag = "<web>";
                                            break block21;
                                        }
                                        if (!qName.equals("affiliation")) break block31;
                                        this.currentTag = "<affiliation>";
                                        this.accumulator.setLength(0);
                                        break block21;
                                    }
                                    if (!qName.equals("address")) break block32;
                                    this.currentTag = "<address>";
                                    this.accumulator.setLength(0);
                                    break block21;
                                }
                                if (!qName.equals("email")) break block33;
                                this.currentTag = "<email>";
                                break block21;
                            }
                            if (!qName.equals("date")) break block34;
                            this.currentTag = "<date>";
                            int length = atts.getLength();
                            for (int i = 0; i < length; ++i) {
                                String name = atts.getQName(i);
                                String value = atts.getValue(i);
                                if (name == null || !name.equals("type") || !value.equals("submission")) continue;
                                this.currentTag = "<date-submission>";
                            }
                            break block21;
                        }
                        if (!(qName.equals("keywords") | qName.equals("keyword"))) break block35;
                        this.currentTag = "<keyword>";
                        this.accumulator.setLength(0);
                        break block21;
                    }
                    if (!qName.equals("title")) break block36;
                    this.currentTag = "<journal>";
                    break block21;
                }
                if (!(qName.equals("introduction") | qName.equals("intro"))) break block37;
                this.currentTag = "<intro>";
                break block21;
            }
            if (!qName.equals("fileDesc")) break block21;
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || !name.equals("xml:id")) continue;
                this.pdfName = value;
            }
        }
    }
}

