/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.grobid.core.exceptions.GrobidException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEIHeaderSaxParserOCRTraining
extends DefaultHandler {
    private StringBuffer accumulator = new StringBuffer();
    private String output = null;
    private String currentTag = null;
    private Writer writer = null;
    private Writer writer_affiliations = null;
    private Writer writer_addresses = null;
    private Writer writer_keywords = null;
    private Writer writer_authors = null;
    private Writer writer_notes = null;
    public static String punctuations = ",:;?.!)-\"']";

    public TEIHeaderSaxParserOCRTraining() {
    }

    public TEIHeaderSaxParserOCRTraining(Writer writ1, Writer writ2, Writer writ3, Writer writ4, Writer writ5) {
        this.writer_affiliations = writ1;
        this.writer_addresses = writ2;
        this.writer_keywords = writ3;
        this.writer_authors = writ4;
        this.writer_notes = writ5;
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("titlePart") | qName.equals("note") | qName.equals("byline") | qName.equals("affiliation") | qName.equals("address") | qName.equals("email") | qName.equals("idno") | qName.equals("date") | qName.equals("biblScope") | qName.equals("keywords") | qName.equals("ptr") | qName.equals("div") | qName.equals("title")) {
            String text = this.getText();
            Writer writer = null;
            if (qName.equals("affiliation")) {
                writer = this.writer_affiliations;
            } else if (qName.equals("address")) {
                writer = this.writer_addresses;
            } else if (qName.equals("keywords")) {
                writer = this.writer_keywords;
            } else if (this.currentTag.equals("<author>")) {
                writer = this.writer_authors;
            } else if (qName.equals("note")) {
                writer = this.writer_notes;
            }
            if (writer != null) {
                try {
                    StringTokenizer st = new StringTokenizer(text, " \n\t");
                    while (st.hasMoreTokens()) {
                        String tok = st.nextToken().trim();
                        if (tok.length() == 0) continue;
                        boolean punct1 = false;
                        if (tok.equals("+L+")) {
                            writer.write("\n");
                            continue;
                        }
                        if (tok.equals("+PAGE+")) {
                            writer.write("\n");
                            continue;
                        }
                        String content = tok;
                        for (int i = 0; i < punctuations.length(); ++i) {
                            if (tok.length() <= 0 || tok.charAt(tok.length() - 1) != punctuations.charAt(i)) continue;
                            punct1 = true;
                            content = tok.substring(0, tok.length() - 1);
                            break;
                        }
                        if (tok.length() > 0) {
                            if (tok.startsWith("(") & tok.length() > 1) {
                                content = punct1 ? tok.substring(1, tok.length() - 1) : tok.substring(1, tok.length());
                                writer.write("( ");
                            } else if (tok.startsWith("[") & tok.length() > 1) {
                                content = punct1 ? tok.substring(1, tok.length() - 1) : tok.substring(1, tok.length());
                                writer.write("[ ");
                            } else if (tok.startsWith("\"") & tok.length() > 1) {
                                content = punct1 ? tok.substring(1, tok.length() - 1) : tok.substring(1, tok.length());
                                writer.write("\" ");
                            }
                        }
                        if (content.length() > 0) {
                            writer.write(content + " ");
                        }
                        if (!punct1) continue;
                        writer.write(tok.charAt(tok.length() - 1) + " ");
                    }
                    writer.write("\n");
                }
                catch (IOException e) {
                    throw new GrobidException("An exception occured while running Grobid.", (Throwable)e);
                }
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("lb")) {
            this.accumulator.append(" +L+ ");
        } else if (qName.equals("pb")) {
            this.accumulator.append(" +PAGE+ ");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("div")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || !name.equals("type")) continue;
                if (value.equals("abstract")) {
                    this.currentTag = "<abstract>";
                    continue;
                }
                if (value.equals("intro")) {
                    this.currentTag = "<intro>";
                    continue;
                }
                if (!value.equals("paragraph")) continue;
                this.currentTag = "<other>";
            }
        } else if (qName.equals("note")) {
            int length = atts.getLength();
            this.currentTag = "<note>";
        } else if (qName.equals("ptr")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || !name.equals("type") || !value.equals("web")) continue;
                this.currentTag = "<web>";
            }
        } else if (qName.equals("biblScope")) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                if (name == null || !name.equals("type")) continue;
                if (value.equals("vol")) {
                    this.currentTag = "<volume>";
                    continue;
                }
                if (!value.equals("pp")) continue;
                this.currentTag = "<pages>";
            }
        } else if (qName.equals("titlePart")) {
            this.currentTag = "<title>";
            this.accumulator.setLength(0);
        } else if (qName.equals("idno")) {
            this.currentTag = "<pubnum>";
        } else if (qName.equals("docAuthor")) {
            this.currentTag = "<author>";
        } else if (qName.equals("affiliation")) {
            this.currentTag = "<affiliation>";
        } else if (qName.equals("address")) {
            this.currentTag = "<address>";
        } else if (qName.equals("email")) {
            this.currentTag = "<email>";
        } else if (qName.equals("date")) {
            this.currentTag = "<date>";
        } else if (qName.equals("keywords")) {
            this.currentTag = "<keyword>";
        } else if (qName.equals("title")) {
            this.currentTag = "<journal>";
        }
    }
}

