/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.grobid.core.lexicon.Lexicon;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEIReferenceSegmenterSaxParser
extends DefaultHandler {
    private StringBuilder accumulator = new StringBuilder();
    private StringBuilder allContent = new StringBuilder();
    private String currentTag = null;
    private List<String> labeled = null;
    public Lexicon lexicon = Lexicon.getInstance();
    private int totalReferences = 0;

    public TEIReferenceSegmenterSaxParser() {
        this.labeled = new ArrayList<String>();
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        return this.accumulator.toString().trim();
    }

    public List<String> getLabeledResult() {
        return this.labeled;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("label")) {
            String text = this.getText();
            this.writeField(text);
            if (this.allContent != null) {
                if (this.allContent.length() != 0) {
                    this.allContent.append(" ");
                }
                this.allContent.append(text);
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("bibl")) {
            String text = this.getText();
            this.currentTag = "<reference>";
            this.writeField(text);
            if (this.allContent != null) {
                if (this.allContent.length() != 0) {
                    this.allContent.append(" ");
                }
                this.allContent.append(text);
            }
            this.accumulator.setLength(0);
        } else if (qName.equals("lb") || qName.equals("pb")) {
            this.accumulator.append(" @newline ");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!qName.equals("lb") && !qName.equals("pb")) {
            String text = this.getText();
            if (text.length() > 0) {
                this.currentTag = "<other>";
                this.writeField(text);
                if (this.allContent != null) {
                    if (this.allContent.length() != 0) {
                        this.allContent.append(" ");
                    }
                    this.allContent.append(text);
                }
            }
            this.accumulator.setLength(0);
        }
        if (qName.equals("bibl")) {
            this.currentTag = null;
            this.accumulator.setLength(0);
            ++this.totalReferences;
        } else if (qName.equals("label")) {
            this.currentTag = "<label>";
        }
    }

    private void writeField(String text) {
        StringTokenizer st = new StringTokenizer(text, " \n\t([ ,:;?.!/)-\u2013\"\u201c\u201d\u2018\u2019'`$]*\u2666\u2665\u2663\u2660", true);
        boolean begin = true;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.length() == 0) continue;
            if (tok.equals("@newline")) {
                this.labeled.add("@newline");
                continue;
            }
            if (tok.equals("+PAGE+")) {
                this.labeled.add("@newline");
                continue;
            }
            if (tok.length() <= 0) continue;
            if (begin) {
                this.labeled.add(tok + " I-" + this.currentTag);
                begin = false;
                continue;
            }
            this.labeled.add(tok + " " + this.currentTag);
        }
    }

    public int getTotalReferences() {
        return this.totalReferences;
    }
}

