/*
 * Decompiled with CFR 0.152.
 */
package org.grobid.trainer.sax;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TEISegmentationSaxParser
extends DefaultHandler {
    private StringBuffer accumulator = null;
    private String output = null;
    private String currentTag = null;
    private String upperQname = null;
    private String upperTag = null;
    private List<String> labeled = new ArrayList<String>();

    public TEISegmentationSaxParser() {
        this.accumulator = new StringBuffer();
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        this.accumulator.append(buffer, start, length);
    }

    public String getText() {
        if (this.accumulator != null) {
            return this.accumulator.toString().trim();
        }
        return null;
    }

    public List<String> getLabeledResult() {
        return this.labeled;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!qName.equals("lb") && !qName.equals("pb")) {
            this.writeData(qName, this.currentTag);
        }
        if (qName.equals("body") || qName.equals("cover") || qName.equals("header") || qName.equals("div") || qName.equals("listBibl")) {
            this.currentTag = null;
            this.upperTag = null;
        } else if (qName.equals("note") || qName.equals("page") || qName.equals("pages") || qName.equals("titlePage")) {
            this.currentTag = this.upperTag;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("lb")) {
            this.accumulator.append(" +L+ ");
        } else if (qName.equals("pb")) {
            this.accumulator.append(" +PAGE+ ");
        } else if (qName.equals("space")) {
            this.accumulator.append(" ");
        } else {
            String text = this.getText();
            if (text != null && text.length() > 0) {
                this.writeData(this.upperQname, this.upperTag);
            }
            this.accumulator.setLength(0);
            if (qName.equals("front")) {
                this.upperTag = this.currentTag = "<header>";
                this.upperQname = "front";
            } else if (qName.equals("body")) {
                this.upperTag = this.currentTag = "<body>";
                this.upperQname = "body";
            } else if (qName.equals("titlePage")) {
                this.currentTag = "<cover>";
            } else if (qName.equals("note")) {
                int length = atts.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    if (name == null || !name.equals("place")) continue;
                    if (value.equals("footnote")) {
                        this.currentTag = "<footnote>";
                    }
                    if (!value.equals("headnote")) continue;
                    this.currentTag = "<headnote>";
                }
            } else if (qName.equals("div")) {
                int length = atts.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    if (name == null || !name.equals("type")) continue;
                    if (value.equals("annex")) {
                        this.upperTag = this.currentTag = "<annex>";
                        this.upperQname = "div";
                        continue;
                    }
                    if (!value.equals("acknowledgement")) continue;
                    this.upperTag = this.currentTag = "<acknowledgement>";
                    this.upperQname = "div";
                }
            } else if (qName.equals("page") || qName.equals("pages")) {
                this.currentTag = "<page>";
            } else if (qName.equals("listBibl")) {
                this.upperTag = this.currentTag = "<references>";
                this.upperQname = "listBibl";
            }
        }
    }

    private void writeData(String qName, String surfaceTag) {
        if (qName.equals("front") || qName.equals("titlePage") || qName.equals("note") || qName.equals("page") || qName.equals("pages") || qName.equals("body") || qName.equals("listBibl") || qName.equals("div")) {
            String text = this.getText();
            boolean begin = true;
            String[] tokens = text.split("\\+L\\+");
            boolean page = false;
            for (int p = 0; p < tokens.length; ++p) {
                String tok;
                StringTokenizer st;
                String line = tokens[p].trim();
                if (line.equals("\n") || line.length() == 0) continue;
                if (line.indexOf("+PAGE+") != -1) {
                    line = line.replace("+PAGE+", "");
                    page = true;
                }
                if (!(st = new StringTokenizer(line, " \t")).hasMoreTokens() || (tok = st.nextToken()).length() == 0) continue;
                if (begin) {
                    this.labeled.add(tok + " I-" + surfaceTag + "\n");
                    begin = false;
                } else {
                    this.labeled.add(tok + " " + surfaceTag + "\n");
                }
                if (!page) continue;
                this.labeled.add("@newpage\n");
                page = false;
            }
            this.accumulator.setLength(0);
        }
    }
}

