/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.springboot;

import io.grpc.ServerInterceptor;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="grpcmock")
public class GrpcMockProperties {
    private Server server = new Server();

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public static class Server {
        private int port = 0;
        private Class<? extends ServerInterceptor>[] interceptors = new Class[0];
        private int executorThreadCount = 1;
        private String executorBeanName;
        private String certChainFile;
        private String privateKeyFile;
        private boolean portDynamic = false;
        private String name;
        private boolean useInProcessServer;

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public Class<? extends ServerInterceptor>[] getInterceptors() {
            return Arrays.copyOf(this.interceptors, this.interceptors.length);
        }

        public void setInterceptors(Class<? extends ServerInterceptor>[] interceptors) {
            this.interceptors = Arrays.copyOf(interceptors, interceptors.length);
        }

        public int getExecutorThreadCount() {
            return this.executorThreadCount;
        }

        public void setExecutorThreadCount(int executorThreadCount) {
            this.executorThreadCount = executorThreadCount;
        }

        public String getExecutorBeanName() {
            return this.executorBeanName;
        }

        public void setExecutorBeanName(String executorBeanName) {
            this.executorBeanName = executorBeanName;
        }

        public String getCertChainFile() {
            return this.certChainFile;
        }

        public void setCertChainFile(String certChainFile) {
            this.certChainFile = certChainFile;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        public boolean isPortDynamic() {
            return this.portDynamic;
        }

        public void setPortDynamic(boolean portDynamic) {
            this.portDynamic = portDynamic;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isUseInProcessServer() {
            return this.useInProcessServer;
        }

        public void setUseInProcessServer(boolean useInProcessServer) {
            this.useInProcessServer = useInProcessServer;
        }
    }
}

