/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.springboot;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.SocketUtils;

public class GrpcMockApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.registerPort(event.getApplicationContext().getEnvironment());
    }

    private void registerPort(ConfigurableEnvironment environment) {
        Integer httpPort = (Integer)environment.getProperty("grpcmock.server.port", Integer.class);
        if (httpPort == null) {
            return;
        }
        if (httpPort.equals(0)) {
            int availablePort = SocketUtils.findAvailableTcpPort();
            MapPropertySource properties = Optional.ofNullable(environment.getPropertySources().remove("grpcmock")).map(MapPropertySource.class::cast).orElseGet(() -> new MapPropertySource("grpcmock", new HashMap()));
            environment.getPropertySources().addFirst((PropertySource)properties);
            ((Map)properties.getSource()).put("grpcmock.server.port", availablePort);
            ((Map)properties.getSource()).put("grpcmock.server.port-dynamic", true);
        }
    }
}

