/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.springboot;

import io.grpc.ServerInterceptor;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.grpcmock.GrpcMock;
import org.grpcmock.GrpcMockBuilder;
import org.grpcmock.exception.GrpcMockException;
import org.grpcmock.springboot.GrpcMockProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={GrpcMockProperties.class})
public class GrpcMockConfiguration
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(GrpcMockConfiguration.class);
    private static final String GRPCMOCK_BEAN_NAME = "grpcMock";
    private final GrpcMockProperties properties;
    private final ApplicationContext context;
    private final DefaultListableBeanFactory beanFactory;
    private volatile boolean running;
    private GrpcMock server;

    @Autowired
    GrpcMockConfiguration(GrpcMockProperties properties, ApplicationContext context, DefaultListableBeanFactory beanFactory) {
        this.properties = properties;
        this.context = context;
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    public void init() {
        if (this.isRunning()) {
            this.resetAll();
            this.updateGlobalServer();
            return;
        }
        GrpcMockBuilder serverBuilder = GrpcMock.grpcMock((int)this.properties.getServer().getPort());
        Optional.ofNullable(this.properties.getServer().getInterceptors()).ifPresent(interceptors -> Stream.of(interceptors).filter(Objects::nonNull).map(this::getInterceptorInstance).forEach(arg_0 -> ((GrpcMockBuilder)serverBuilder).interceptor(arg_0)));
        Executor executor = Optional.ofNullable(this.properties.getServer().getExecutorBeanName()).filter(StringUtils::hasText).map(name -> (Executor)this.context.getBean(name, Executor.class)).orElseGet(() -> Optional.of(this.properties.getServer().getExecutorThreadCount()).filter(threads -> threads > 0).map(Executors::newFixedThreadPool).orElse(null));
        Optional.ofNullable(executor).ifPresent(arg_0 -> ((GrpcMockBuilder)serverBuilder).executor(arg_0));
        String certChain = this.properties.getServer().getCertChainFile();
        String privateKey = this.properties.getServer().getPrivateKeyFile();
        if (StringUtils.hasText((String)certChain) && StringUtils.hasText((String)privateKey)) {
            serverBuilder.transportSecurity(Paths.get(certChain, new String[0]).toFile(), Paths.get(privateKey, new String[0]).toFile());
        } else if (!Objects.equals(certChain, privateKey)) {
            throw new GrpcMockException("Both certChain and privateKey have to be defined");
        }
        log.debug(String.format("Creating a new GrpcMock server at http port [%d]", this.properties.getServer().getPort()));
        this.server = serverBuilder.build();
    }

    public void start() {
        this.server.start();
        this.updateGlobalServer();
    }

    public void stop() {
        if (this.isRunning()) {
            this.server.stop();
            this.server = null;
            this.running = false;
            log.debug("Stopped GrpcMock instance");
        } else {
            log.debug("Server already stopped");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void resetAll() {
        this.server.resetAll();
    }

    private void updateGlobalServer() {
        GrpcMock.configureFor((GrpcMock)this.server);
        this.recreateBean();
        this.running = true;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Started GrpcMock at port [%d]", this.properties.getServer().getPort()));
        }
    }

    private void recreateBean() {
        if (!this.beanFactory.containsBean(GRPCMOCK_BEAN_NAME)) {
            this.beanFactory.registerSingleton(GRPCMOCK_BEAN_NAME, (Object)this.server);
        } else {
            this.beanFactory.destroySingleton(GRPCMOCK_BEAN_NAME);
            this.beanFactory.registerSingleton(GRPCMOCK_BEAN_NAME, (Object)this.server);
        }
    }

    private ServerInterceptor getInterceptorInstance(Class<? extends ServerInterceptor> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new GrpcMockException("Default constructor is not accessible or missing no-args constructor for interceptor: " + clazz, (Throwable)e);
        }
    }
}

