/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.spring;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Iterables;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.Arrays;
import java.util.Collections;
import org.guiceyfruit.jsr250.Jsr250Module;
import org.guiceyfruit.spring.support.AutowiredMemberProvider;
import org.guiceyfruit.spring.support.DisposableBeanCloser;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SpringModule
extends Jsr250Module {
    public static Injector createInjector(Module ... modules) {
        Iterable iterable = Iterables.concat(Collections.singletonList(new SpringModule()), Arrays.asList(modules));
        return Guice.createInjector((Iterable)iterable);
    }

    protected void configure() {
        super.configure();
        this.bindAnnotationInjector(Autowired.class, AutowiredMemberProvider.class);
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                Class type = injectableType.getRawType();
                if (InitializingBean.class.isAssignableFrom(type)) {
                    encounter.register(new InjectionListener<I>(){

                        public void afterInjection(I injectee) {
                            if (injectee instanceof InitializingBean) {
                                InitializingBean initializingBean = (InitializingBean)injectee;
                                try {
                                    initializingBean.afterPropertiesSet();
                                }
                                catch (Exception e) {
                                    throw new ProvisionException("Failed to invoke afterPropertiesSet(): " + e, (Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        });
        this.bind(DisposableBeanCloser.class);
    }
}

