/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.spring.support;

import com.google.inject.Binding;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Iterables;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Preconditions;
import com.google.inject.internal.Sets;
import com.google.inject.name.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.guiceyfruit.Injectors;
import org.guiceyfruit.spring.NoAutowire;
import org.guiceyfruit.support.AnnotationMemberProviderSupport;
import org.guiceyfruit.support.Comparators;
import org.guiceyfruit.support.Predicate;
import org.guiceyfruit.support.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowiredMemberProvider
extends AnnotationMemberProviderSupport<Autowired> {
    private final Injector injector;

    @Inject
    public AutowiredMemberProvider(Injector injector) {
        Preconditions.checkNotNull((Object)injector, (Object)"injector");
        this.injector = injector;
    }

    public boolean isNullParameterAllowed(Autowired annotation, Method method, Class<?> parameterType, int parameterIndex) {
        return !annotation.required();
    }

    protected Object provide(Autowired annotation, Member member, TypeLiteral<?> typeLiteral, Class<?> memberType, Annotation[] annotations) {
        Predicate<Binding> filter = this.createQualifierFilter(member, annotations);
        Class type = typeLiteral.getRawType();
        if (type.isArray()) {
            return this.provideArrayValue(member, typeLiteral, memberType, filter);
        }
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection = this.createCollection(type);
            return this.provideCollectionValues(collection, member, typeLiteral, filter);
        }
        if (Map.class.isAssignableFrom(type)) {
            Map map = this.createMap(type);
            return this.provideMapValues(map, member, typeLiteral, filter);
        }
        return this.provideSingleValue(member, type, annotation, filter);
    }

    protected Predicate<Binding> createQualifierFilter(Member member, Annotation[] parameterAnnotations) {
        if (member instanceof AnnotatedElement) {
            int size;
            Annotation[] annotations;
            AnnotatedElement annotatedElement = (AnnotatedElement)((Object)member);
            Qualifier qualifier = annotatedElement.getAnnotation(Qualifier.class);
            if (qualifier != null) {
                final String expectedValue = qualifier.value();
                final boolean notEmptyValue = Strings.isNotEmpty((String)expectedValue);
                return new Predicate<Binding>(){

                    public boolean matches(Binding binding) {
                        String value = AutowiredMemberProvider.this.annotationName(binding);
                        if (notEmptyValue) {
                            return Comparators.equal((Object)expectedValue, (Object)value);
                        }
                        return Strings.isNotEmpty((String)value);
                    }

                    public String toString() {
                        return "@Autowired @Qualifier(" + expectedValue + ")";
                    }
                };
            }
            HashSet qualifiedAnnotations = Sets.newHashSet();
            for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
                if (!this.isQualified(annotation)) continue;
                qualifiedAnnotations.add(annotation);
            }
            if (parameterAnnotations != null) {
                for (Annotation annotation : parameterAnnotations) {
                    if (!this.isQualified(annotation)) continue;
                    qualifiedAnnotations.add(annotation);
                }
            }
            if ((size = qualifiedAnnotations.size()) == 1) {
                final Annotation annotation = (Annotation)Iterables.getOnlyElement((Iterable)qualifiedAnnotations);
                return new Predicate<Binding>(){

                    public boolean matches(Binding binding) {
                        Annotation actualAnnotation = binding.getKey().getAnnotation();
                        return actualAnnotation != null && ((Object)actualAnnotation).equals(annotation);
                    }

                    public String toString() {
                        return "@Autowired " + annotation;
                    }
                };
            }
            if (size > 0) {
                throw new ProvisionException("Too many qualified annotations " + qualifiedAnnotations + " when trying to inject " + member);
            }
        }
        return new Predicate<Binding>(){

            public boolean matches(Binding binding) {
                return true;
            }

            public String toString() {
                return "@Autowired";
            }
        };
    }

    protected boolean isQualified(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Qualifier qualified = annotationType.getAnnotation(Qualifier.class);
        return qualified != null && annotationType.getAnnotation(BindingAnnotation.class) != null;
    }

    protected Object provideSingleValue(Member member, Class<?> type, Autowired annotation, Predicate<Binding> filter) {
        Set<Binding<?>> set = this.getSortedBindings(type, filter);
        int size = set.size();
        if (size == 1) {
            Binding binding = (Binding)Iterables.getOnlyElement(set);
            return binding.getProvider().get();
        }
        if (size == 0) {
            try {
                Binding binding = this.injector.getBinding(type);
                if (filter.matches((Object)binding)) {
                    return binding.getProvider().get();
                }
                if (annotation.required()) {
                    throw new ProvisionException("Could not find required binding for " + filter + " when injecting " + member);
                }
                return null;
            }
            catch (Exception e) {
                if (annotation.required()) {
                    if (e instanceof ProvisionException) {
                        throw (ProvisionException)e;
                    }
                    throw new ProvisionException("Could not resolve type " + type.getCanonicalName() + " with filter " + filter + " when injecting " + member + ": " + e, (Throwable)e);
                }
                return null;
            }
        }
        throw new ProvisionException("Too many bindings " + size + " found for " + type.getCanonicalName() + " with keys " + AutowiredMemberProvider.keys(set) + " when injecting " + member);
    }

    public static List<Key<?>> keys(Iterable<Binding<?>> bindings) {
        ArrayList answer = Lists.newArrayList();
        for (Binding<?> binding : bindings) {
            answer.add(binding.getKey());
        }
        return answer;
    }

    protected Object provideArrayValue(Member member, TypeLiteral<?> type, Class<?> memberType, Predicate<Binding> filter) {
        Class<?> componentType = memberType.getComponentType();
        Set<Binding<?>> set = this.getSortedBindings(componentType, filter);
        if (set.isEmpty()) {
            return null;
        }
        Object array = Array.newInstance(componentType, set.size());
        int index = 0;
        for (Binding<?> binding : set) {
            Object value = binding.getProvider().get();
            Array.set(array, index++, value);
        }
        return array;
    }

    private Collection provideCollectionValues(Collection collection, Member member, TypeLiteral<?> type, Predicate<Binding> filter) {
        Class componentType;
        Type argument;
        ParameterizedType parameterizedType;
        Type[] arguments;
        Type typeInstance = type.getType();
        if (typeInstance instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)typeInstance).getActualTypeArguments()).length == 1 && (argument = arguments[0]) instanceof Class && (componentType = (Class)argument) != Object.class) {
            Set<Binding<?>> set = this.getSortedBindings(componentType, filter);
            if (set.isEmpty()) {
                return null;
            }
            for (Binding<?> binding : set) {
                Object value = binding.getProvider().get();
                collection.add(value);
            }
            return collection;
        }
        return null;
    }

    protected Map provideMapValues(Map map, Member member, TypeLiteral<?> type, Predicate<Binding> filter) {
        Type key;
        ParameterizedType parameterizedType;
        Type[] arguments;
        Type typeInstance = type.getType();
        if (typeInstance instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)typeInstance).getActualTypeArguments()).length == 2 && (key = arguments[0]) instanceof Class) {
            Class componentType;
            Class keyType = (Class)key;
            if (keyType != Object.class && keyType != String.class) {
                throw new ProvisionException("Cannot inject Map instances with a key type of " + keyType.getName() + " for " + member);
            }
            Type valueType = arguments[1];
            if (valueType instanceof Class && (componentType = (Class)valueType) != Object.class) {
                Set<Binding<?>> set = this.getSortedBindings(componentType, filter);
                if (set.isEmpty()) {
                    return null;
                }
                for (Binding<?> binding : set) {
                    String keyValue = binding.getKey().toString();
                    Object value = binding.getProvider().get();
                    map.put(keyValue, value);
                }
                return map;
            }
        }
        return null;
    }

    protected Map createMap(Class<?> type) {
        Object answer = this.tryCreateInstance(type);
        if (answer instanceof Map) {
            return (Map)answer;
        }
        if (SortedMap.class.isAssignableFrom(type)) {
            return new TreeMap();
        }
        return new HashMap();
    }

    protected Collection createCollection(Class<?> type) {
        Object answer = this.tryCreateInstance(type);
        if (answer instanceof Collection) {
            return (Collection)answer;
        }
        if (SortedSet.class.isAssignableFrom(type)) {
            return new TreeSet();
        }
        if (Set.class.isAssignableFrom(type)) {
            return new HashSet();
        }
        return new ArrayList();
    }

    protected Object tryCreateInstance(Class<?> type) {
        Object answer = null;
        int modifiers = type.getModifiers();
        if (!Modifier.isAbstract(modifiers) && Modifier.isPublic(modifiers) && !type.isInterface()) {
            Constructor<?> constructor = null;
            try {
                constructor = type.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (constructor != null && Modifier.isPublic(constructor.getModifiers())) {
                try {
                    answer = constructor.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new ProvisionException("Failed to instantiate " + constructor, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ProvisionException("Failed to instantiate " + constructor, (Throwable)e);
                }
                catch (InvocationTargetException ie) {
                    Throwable e = ie.getTargetException();
                    throw new ProvisionException("Failed to instantiate " + constructor, e);
                }
            }
        }
        return answer;
    }

    protected Set<Binding<?>> getSortedBindings(Class<?> type, Predicate<Binding> filter) {
        TreeSet answer = new TreeSet(new Comparator<Binding<?>>(){

            @Override
            public int compare(Binding<?> b1, Binding<?> b2) {
                int answer = AutowiredMemberProvider.typeName(b1).compareTo(AutowiredMemberProvider.typeName(b2));
                if (answer == 0) {
                    String n1 = AutowiredMemberProvider.this.annotationName(b1);
                    String n2 = AutowiredMemberProvider.this.annotationName(b2);
                    if (n1 != null || n2 != null) {
                        if (n1 == null) {
                            return -1;
                        }
                        if (n2 == null) {
                            return 1;
                        }
                        return n1.compareTo(n2);
                    }
                }
                return answer;
            }
        });
        Set bindings = Injectors.getBindingsOf((Injector)this.injector, type);
        for (Binding binding : bindings) {
            if (!this.isValidAutowireBinding(binding) || !filter.matches((Object)binding)) continue;
            answer.add(binding);
        }
        return answer;
    }

    protected boolean isValidAutowireBinding(Binding<?> binding) {
        Key key = binding.getKey();
        Annotation annotation = key.getAnnotation();
        if (annotation instanceof NoAutowire) {
            return false;
        }
        Class annotationType = key.getAnnotationType();
        return annotationType == null || !NoAutowire.class.isAssignableFrom(annotationType);
    }

    private String annotationName(Binding<?> binding) {
        Annotation annotation = binding.getKey().getAnnotation();
        if (annotation instanceof Named) {
            Named named = (Named)annotation;
            return named.value();
        }
        if (annotation instanceof Qualifier) {
            Qualifier qualifier = (Qualifier)annotation;
            return qualifier.value();
        }
        return null;
    }

    protected static String typeName(Binding<?> bindings) {
        return bindings.getKey().getTypeLiteral().getRawType().getName();
    }
}

