/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.jpa.support;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.guiceyfruit.support.AnnotationMemberProviderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceMemberProvider
extends AnnotationMemberProviderSupport<PersistenceContext> {
    private final Provider<EntityManager> defaultEntityManager;
    private Map<String, Provider<EntityManager>> namedEntityManagers;

    @Inject
    public PersistenceMemberProvider(Provider<EntityManager> defaultEntityManager) {
        this.defaultEntityManager = defaultEntityManager;
    }

    protected Object provide(PersistenceContext annotation, Member member, TypeLiteral<?> requiredType, Class<?> memberType, Annotation[] annotations) {
        Provider<EntityManager> provider = null;
        String name = annotation.name();
        if (this.namedEntityManagers != null && name != null && name.length() > 0) {
            provider = this.namedEntityManagers.get(name);
        }
        if (provider == null) {
            provider = this.defaultEntityManager;
        }
        return provider.get();
    }

    public boolean isNullParameterAllowed(PersistenceContext annotation, Method method, Class<?> parameterType, int parameterIndex) {
        return false;
    }

    public Map<String, Provider<EntityManager>> getNamedEntityManagers() {
        return this.namedEntityManagers;
    }

    @Inject(optional=true)
    public void setNamedEntityManagers(Map<String, Provider<EntityManager>> namedEntityManagers) {
        this.namedEntityManagers = namedEntityManagers;
    }
}

