/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.spring.converter;

import com.google.common.base.Join;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.guiceyfruit.spring.converter.ProduceMethod;
import org.guiceyfruit.spring.converter.SpringConverter;

public class ModuleGenerator {
    private final SpringConverter converter;
    private final PrintWriter writer;
    private final List<ProduceMethod> methods = new ArrayList<ProduceMethod>();

    public ModuleGenerator(SpringConverter converter, PrintWriter writer) {
        this.converter = converter;
        this.writer = writer;
    }

    public void generate() {
        this.start();
        for (ProduceMethod method : this.methods) {
            this.write(method);
        }
        this.end();
    }

    public ProduceMethod startProvides(String name, String className) {
        ProduceMethod method = new ProduceMethod(name, className);
        this.methods.add(method);
        return method;
    }

    protected void start() {
        this.println("//----------------------------------------------------------------------------------------");
        this.println("// Generated by the Guice SpringConverter at " + new Date());
        this.println("//----------------------------------------------------------------------------------------");
        if (this.converter.hasPackage()) {
            this.println("package %s;", this.converter.getPackageName());
            this.println();
        }
        this.println();
        SortedSet<String> names = this.converter.getImports();
        for (String name : names) {
            this.println("import %s;", name);
        }
        this.println();
        this.println("public class %s extends AbstractModule {", this.converter.getClassName());
    }

    protected void end() {
        this.println();
        this.println("}");
        this.println();
    }

    protected void write(ProduceMethod method) {
        String name = method.getName();
        String className = method.getClassName();
        this.println();
        this.println("  @Provides @Named(\"%s\")", name);
        this.println("  %s %s(%s) {", className, ModuleGenerator.asJavaIdentifier(name), Join.join((String)", ", method.getParameters()));
        List<ProduceMethod.MethodCall> methodCalls = method.getMethodCalls();
        if (methodCalls.isEmpty()) {
            this.print("    return ", new Object[0]);
            this.printConstructor(method);
            this.println();
        } else {
            this.print("    %s answer = ", className);
            this.printConstructor(method);
            this.println(";");
            for (ProduceMethod.MethodCall methodCall : methodCalls) {
                this.println("    %s", methodCall);
            }
            this.println("    return answer;");
        }
        this.println("  }");
    }

    public static String asJavaIdentifier(String name) {
        return name.replace('-', '_').replace('.', '_').replace('/', '_').replace('\\', '_');
    }

    protected void printConstructor(ProduceMethod method) {
        this.print("%s(%s)", method.getClassName(), Join.join((String)", ", method.getConstructorExpressions()));
    }

    protected void print(String text, Object ... args) {
        this.writer.print(String.format(text, args));
    }

    protected void println(String text, Object ... args) {
        this.writer.println(String.format(text, args));
    }

    protected void println(String text) {
        this.writer.println(text);
    }

    protected void println() {
        this.writer.println();
    }
}

