/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.spring.converter;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProduceMethod {
    private final String name;
    private final String className;
    private List<String> constructorExpressions = new ArrayList<String>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<MethodCall> methodCalls = new ArrayList<MethodCall>();

    public ProduceMethod(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getConstructorExpressions() {
        return this.constructorExpressions;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<MethodCall> getMethodCalls() {
        return this.methodCalls;
    }

    public void addConstructorExpression(String expression) {
        this.constructorExpressions.add(expression);
    }

    public void addParameter(String typeName, String beanRef) {
        this.parameters.add(new Parameter(typeName, beanRef));
    }

    public void addMethodCall(String object, String method, String expression) {
        this.methodCalls.add(new MethodCall(object, method, expression));
    }

    public static class MethodCall {
        private final String object;
        private final String method;
        private final String expression;

        public MethodCall(String object, String method, String expression) {
            this.object = object;
            this.method = method;
            this.expression = expression;
        }

        public String toString() {
            return this.object + "." + this.method + "(" + this.expression + ");";
        }
    }

    public static class Parameter {
        private final String type;
        private final String name;

        public Parameter(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type + " " + this.name;
        }
    }
}

