/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.spring.converter;

import com.google.inject.internal.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.guiceyfruit.spring.converter.ModuleGenerator;
import org.guiceyfruit.spring.converter.ProduceMethod;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringConverter {
    private final XmlBeanFactory beanFactory;
    private String packageName = "";
    private String className = "MyModule";
    private String outputDir;
    private SortedSet<String> imports = new TreeSet<String>();
    private Set<String> ignoreClasses = new HashSet<String>();
    private Map<String, String> shortClassNames = new HashMap<String, String>();

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: springXmlFile [outputDirectory] [outputClassName]");
        } else {
            String springFile = args[0];
            XmlBeanFactory beanFactory = null;
            try {
                beanFactory = new XmlBeanFactory((Resource)new FileSystemResource(springFile));
            }
            catch (BeansException e) {
                System.out.println("Failed to open: " + springFile + ". Reason: " + (Object)((Object)e));
                e.printStackTrace();
                return;
            }
            try {
                SpringConverter converter = new SpringConverter(beanFactory);
                converter.convert();
            }
            catch (Exception e) {
                System.out.println("Failed to file from: " + springFile);
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }

    public SpringConverter(XmlBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.ignoreClasses.add("org.springframework.beans.factory.config.PropertyPlaceholderConfigurer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert() throws Exception {
        this.addImport("com.google.inject.AbstractModule");
        this.addImport("com.google.inject.Provides");
        PrintWriter writer = this.createOutputFileWriter();
        try {
            String[] names;
            ModuleGenerator generator = new ModuleGenerator(this, writer);
            for (String name : names = this.beanFactory.getBeanDefinitionNames()) {
                BeanDefinition definition = this.beanFactory.getBeanDefinition(name);
                String className = definition.getBeanClassName();
                if (this.ignoreClasses.contains(className)) continue;
                this.generateBeanDefinition(generator, name, definition, className);
            }
            generator.generate();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected void generateBeanDefinition(ModuleGenerator generator, String name, BeanDefinition definition, String className) {
        PropertyValue[] propertyArray;
        String shortClassName = this.addImport(className);
        ProduceMethod method = generator.startProvides(name, shortClassName);
        ConstructorArgumentValues constructors = definition.getConstructorArgumentValues();
        Map map = constructors.getIndexedArgumentValues();
        int size = map.size();
        for (int i = 0; i < size; ++i) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)map.get(i);
            if (valueHolder == null) continue;
            Object value = valueHolder.getValue();
            if (value instanceof TypedStringValue) {
                TypedStringValue stringValue = (TypedStringValue)value;
                String text = stringValue.getValue();
                System.out.printf("param %s=\"%s\"\n", i, text);
                String expression = null;
                String namedParameter = this.namedParameter(text);
                expression = namedParameter != null ? this.addParameter(method, "String", namedParameter) : "\"" + text + "\"";
                method.addConstructorExpression(expression);
                continue;
            }
            if (!(value instanceof BeanReference)) continue;
            BeanReference reference = (BeanReference)value;
            String beanRef = reference.getBeanName();
            String typeName = "Object";
            String expression = this.addParameter(method, typeName, beanRef);
            method.addConstructorExpression(expression);
        }
        MutablePropertyValues propertyValues = definition.getPropertyValues();
        for (PropertyValue propertyValue : propertyArray = propertyValues.getPropertyValues()) {
            String text;
            String namedParameter;
            String property = this.getSetterMethod(propertyValue);
            Object value = propertyValue.getConvertedValue();
            if (value == null) {
                value = propertyValue.getValue();
            }
            if (value instanceof BeanReference) {
                BeanReference reference = (BeanReference)value;
                String beanRef = reference.getBeanName();
                String typeName = "Object";
                String expression = this.addParameter(method, typeName, beanRef);
                method.addMethodCall("answer", this.getSetterMethod(propertyValue), expression);
                continue;
            }
            if (value instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder beanDefinitionHolder = (BeanDefinitionHolder)value;
                this.addChildBeanDefinition(generator, method, name, propertyValue, beanDefinitionHolder.getBeanDefinition());
                continue;
            }
            if (value instanceof ChildBeanDefinition) {
                ChildBeanDefinition childBeanDefinition = (ChildBeanDefinition)value;
                this.addChildBeanDefinition(generator, method, name, propertyValue, (BeanDefinition)childBeanDefinition);
                continue;
            }
            if (value instanceof TypedStringValue) {
                TypedStringValue stringValue = (TypedStringValue)value;
                value = stringValue.getValue();
            }
            String valueType = value == null ? null : value.getClass().getName();
            System.out.printf("property %s=%s of type %s\n", property, value, valueType);
            String expression = value instanceof String ? ((namedParameter = this.namedParameter(text = (String)value)) != null ? this.addParameter(method, "String", namedParameter) : "\"" + value + "\"") : (value == null ? "null" : value.toString());
            method.addMethodCall("answer", this.getSetterMethod(propertyValue), expression);
        }
    }

    protected String namedParameter(String text) {
        if (text.startsWith("${") && text.endsWith("}")) {
            return text.substring(2, text.length() - 1);
        }
        return null;
    }

    protected void addChildBeanDefinition(ModuleGenerator generator, ProduceMethod method, String name, PropertyValue propertyValue, BeanDefinition beanDefinition) {
        String childBeanName = this.childBeanName(name, propertyValue.getName());
        String childType = this.addImport(beanDefinition.getBeanClassName());
        String expression = this.addParameter(method, childType, childBeanName);
        this.generateBeanDefinition(generator, childBeanName, beanDefinition, childType);
        method.addMethodCall("answer", this.getSetterMethod(propertyValue), expression);
    }

    protected String addParameter(ProduceMethod method, String typeName, String beanRef) {
        String identifier = ModuleGenerator.asJavaIdentifier(beanRef);
        method.addParameter(this.namedParameterType(typeName, beanRef), identifier);
        return identifier;
    }

    protected String namedParameterType(String typeName, String beanRef) {
        return String.format("@Named(\"%s\") %s", beanRef, typeName);
    }

    protected String childBeanName(String name, String property) {
        return name + "." + property;
    }

    protected String getSetterMethod(PropertyValue propertyValue) {
        return "set" + Strings.capitalize((String)propertyValue.getName());
    }

    protected String addImport(String className) {
        if (!className.contains(".")) {
            return className;
        }
        this.imports.add(className);
        String[] names = this.splitClassName(className);
        String shortName = names[1];
        String alias = this.shortClassNames.get(shortName);
        if (alias != null && !alias.equals(className)) {
            return className;
        }
        this.shortClassNames.put(shortName, className);
        return shortName;
    }

    protected String[] splitClassName(String className) {
        int idx = className.lastIndexOf(".");
        if (idx <= 0) {
            return new String[]{"", className};
        }
        return new String[]{className.substring(0, idx), className.substring(idx + 1)};
    }

    public boolean hasPackage() {
        return this.packageName != null && this.packageName.length() > 0;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public SortedSet<String> getImports() {
        return this.imports;
    }

    protected PrintWriter createOutputFileWriter() throws IOException {
        if (this.outputDir == null) {
            return new PrintWriter(new OutputStreamWriter(System.out));
        }
        File file = new File(this.getOutputFileName());
        file.getParentFile().mkdirs();
        return new PrintWriter(new FileWriter(file));
    }

    protected String getOutputFileName() {
        StringBuilder buffer = new StringBuilder(this.outputDir);
        if (this.hasPackage()) {
            buffer.append(this.packageName.replace('.', '/'));
            buffer.append("/");
        }
        buffer.append(this.className);
        buffer.append(".java");
        return buffer.toString();
    }
}

