/*
 * Decompiled with CFR 0.152.
 */
package gurux.common;

import gurux.common.GXCmdParameter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class GXCommon {
    static final int HEX_SIZE = 3;
    static final int HEX_A_DECIMAL_VALUE = 10;
    static final int MAX_BYTE_SIZE = 255;
    static final int SHORT_BYTES = 2;
    static final int INTEGER_BYTES = 4;
    static final int LONG_BYTES = 4;
    static final int LOW_BYTE_PART = 15;
    static final int NIBBLE = 4;

    private GXCommon() {
    }

    public static byte getHighByte(int value) {
        return (byte)(value >>> 4);
    }

    public static byte getLowByte(int value) {
        return (byte)(value & 0xF);
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 3];
        for (int pos = 0; pos != bytes.length; ++pos) {
            int tmp = bytes[pos] & 0xFF;
            hexChars[pos * 3] = hexArray[GXCommon.getHighByte(tmp)];
            hexChars[pos * 3 + 1] = hexArray[GXCommon.getLowByte(tmp)];
            hexChars[pos * 3 + 2] = 32;
        }
        return new String(hexChars, 0, hexChars.length - 1);
    }

    private static byte getValue(byte c) {
        byte value;
        if (c > 57) {
            value = c > 90 ? (byte)(c - 97) : (byte)(c - 65);
            value = (byte)(value + 10);
        } else {
            value = (byte)(c - 48);
        }
        return value;
    }

    public static byte[] hexToBytes(String value) {
        byte[] buffer = new byte[value.length() / 2];
        int lastValue = -1;
        int index = 0;
        try {
            for (byte ch : value.getBytes("ASCII")) {
                if (ch >= 48 && ch < 103) {
                    if (lastValue == -1) {
                        lastValue = GXCommon.getValue(ch);
                        continue;
                    }
                    if (lastValue == -1) continue;
                    buffer[index] = (byte)(lastValue << 4 | GXCommon.getValue(ch));
                    lastValue = -1;
                    ++index;
                    continue;
                }
                if (lastValue == -1) continue;
                buffer[index] = GXCommon.getValue(ch);
                lastValue = -1;
                ++index;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        byte[] tmp = new byte[index];
        System.arraycopy(buffer, 0, tmp, 0, index);
        return tmp;
    }

    public static List<GXCmdParameter> getParameters(String[] args, String optstring) {
        ArrayList<GXCmdParameter> list = new ArrayList<GXCmdParameter>();
        for (int index = 0; index < args.length; ++index) {
            if (args[index].charAt(0) != '-' && args[index].charAt(0) != '/') {
                throw new IllegalArgumentException("Invalid parameter: " + args[index]);
            }
            int pos = optstring.indexOf(args[index].charAt(1));
            if (pos == -1) {
                throw new IllegalArgumentException("Invalid parameter: " + args[index]);
            }
            GXCmdParameter c = new GXCmdParameter();
            c.setTag(args[index].charAt(1));
            list.add(c);
            if (pos >= optstring.length() - 1 || optstring.charAt(1 + pos) != ':') continue;
            if (args.length <= ++index) {
                c.setMissing(true);
            }
            c.setValue(args[index]);
        }
        return list;
    }
}

