/*
 * Decompiled with CFR 0.152.
 */
package gurux.common;

import gurux.common.AutoResetEvent;
import gurux.common.ReceiveParameters;
import gurux.common.enums.TraceLevel;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class GXSynchronousMediaBase {
    private TraceLevel trace;
    private RuntimeException exception;
    private byte[] receivedBuffer = null;
    private AutoResetEvent receivedEvent = new AutoResetEvent(false);
    private final Object sync = new Object();
    private int receivedSize;
    private int lastPosition;

    public final void resetLastPosition() {
        this.lastPosition = 0;
    }

    public final void resetReceivedSize() {
        this.receivedSize = 0;
    }

    public final void setReceived() {
        this.receivedEvent.set();
    }

    public final RuntimeException getException() {
        return this.exception;
    }

    public final void setException(RuntimeException value) {
        this.exception = value;
    }

    public final Object getSync() {
        return this.sync;
    }

    public final TraceLevel getTrace() {
        return this.trace;
    }

    public final void setTrace(TraceLevel value) {
        this.trace = value;
    }

    public int getReceivedSize() {
        return this.receivedSize;
    }

    public byte[] getReceivedData() {
        byte[] tmp = new byte[this.receivedSize];
        if (this.receivedSize != 0) {
            System.arraycopy(this.receivedBuffer, 0, tmp, 0, this.receivedSize);
        }
        return tmp;
    }

    public static byte[] getAsByteArray(Object value) {
        if (value == null) {
            return new byte[0];
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Byte) {
            return new byte[]{(Byte)value};
        }
        if (value instanceof Character) {
            return new byte[]{(byte)((Character)value).charValue()};
        }
        if (value instanceof Short) {
            return ByteBuffer.allocate(2).putInt(((Short)value).shortValue()).array();
        }
        if (value instanceof Integer) {
            return ByteBuffer.allocate(4).putInt((Integer)value).array();
        }
        if (value instanceof String) {
            try {
                return ByteBuffer.wrap(((String)value).getBytes("ASCII")).array();
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        throw new RuntimeException("Unknown data type " + value.getClass().getName());
    }

    public static Object byteArrayToObject(byte[] value, Type type, int[] readBytes) {
        if (type == byte[].class) {
            readBytes[0] = value.length;
            return value;
        }
        if (type == Byte.class) {
            readBytes[0] = 1;
            return value[0];
        }
        if (type == Character.class) {
            readBytes[0] = 1;
            return new Character((char)value[0]);
        }
        ByteBuffer buff = ByteBuffer.wrap(value);
        if (type == Short.class) {
            readBytes[0] = 2;
            buff.getShort();
        }
        if (type == Integer.class) {
            readBytes[0] = 4;
            buff.getInt();
        }
        if (type == Long.class) {
            readBytes[0] = 4;
            buff.getLong();
        }
        if (type == String.class) {
            readBytes[0] = value.length;
            return new String(value);
        }
        throw new RuntimeException("Invalid object type.");
    }

    public GXSynchronousMediaBase(int bufferSize) {
        this.receivedBuffer = new byte[bufferSize];
        this.lastPosition = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendData(byte[] data, int index, int count) {
        Object object = this.sync;
        synchronized (object) {
            if (this.receivedSize + count > this.receivedBuffer.length) {
                byte[] tmp = new byte[2 * this.receivedBuffer.length];
                System.arraycopy(this.receivedBuffer, 0, tmp, 0, this.receivedSize);
                this.receivedBuffer = tmp;
            }
            System.arraycopy(data, index, this.receivedBuffer, this.receivedSize, count);
            this.receivedSize += count - index;
        }
    }

    public static int indexOf(byte[] data, byte[] pattern, int index, int count) {
        int[] failure = GXSynchronousMediaBase.computeFailure(pattern);
        int j = 0;
        if (data.length == 0 || data.length < index) {
            return -1;
        }
        for (int i = index; i < count; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int findData(ReceiveParameters<T> args, boolean[] isFound) {
        int nSize = 0;
        int foundPosition = -1;
        int lastBuffSize = 0;
        Calendar calendar = Calendar.getInstance();
        long startTime = calendar.getTime().getTime();
        byte[] terminator = null;
        int nMinSize = Math.max(args.getCount(), nSize);
        int waitTime = args.getWaitTime();
        this.exception = null;
        if (waitTime <= 0) {
            waitTime = -1;
        }
        isFound[0] = true;
        if (args.getEop() != null) {
            terminator = args.getEop() instanceof Array ? GXSynchronousMediaBase.getAsByteArray(Array.get(args.getEop(), 0)) : GXSynchronousMediaBase.getAsByteArray(args.getEop());
            nSize = terminator.length;
        }
        do {
            boolean isReceived;
            if (waitTime == 0) {
                isFound[0] = false;
                if (args.getAllData()) {
                    foundPosition = this.receivedSize;
                    break;
                }
                foundPosition = -1;
                break;
            }
            if (waitTime != -1 && (waitTime = (int)((long)args.getWaitTime() - (calendar.getTime().getTime() - startTime))) < 0) {
                waitTime = 0;
            }
            Object object = this.sync;
            synchronized (object) {
                isReceived = lastBuffSize != this.receivedSize && this.receivedSize >= nMinSize;
            }
            if (!isReceived) {
                if (waitTime == -1) {
                    isReceived = this.receivedEvent.waitOne();
                } else if (waitTime != 0) {
                    isReceived = this.receivedEvent.waitOne(waitTime);
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (!isReceived) {
                isFound[0] = false;
                if (args.getAllData()) {
                    foundPosition = this.receivedSize;
                    break;
                }
                foundPosition = -1;
                break;
            }
            object = this.sync;
            synchronized (object) {
                lastBuffSize = this.receivedSize;
                if (this.receivedSize < nMinSize) {
                    continue;
                }
                if (nSize == 0) {
                    foundPosition = args.getCount();
                } else {
                    int index = this.lastPosition != 0 && this.lastPosition < this.receivedSize ? this.lastPosition : args.getCount();
                    if (args.getEop() instanceof Array) {
                        for (Object it : (Object[])args.getEop()) {
                            byte[] term = GXSynchronousMediaBase.getAsByteArray(it);
                            if (term.length != 1 && this.receivedSize - index < term.length) {
                                index = this.receivedSize - term.length;
                            }
                            if ((foundPosition = GXSynchronousMediaBase.indexOf(this.receivedBuffer, term, index, this.receivedSize)) == -1) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        if (terminator.length != 1 && this.receivedSize - index < terminator.length) {
                            index = this.receivedSize - terminator.length;
                        }
                        foundPosition = GXSynchronousMediaBase.indexOf(this.receivedBuffer, terminator, index, this.receivedSize);
                    }
                    this.lastPosition = this.receivedSize;
                    if (foundPosition != -1) {
                        foundPosition += terminator.length;
                    }
                }
            }
        } while (foundPosition == -1);
        if (nSize == 0) {
            foundPosition = args.getCount();
        }
        return foundPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> boolean receive(ReceiveParameters<T> args) {
        if (args.getEop() == null && args.getCount() == 0) {
            throw new IllegalArgumentException("Either Count or Eop must be set.");
        }
        boolean[] retValue = new boolean[1];
        int foundPosition = this.findData(args, retValue);
        Object data = null;
        if (foundPosition != -1) {
            Object object = this.sync;
            synchronized (object) {
                if (args.getAllData()) {
                    foundPosition = this.receivedSize;
                }
                if (foundPosition != 0) {
                    byte[] tmp = new byte[foundPosition];
                    System.arraycopy(this.receivedBuffer, 0, tmp, 0, foundPosition);
                    int[] readBytes = new int[1];
                    data = GXSynchronousMediaBase.byteArrayToObject(tmp, args.getReplyType(), readBytes);
                    this.receivedSize -= foundPosition;
                    if (this.receivedSize < 0) {
                        this.receivedSize = 0;
                    }
                    if (this.receivedSize != 0) {
                        System.arraycopy(this.receivedBuffer, foundPosition, this.receivedBuffer, 0, this.receivedSize);
                    }
                }
            }
            args.setCount(0);
            if (args.getReply() == null) {
                args.setReply(data);
            } else if (args.getReply() instanceof String) {
                String str = (String)args.getReply();
                str = str + (String)data;
                data = str;
                args.setReply(data);
            } else if (args.getReply() instanceof byte[]) {
                byte[] oldArray = (byte[])args.getReply();
                byte[] newArray = (byte[])data;
                if (newArray != null) {
                    int oldReplySize = Array.getLength(oldArray);
                    int len = oldReplySize + Array.getLength(newArray);
                    byte[] arr = new byte[len];
                    System.arraycopy((byte[])args.getReply(), 0, arr, 0, Array.getLength(oldArray));
                    System.arraycopy(newArray, 0, arr, Array.getLength(oldArray), Array.getLength(newArray));
                    args.setReply(arr);
                }
            } else {
                throw new RuntimeException("Invalid reply type");
            }
        }
        return retValue[0];
    }
}

