/*
 * Decompiled with CFR 0.152.
 */
package gurux.common;

import gurux.common.GXCommon;
import gurux.common.enums.TraceTypes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraceEventArgs {
    private Date timestamp = new Date(0L);
    private TraceTypes traceType;
    private Object traceData;

    public TraceEventArgs(TraceTypes type, Object data) {
        this.setTimestamp(new Date());
        this.setType(type);
        this.setData(data);
    }

    public TraceEventArgs(TraceTypes type, byte[] data, int index, int length) {
        this.setTimestamp(new Date());
        this.setType(type);
        byte[] tmp = new byte[length];
        System.arraycopy(data, index, tmp, 0, length);
        this.setData(tmp);
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    public final void setTimestamp(Date value) {
        this.timestamp = value;
    }

    public final TraceTypes getType() {
        return this.traceType;
    }

    public final void setType(TraceTypes value) {
        this.traceType = value;
    }

    public final Object getData() {
        return this.traceData;
    }

    public final void setData(Object value) {
        this.traceData = value;
    }

    public final String dataToString(boolean ascii) {
        if (this.getData() == null) {
            return "";
        }
        if (this.getData() instanceof byte[]) {
            byte[] bytes = (byte[])this.getData();
            if (ascii) {
                try {
                    return new String(bytes, "ASCII");
                }
                catch (Exception ex) {
                    Logger.getLogger(TraceEventArgs.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return GXCommon.bytesToHex(bytes);
        }
        return String.valueOf(this.getData());
    }

    public final String toString() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(this.getTimestamp()) + "\t" + this.getType().toString() + "\t" + this.dataToString(false);
    }
}

