/*
 * Decompiled with CFR 0.152.
 */
package gurux.io;

import java.util.HashMap;

public enum BaudRate {
    BAUD_RATE_115200(115200),
    BAUD_RATE_57600(57600),
    BAUD_RATE_38400(38400),
    BAUD_RATE_19200(19200),
    BAUD_RATE_9600(9600),
    BAUD_RATE_4800(4800),
    BAUD_RATE_2400(2400),
    BAUD_RATE_1800(1800),
    BAUD_RATE_600(600),
    BAUD_RATE_300(300);

    private int intValue;
    private static HashMap<Integer, BaudRate> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, BaudRate> getMappings() {
        if (mappings != null) return mappings;
        Class<BaudRate> clazz = BaudRate.class;
        synchronized (BaudRate.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private BaudRate(int value) {
        this.intValue = value;
        BaudRate.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static BaudRate forValue(int value) {
        BaudRate ret = BaudRate.getMappings().get(value);
        if (ret == null) {
            throw new IllegalArgumentException("Invalid Baudrate enum value.");
        }
        return ret;
    }
}

