/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXCoAPSettings;
import gurux.dlms.GXCryptoKeyParameter;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSClient;
import gurux.dlms.GXDLMSGateway;
import gurux.dlms.GXDLMSLimits;
import gurux.dlms.GXHdlcSettings;
import gurux.dlms.GXICipher;
import gurux.dlms.GXMBusSettings;
import gurux.dlms.GXPlcSettings;
import gurux.dlms.HdlcFrameType;
import gurux.dlms.IGXCryptoNotifier;
import gurux.dlms.asn.GXPkcs8;
import gurux.dlms.asn.GXx509Certificate;
import gurux.dlms.asn.enums.KeyUsage;
import gurux.dlms.enums.Authentication;
import gurux.dlms.enums.Conformance;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.ObjectType;
import gurux.dlms.enums.Priority;
import gurux.dlms.enums.Security;
import gurux.dlms.enums.ServiceClass;
import gurux.dlms.enums.Signing;
import gurux.dlms.enums.Standard;
import gurux.dlms.objects.GXDLMSAssociationLogicalName;
import gurux.dlms.objects.GXDLMSData;
import gurux.dlms.objects.GXDLMSHdlcSetup;
import gurux.dlms.objects.GXDLMSObjectCollection;
import gurux.dlms.objects.GXDLMSSecuritySetup;
import gurux.dlms.objects.GXDLMSTcpUdpSetup;
import gurux.dlms.objects.enums.ApplicationContextName;
import gurux.dlms.objects.enums.AssociationStatus;
import gurux.dlms.objects.enums.CertificateType;
import gurux.dlms.objects.enums.SecuritySuite;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GXDLMSSettings {
    private int version = 4;
    private GXDLMSHdlcSetup hdlc;
    private GXDLMSTcpUdpSetup wrapper;
    private boolean skipFrameCheck = false;
    static final short SERVER_START_SENDER_FRAME_SEQUENCE = 30;
    static final short SERVER_START_RECEIVER_FRAME_SEQUENCE = 254;
    static final short CLIENT_START_SENDER_FRAME_SEQUENCE = 254;
    static final short CLIENT_START_RCEIVER_FRAME_SEQUENCE = 14;
    static final byte DLMS_VERSION = 6;
    static final int MAX_RECEIVE_PDU_SIZE = 65535;
    private boolean customChallenges = false;
    private byte[] ctoSChallenge;
    private byte[] stoCChallenge;
    private byte[] sourceSystemTitle;
    private byte[] preEstablishedSystemTitle;
    private byte invokeID = 1;
    private long longInvokeID = 1L;
    private Priority priority = Priority.HIGH;
    private ServiceClass serviceClass = ServiceClass.CONFIRMED;
    GXDLMSAssociationLogicalName assignedAssociation;
    private int clientAddress;
    private int serverAddress;
    private int pushClientAddress;
    private int serverAddressSize = 0;
    private boolean useLogicalNameReferencing;
    private InterfaceType interfaceType = InterfaceType.HDLC;
    private Authentication authentication = Authentication.NONE;
    private byte[] password;
    private byte[] kek;
    private long count;
    private long index;
    private PublicKey targetEphemeralKey;
    private int dlmsVersionNumber = 6;
    private byte connected = 0;
    private int maxPduSize = 65535;
    private int maxServerPDUSize = 65535;
    private Set<Conformance> proposedConformance = new HashSet<Conformance>();
    private Set<Conformance> negotiatedConformance = new HashSet<Conformance>();
    short senderFrame;
    short receiverFrame;
    private boolean server;
    private GXHdlcSettings hdlcSettings;
    private GXDLMSGateway gateway;
    private GXPlcSettings plc;
    private GXMBusSettings mBus;
    private GXCoAPSettings coap;
    private int startingPacketIndex = 1;
    private int blockIndex = 1;
    private final GXDLMSObjectCollection objects;
    private GXICipher cipher;
    private final IGXCryptoNotifier cryptoNotifier;
    private int blockNumberAck;
    private byte gbtWindowSize;
    private int userId;
    private byte qualityOfService;
    private boolean useUtc2NormalTime;
    private boolean increaseInvocationCounterForGMacAuthentication;
    private Set<DateTimeSkips> dateTimeSkips = new HashSet<DateTimeSkips>();
    private Set<DateTimeSkips> readDateTimeSkips = new HashSet<DateTimeSkips>();
    private Standard standard;
    private int command;
    private byte commandType;
    private String protocolVersion = null;
    private boolean autoIncreaseInvokeID = false;
    GXDLMSData invocationCounter;
    private byte[] ephemeralBlockCipherKey;
    private byte[] ephemeralBroadcastBlockCipherKey;
    private byte[] ephemeralAuthenticationKey;
    private List<Map.Entry<GXPkcs8, GXx509Certificate>> keys;
    private byte challengeSize = (byte)16;
    boolean overwriteAttributeAccessRights;
    private int gbtCount;

    public final byte[] getEphemeralBlockCipherKey() {
        return this.ephemeralBlockCipherKey;
    }

    public final void setEphemeralBlockCipherKey(byte[] value) {
        this.ephemeralBlockCipherKey = value;
    }

    public final byte[] getEphemeralBroadcastBlockCipherKey() {
        return this.ephemeralBroadcastBlockCipherKey;
    }

    public final void setEphemeralBroadcastBlockCipherKey(byte[] value) {
        this.ephemeralBroadcastBlockCipherKey = value;
    }

    public final byte[] getEphemeralAuthenticationKey() {
        return this.ephemeralAuthenticationKey;
    }

    public final void setEphemeralAuthenticationKey(byte[] value) {
        this.ephemeralAuthenticationKey = value;
    }

    GXDLMSSettings(boolean isServer, IGXCryptoNotifier notifier) {
        this.server = isServer;
        this.cryptoNotifier = notifier;
        this.objects = new GXDLMSObjectCollection();
        this.hdlcSettings = new GXDLMSLimits(this);
        this.plc = new GXPlcSettings(this);
        this.mBus = new GXMBusSettings();
        this.coap = new GXCoAPSettings();
        this.gateway = null;
        this.proposedConformance.addAll(GXDLMSClient.getInitialConformance(false));
        if (isServer) {
            this.proposedConformance.add(Conformance.GENERAL_PROTECTION);
        }
        this.resetFrameSequence();
        this.gbtWindowSize = 1;
        this.userId = -1;
        this.standard = Standard.DLMS;
        this.keys = new ArrayList<Map.Entry<GXPkcs8, GXx509Certificate>>();
    }

    final void setCipher(GXICipher value) {
        this.cipher = value;
    }

    public final GXICipher getCipher() {
        return this.cipher;
    }

    public final byte[] getCtoSChallenge() {
        return this.ctoSChallenge;
    }

    public final void setCtoSChallenge(byte[] value) {
        if (!this.customChallenges || this.ctoSChallenge == null) {
            this.ctoSChallenge = value;
        }
    }

    public final byte[] getStoCChallenge() {
        return this.stoCChallenge;
    }

    public final void setStoCChallenge(byte[] value) {
        if (!this.customChallenges || this.stoCChallenge == null) {
            this.stoCChallenge = value;
        }
    }

    public final Authentication getAuthentication() {
        return this.authentication;
    }

    public final void setAuthentication(Authentication value) {
        this.authentication = value;
    }

    public final byte[] getPassword() {
        return this.password;
    }

    public final void setPassword(byte[] value) {
        this.password = value;
    }

    public final int getDlmsVersionNumber() {
        return this.dlmsVersionNumber;
    }

    public final void setDlmsVersionNumber(int value) {
        this.dlmsVersionNumber = value;
    }

    public final byte getConnected() {
        return this.connected;
    }

    public final void setConnected(int value) {
        this.connected = (byte)value;
    }

    public final void resetFrameSequence() {
        if (this.server) {
            this.senderFrame = (short)30;
            this.receiverFrame = (short)254;
        } else {
            this.senderFrame = (short)254;
            this.receiverFrame = (short)14;
        }
    }

    final boolean checkFrame(short frame) {
        short expected;
        if (frame == 19) {
            return true;
        }
        if ((frame & HdlcFrameType.U_FRAME.getValue()) == HdlcFrameType.U_FRAME.getValue() && (frame == 115 || frame == 147)) {
            this.resetFrameSequence();
            return true;
        }
        if ((frame & HdlcFrameType.S_FRAME.getValue()) == HdlcFrameType.S_FRAME.getValue()) {
            this.receiverFrame = GXDLMSSettings.increaseReceiverSequence(this.receiverFrame);
            return true;
        }
        if ((this.senderFrame & 1) == 0) {
            expected = (short)(GXDLMSSettings.increaseReceiverSequence(GXDLMSSettings.increaseSendSequence(this.receiverFrame)) & 0xFF);
            if (frame == expected) {
                this.receiverFrame = frame;
                return true;
            }
        } else {
            expected = (short)(GXDLMSSettings.increaseSendSequence(this.receiverFrame) & 0xFF);
            if (frame == expected) {
                this.receiverFrame = frame;
                return true;
            }
        }
        if (this.skipFrameCheck) {
            this.receiverFrame = frame;
            return true;
        }
        Logger.getLogger(GXDLMS.class.getName()).log(Level.INFO, "Invalid HDLC Frame: " + Long.toString(frame, 16) + " Expected: " + Long.toString(expected, 16));
        return false;
    }

    static byte increaseReceiverSequence(short value) {
        return (byte)((value & 0xFF) + 32 | 0x10 | value & 0xE);
    }

    static short increaseSendSequence(short value) {
        return (short)((value & 0xF0 | value + 2 & 0xE) & 0xFF);
    }

    final byte getNextSend(boolean first) {
        this.senderFrame = first ? (short)GXDLMSSettings.increaseReceiverSequence(GXDLMSSettings.increaseSendSequence((byte)this.senderFrame)) : GXDLMSSettings.increaseSendSequence((byte)this.senderFrame);
        return (byte)this.senderFrame;
    }

    final byte getReceiverReady() {
        this.senderFrame = GXDLMSSettings.increaseReceiverSequence((byte)(this.senderFrame | 1));
        return (byte)(this.senderFrame & 0xF1);
    }

    final byte getKeepAlive() {
        this.senderFrame = (byte)(this.senderFrame | 1);
        return (byte)(this.senderFrame & 0xF1);
    }

    final int getBlockIndex() {
        return this.blockIndex;
    }

    final int getStartingPacketIndex() {
        return this.startingPacketIndex;
    }

    public final void setStartingPacketIndex(int value) {
        this.startingPacketIndex = value;
        this.resetBlockIndex();
    }

    final void setBlockIndex(int value) {
        this.blockIndex = value;
    }

    public final int getBlockNumberAck() {
        return this.blockNumberAck;
    }

    public final void setBlockNumberAck(int value) {
        this.blockNumberAck = value;
    }

    final void resetBlockIndex() {
        this.blockIndex = this.startingPacketIndex;
        this.blockNumberAck = 0;
    }

    final void increaseBlockIndex() {
        ++this.blockIndex;
    }

    public final boolean isServer() {
        return this.server;
    }

    public final void setServer(boolean value) {
        this.server = value;
    }

    public final GXHdlcSettings getHdlcSettings() {
        return this.hdlcSettings;
    }

    public final GXDLMSGateway getGateway() {
        return this.gateway;
    }

    public final void setGateway(GXDLMSGateway value) {
        this.gateway = value;
    }

    public final GXPlcSettings getPlc() {
        return this.plc;
    }

    public final void setPlc(GXPlcSettings value) {
        this.plc = value;
    }

    public final void setLimits(GXHdlcSettings value) {
        this.hdlcSettings = value;
    }

    public final InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public final void setInterfaceType(InterfaceType value) {
        this.interfaceType = value;
    }

    public final int getClientAddress() {
        return this.clientAddress;
    }

    public final void setGbtCount(int value) {
        this.gbtCount = value;
    }

    public final int getGbtCount() {
        return this.gbtCount;
    }

    public final void setClientAddress(int value) {
        this.clientAddress = value;
    }

    public final int getServerAddressSize() {
        return this.serverAddressSize;
    }

    public final void setServerAddressSize(int value) {
        this.serverAddressSize = value;
    }

    public final int getServerAddress() {
        return this.serverAddress;
    }

    public final void setServerAddress(int value) {
        this.serverAddress = value;
    }

    public final int getDLMSVersion() {
        return this.dlmsVersionNumber;
    }

    public final void setDLMSVersion(int value) {
        this.dlmsVersionNumber = value;
    }

    public final int getMaxPduSize() {
        return this.maxPduSize;
    }

    public final void setMaxPduSize(int value) {
        this.maxPduSize = value;
    }

    public final int getMaxServerPDUSize() {
        return this.maxServerPDUSize;
    }

    public final void setMaxServerPDUSize(int value) {
        this.maxServerPDUSize = value;
    }

    public final boolean getUseLogicalNameReferencing() {
        return this.useLogicalNameReferencing;
    }

    public final void setUseLogicalNameReferencing(boolean value) {
        if (this.useLogicalNameReferencing != value) {
            this.useLogicalNameReferencing = value;
            this.proposedConformance.clear();
            this.proposedConformance.addAll(GXDLMSClient.getInitialConformance(this.getUseLogicalNameReferencing()));
            if (this.isServer()) {
                this.proposedConformance.add(Conformance.GENERAL_PROTECTION);
            }
        }
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public final void setPriority(Priority value) {
        this.priority = value;
    }

    public final ServiceClass getServiceClass() {
        return this.serviceClass;
    }

    public final void setServiceClass(ServiceClass value) {
        this.serviceClass = value;
    }

    private void updateSecurity(byte[] systemTitle, GXDLMSSecuritySetup ss) {
        if (ss != null) {
            this.getCipher().setSecuritySuite(ss.getSecuritySuite());
            this.getCipher().setSecurityPolicy(ss.getSecurityPolicy());
            this.getCipher().setBlockCipherKey(ss.getGuek());
            this.getCipher().setBroadcastBlockCipherKey(ss.getGbek());
            this.getCipher().setAuthenticationKey(ss.getGak());
            this.setEphemeralBlockCipherKey(ss.getGuek());
            this.setEphemeralBroadcastBlockCipherKey(ss.getGbek());
            this.setEphemeralAuthenticationKey(ss.getGak());
            this.setKek(ss.getKek());
            byte[] st = systemTitle == null ? ss.getClientSystemTitle() : systemTitle;
            if (st != null) {
                GXx509Certificate cert = ss.serverCertificates.findBySystemTitle(st, KeyUsage.DIGITAL_SIGNATURE);
                if (cert != null) {
                    this.getCipher().setSigningKeyPair(new KeyPair(cert.getPublicKey(), ss.signingKey.getPrivate()));
                }
                if ((cert = ss.serverCertificates.findBySystemTitle(st, KeyUsage.KEY_AGREEMENT)) != null) {
                    this.getCipher().setKeyAgreementKeyPair(new KeyPair(cert.getPublicKey(), ss.keyAgreement.getPrivate()));
                }
                this.setSourceSystemTitle(st);
            }
            this.getCipher().setSystemTitle(ss.getServerSystemTitle());
            String ln = "0.0.43.1." + ss.getLogicalName().split("[.]")[4] + ".255";
            this.invocationCounter = (GXDLMSData)this.getObjects().findByLN(ObjectType.DATA, ln);
            if (this.invocationCounter != null && this.invocationCounter.getValue() == null) {
                if (this.invocationCounter.getDataType(2) == DataType.NONE) {
                    this.invocationCounter.setDataType(2, DataType.UINT32);
                }
                this.invocationCounter.setValue(0);
            }
        } else {
            this.assignedAssociation.getApplicationContextName().setContextId(ApplicationContextName.LOGICAL_NAME);
        }
    }

    void updateSecuritySettings(byte[] systemTitle) {
        if (this.assignedAssociation != null) {
            if (this.assignedAssociation.getSecuritySetupReference() != null && (this.assignedAssociation.getApplicationContextName().getContextId() == ApplicationContextName.LOGICAL_NAME_WITH_CIPHERING || this.assignedAssociation.getAuthenticationMechanismName().getMechanismId() == Authentication.HIGH_GMAC || this.assignedAssociation.getAuthenticationMechanismName().getMechanismId() == Authentication.HIGH_ECDSA)) {
                GXDLMSSecuritySetup ss = (GXDLMSSecuritySetup)this.assignedAssociation.getObjectList().findByLN(ObjectType.SECURITY_SETUP, this.assignedAssociation.getSecuritySetupReference());
                this.updateSecurity(systemTitle, ss);
            } else {
                GXDLMSSecuritySetup ss = (GXDLMSSecuritySetup)this.assignedAssociation.getObjectList().findByLN(ObjectType.SECURITY_SETUP, this.assignedAssociation.getSecuritySetupReference());
                this.updateSecurity(systemTitle, ss);
            }
        }
    }

    public final void setAssignedAssociation(GXDLMSAssociationLogicalName value) {
        if (this.assignedAssociation != null) {
            this.assignedAssociation.setAssociationStatus(AssociationStatus.NON_ASSOCIATED);
            this.assignedAssociation.getXDLMSContextInfo().setCypheringInfo(null);
            this.invocationCounter = null;
            this.getCipher().getSecurityPolicy().clear();
            this.setEphemeralBlockCipherKey(null);
            this.setEphemeralBroadcastBlockCipherKey(null);
            this.setEphemeralAuthenticationKey(null);
            this.getCipher().setSecuritySuite(SecuritySuite.SUITE_0);
        }
        this.assignedAssociation = value;
        if (this.assignedAssociation != null) {
            this.proposedConformance = this.assignedAssociation.getXDLMSContextInfo().getConformance();
            this.maxServerPDUSize = this.assignedAssociation.getXDLMSContextInfo().getMaxReceivePduSize();
            this.authentication = this.assignedAssociation.getAuthenticationMechanismName().getMechanismId();
            this.updateSecuritySettings(null);
        }
    }

    public final GXDLMSAssociationLogicalName getAssignedAssociation() {
        return this.assignedAssociation;
    }

    public final int getInvokeID() {
        return this.invokeID;
    }

    final void updateInvokeId(short value) {
        if ((value & 0x80) != 0) {
            this.setPriority(Priority.HIGH);
        } else {
            this.setPriority(Priority.NORMAL);
        }
        if ((value & 0x40) != 0) {
            this.setServiceClass(ServiceClass.CONFIRMED);
        } else {
            this.setServiceClass(ServiceClass.UN_CONFIRMED);
        }
        this.invokeID = (byte)(value & 0xF);
    }

    public final void setInvokeID(int value) {
        if (value > 15) {
            throw new IllegalArgumentException("Invalid InvokeID");
        }
        this.invokeID = (byte)value;
    }

    public final long getLongInvokeID() {
        return this.longInvokeID;
    }

    public final void setLongInvokeID(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Invalid InvokeID");
        }
        this.longInvokeID = value;
    }

    public final GXDLMSObjectCollection getObjects() {
        return this.objects;
    }

    public final boolean isCustomChallenges() {
        return this.customChallenges;
    }

    public final void setUseCustomChallenge(boolean value) {
        this.customChallenges = value;
    }

    public boolean isCiphered(boolean checkGeneralSigning) {
        if (this.cipher == null) {
            return false;
        }
        return this.cipher.getSecurity() != Security.NONE || checkGeneralSigning && this.cipher.getSigning() == Signing.GENERAL_SIGNING;
    }

    public final byte[] getSourceSystemTitle() {
        return this.sourceSystemTitle;
    }

    public final void setSourceSystemTitle(byte[] value) {
        if (value != null && value.length != 0 && value.length != 8) {
            throw new IllegalArgumentException("Invalid client system title.");
        }
        this.sourceSystemTitle = value;
    }

    public final byte[] getKek() {
        return this.kek;
    }

    public final void setKek(byte[] value) {
        this.kek = value;
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Invalid count.");
        }
        this.count = value;
    }

    public final long getIndex() {
        return this.index;
    }

    public final void setIndex(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Invalid Index.");
        }
        this.index = value;
    }

    public PublicKey getTargetEphemeralKey() {
        return this.targetEphemeralKey;
    }

    public void setTargetEphemeralKey(PublicKey value) {
        this.targetEphemeralKey = value;
    }

    public Set<Conformance> getProposedConformance() {
        return this.proposedConformance;
    }

    public void setProposedConformance(Set<Conformance> value) {
        this.proposedConformance = value;
    }

    public Set<Conformance> getNegotiatedConformance() {
        return this.negotiatedConformance;
    }

    public void setNegotiatedConformance(Set<Conformance> value) {
        this.negotiatedConformance = value;
    }

    final void setSkipFrameCheck(boolean value) {
        this.skipFrameCheck = value;
    }

    public GXDLMSHdlcSetup getHdlc() {
        return this.hdlc;
    }

    public void setHdlc(GXDLMSHdlcSetup value) {
        this.hdlc = value;
    }

    public GXDLMSTcpUdpSetup getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(GXDLMSTcpUdpSetup value) {
        this.wrapper = value;
    }

    public final byte getGbtWindowSize() {
        return this.gbtWindowSize;
    }

    public final void setGbtWindowSize(byte value) {
        this.gbtWindowSize = value;
    }

    public final int getUserId() {
        return this.userId;
    }

    public final void setUserId(int value) {
        this.userId = value;
    }

    public boolean getUseUtc2NormalTime() {
        return this.useUtc2NormalTime;
    }

    public void setUseUtc2NormalTime(boolean value) {
        this.useUtc2NormalTime = value;
    }

    public boolean getIncreaseInvocationCounterForGMacAuthentication() {
        return this.increaseInvocationCounterForGMacAuthentication;
    }

    public void setIncreaseInvocationCounterForGMacAuthentication(boolean value) {
        this.increaseInvocationCounterForGMacAuthentication = value;
    }

    public Set<DateTimeSkips> getDateTimeSkips() {
        return this.dateTimeSkips;
    }

    public void setDateTimeSkips(Set<DateTimeSkips> value) {
        this.dateTimeSkips = value;
    }

    public Set<DateTimeSkips> getDateTimeSkipsOnRead() {
        return this.readDateTimeSkips;
    }

    public void setDateTimeSkipsOnRead(Set<DateTimeSkips> value) {
        this.readDateTimeSkips = value;
    }

    public Standard getStandard() {
        return this.standard;
    }

    public void setStandard(Standard value) {
        this.standard = value;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String value) {
        this.protocolVersion = value;
    }

    public byte[] getPreEstablishedSystemTitle() {
        return this.preEstablishedSystemTitle;
    }

    public void setPreEstablishedSystemTitle(byte[] value) {
        if (value != null && value.length != 8) {
            throw new IllegalArgumentException("Invalid system title.");
        }
        this.preEstablishedSystemTitle = value;
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int value) {
        this.command = value;
    }

    public byte getCommandType() {
        return this.commandType;
    }

    public void setCommandType(byte value) {
        this.commandType = value;
    }

    public byte getQualityOfService() {
        return this.qualityOfService;
    }

    public void setQualityOfService(byte value) {
        this.qualityOfService = value;
    }

    public final boolean getAutoIncreaseInvokeID() {
        return this.autoIncreaseInvokeID;
    }

    public final void setAutoIncreaseInvokeID(boolean value) {
        this.autoIncreaseInvokeID = value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int value) {
        if (value != 3 && value != 4) {
            throw new IllegalArgumentException("Invalid version.");
        }
        this.version = value;
    }

    public int getPushClientAddress() {
        return this.pushClientAddress;
    }

    public void setPushClientAddress(int value) {
        this.pushClientAddress = value;
    }

    public List<Map.Entry<GXPkcs8, GXx509Certificate>> getKeys() {
        return this.keys;
    }

    public void setKeys(List<Map.Entry<GXPkcs8, GXx509Certificate>> value) {
        this.keys = value;
    }

    public GXDLMSData getInvocationCounter() {
        return this.invocationCounter;
    }

    public IGXCryptoNotifier getCryptoNotifier() {
        return this.cryptoNotifier;
    }

    public Object getKey(CertificateType certificateType, byte[] systemTitle, boolean encrypt) {
        if (this.cryptoNotifier == null) {
            throw new RuntimeException("Failed to get the certificate.");
        }
        if (certificateType == CertificateType.DIGITAL_SIGNATURE && this.cipher.getSigningKeyPair() != null) {
            if (encrypt) {
                if (this.cipher.getSigningKeyPair().getPrivate() != null) {
                    return this.cipher.getSigningKeyPair().getPrivate();
                }
            } else if (this.cipher.getSigningKeyPair().getPublic() != null) {
                return this.cipher.getSigningKeyPair().getPublic();
            }
        } else if (certificateType == CertificateType.KEY_AGREEMENT && this.cipher.getKeyAgreementKeyPair() != null) {
            if (encrypt) {
                if (this.cipher.getKeyAgreementKeyPair().getPrivate() != null) {
                    return this.cipher.getKeyAgreementKeyPair().getPrivate();
                }
            } else if (this.cipher.getKeyAgreementKeyPair().getPublic() != null) {
                return this.cipher.getKeyAgreementKeyPair().getPublic();
            }
        }
        GXCryptoKeyParameter args = new GXCryptoKeyParameter();
        args.setEncrypt(encrypt);
        args.setSecuritySuite(this.cipher.getSecuritySuite());
        args.setCertificateType(certificateType);
        args.setSystemTitle(systemTitle);
        this.cryptoNotifier.onKey(this.cryptoNotifier, args);
        if (encrypt) {
            return args.getPrivateKey();
        }
        return args.getPublicKey();
    }

    public byte getChallengeSize() {
        return this.challengeSize;
    }

    public void setChallengeSize(byte value) {
        if (this.authentication == Authentication.HIGH_ECDSA && value < 32) {
            throw new IllegalArgumentException("Invalid challenge size. ECDSA challenge must be between 32 to 64 bytes.");
        }
        if (value < 8 || value > 64) {
            throw new IllegalArgumentException("Invalid challenge size. Challenge must be between 8 to 64 bytes.");
        }
        this.challengeSize = value;
    }

    public final boolean getOverwriteAttributeAccessRights() {
        return this.overwriteAttributeAccessRights;
    }

    public final void setOverwriteAttributeAccessRights(boolean value) {
        this.overwriteAttributeAccessRights = value;
    }

    public GXMBusSettings getMbus() {
        return this.mBus;
    }

    public GXCoAPSettings getCoap() {
        return this.coap;
    }
}

