/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSLNParameters;
import gurux.dlms.GXDLMSTranslator;
import gurux.dlms.GXDLMSXmlPdu;
import gurux.dlms.GXDLMSXmlSettings;
import gurux.dlms.GXXmlLoadSettings;
import gurux.dlms.TranslatorOutputType;
import gurux.dlms.enums.DataType;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.enums.Security;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.secure.GXDLMSSecureClient;
import java.io.File;
import java.io.StringReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GXDLMSXmlClient
extends GXDLMSSecureClient {
    private boolean throwExceptions;

    public GXDLMSXmlClient(TranslatorOutputType type) {
        this.translator = new GXDLMSTranslator(type);
        this.translator.setHex(false);
        this.setUseLogicalNameReferencing(true);
    }

    public final boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    @Override
    public final void setThrowExceptions(boolean value) {
        this.throwExceptions = value;
    }

    public static void removeRecursively(Node node, short nodeType, String name) {
        if (node.getNodeType() == nodeType && (name == null || node.getNodeName().equals(name))) {
            node.getParentNode().removeChild(node);
        } else {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                GXDLMSXmlClient.removeRecursively(list.item(i), nodeType, name);
            }
        }
    }

    public List<GXDLMSXmlPdu> load(File file) {
        return this.load(file, null);
    }

    public List<GXDLMSXmlPdu> load(File file, GXXmlLoadSettings s) {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.load(doc, s);
    }

    public List<GXDLMSXmlPdu> load(String xml, GXXmlLoadSettings s) {
        Document doc;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.load(doc, s);
    }

    private List<GXDLMSXmlPdu> load(Document doc, GXXmlLoadSettings loadSettings) {
        GXDLMSXmlClient.removeRecursively(doc, (short)8, null);
        ArrayList<GXDLMSXmlPdu> actions = new ArrayList<GXDLMSXmlPdu>();
        String description = null;
        String error = null;
        String errorUrl = null;
        String sleep = null;
        for (int pos = 0; pos != doc.getChildNodes().getLength(); ++pos) {
            Node m1 = doc.getChildNodes().item(pos);
            if (m1.getNodeType() != 1) continue;
            for (int pos2 = 0; pos2 != m1.getChildNodes().getLength(); ++pos2) {
                byte[] reply;
                Node node = m1.getChildNodes().item(pos2);
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equals("Description")) {
                    description = node.getNodeValue();
                    continue;
                }
                if (node.getNodeName().equals("Error")) {
                    error = node.getNodeValue();
                    continue;
                }
                if (node.getNodeName().equals("ErrorUrl")) {
                    errorUrl = node.getNodeValue();
                    continue;
                }
                if (node.getNodeName().equals("Sleep")) {
                    sleep = node.getNodeValue();
                    continue;
                }
                if (loadSettings != null && node.getNodeName().equals("GetRequest") && loadSettings.getStart() != new Date(0L) && loadSettings.getEnd() != new Date(0L)) {
                    block4: for (int pos3 = 0; pos3 != node.getChildNodes().getLength(); ++pos3) {
                        Node n1 = node.getChildNodes().item(pos3);
                        if (!n1.getNodeName().equals("GetRequestNormal")) continue;
                        for (int pos4 = 0; pos4 != n1.getChildNodes().getLength(); ++pos4) {
                            Node n2 = n1.getChildNodes().item(pos4);
                            if (!n2.getNodeName().equals("AccessSelection")) continue;
                            for (int pos5 = 0; pos5 != n2.getChildNodes().getLength(); ++pos5) {
                                Node n4;
                                Node n3 = n2.getChildNodes().item(pos5);
                                if (n3.getNodeName().equals("AccessSelector")) {
                                    if (n3.getAttributes().getNamedItem("Value").getNodeValue().equals("1")) continue;
                                    break block4;
                                }
                                if (!n3.getNodeName().equals("AccessParameters")) continue;
                                int pos6 = 0;
                                if (pos6 == n3.getChildNodes().getLength() || !(n4 = n3.getChildNodes().item(pos6)).getNodeName().equals("Structure")) break block4;
                                boolean start = true;
                                for (int pos7 = 0; pos7 != n4.getChildNodes().getLength(); ++pos7) {
                                    Node n5 = n4.getChildNodes().item(pos7);
                                    if (!n5.getNodeName().equals("OctetString")) continue;
                                    GXByteBuffer bb = new GXByteBuffer();
                                    if (start) {
                                        GXCommon.setData(this.settings, bb, DataType.OCTET_STRING, loadSettings.getStart());
                                        n5.getAttributes().getNamedItem("Value").setNodeValue(bb.toHex(false, 2));
                                        start = false;
                                        continue;
                                    }
                                    GXCommon.setData(this.settings, bb, DataType.OCTET_STRING, loadSettings.getEnd());
                                    n5.getAttributes().getNamedItem("Value").setNodeValue(bb.toHex(false, 2));
                                    break block4;
                                }
                                break block4;
                            }
                            break block4;
                        }
                        break;
                    }
                }
                GXDLMSXmlSettings s = new GXDLMSXmlSettings(this.translator.getOutputType(), this.translator.isHex(), this.translator.getShowStringAsHex(), this.translator.tagsByName);
                s.getSettings().setClientAddress(this.settings.getClientAddress());
                s.getSettings().setServerAddress(this.settings.getServerAddress());
                try {
                    reply = this.translator.xmlToPdu(GXDLMSXmlPdu.getOuterXml(node), s);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex.getMessage());
                }
                if (s.getCommand() == 147 && !s.getSettings().isServer() || s.getCommand() == 115 && s.getSettings().isServer()) {
                    this.settings.getHdlcSettings().setMaxInfoTX(s.getSettings().getHdlcSettings().getMaxInfoTX());
                    this.settings.getHdlcSettings().setMaxInfoRX(s.getSettings().getHdlcSettings().getMaxInfoRX());
                    this.settings.getHdlcSettings().setWindowSizeRX(s.getSettings().getHdlcSettings().getWindowSizeRX());
                    this.settings.getHdlcSettings().setWindowSizeTX(s.getSettings().getHdlcSettings().getWindowSizeTX());
                }
                if (s.isTemplate()) {
                    reply = null;
                }
                GXDLMSXmlPdu p = new GXDLMSXmlPdu(s.getCommand(), node, reply);
                if (description != null && !description.equals("")) {
                    p.setDescription(description);
                }
                if (error != null && !error.equals("")) {
                    p.setError(error);
                }
                if (errorUrl != null && !errorUrl.equals("")) {
                    p.setErrorUrl(errorUrl);
                }
                if (sleep != null && !sleep.equals("")) {
                    p.setSleep(Integer.parseInt(sleep));
                }
                actions.add(p);
            }
        }
        return actions;
    }

    public final byte[][] pduToMessages(GXDLMSXmlPdu pdu) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        if (pdu.getCommand() == 147) {
            messages.add(pdu.getData());
        } else if (pdu.getCommand() == 115) {
            messages.add(pdu.getData());
        } else if (pdu.getCommand() == 83) {
            messages.add(GXDLMS.getHdlcFrame(this.settings, 83, new GXByteBuffer(pdu.getData())));
        } else {
            GXByteBuffer reply;
            GXDLMSLNParameters p;
            if (this.settings.getInterfaceType() == InterfaceType.WRAPPER) {
                if (this.getCiphering().getSecurity() != Security.NONE) {
                    p = new GXDLMSLNParameters(this.settings, 0L, pdu.getCommand(), 0, null, null, 255, 0);
                    reply = new GXByteBuffer(GXDLMS.cipher0(p, pdu.getData()));
                } else {
                    reply = new GXByteBuffer(pdu.getData());
                }
            } else if (this.getCiphering().getSecurity() != Security.NONE) {
                p = new GXDLMSLNParameters(this.settings, 0L, pdu.getCommand(), 0, null, null, 255, 0);
                byte[] tmp = GXDLMS.cipher0(p, pdu.getData());
                reply = new GXByteBuffer((short)(3 + tmp.length));
                reply.set(GXCommon.LLC_SEND_BYTES);
                reply.set(tmp);
            } else {
                reply = new GXByteBuffer((short)(3 + pdu.getData().length));
                reply.set(GXCommon.LLC_SEND_BYTES);
                reply.set(pdu.getData());
            }
            int frame = 0;
            while (reply.position() != reply.size()) {
                if (this.settings.getInterfaceType() == InterfaceType.WRAPPER) {
                    messages.add(GXDLMS.getWrapperFrame(this.settings, pdu.getCommand(), reply));
                    continue;
                }
                if (GXDLMS.useHdlc(this.settings.getInterfaceType())) {
                    if (pdu.getCommand() == 96) {
                        frame = 16;
                    } else if (pdu.getCommand() == 97) {
                        frame = 48;
                    } else if (pdu.getCommand() == 194) {
                        frame = 19;
                    }
                    messages.add(GXDLMS.getHdlcFrame(this.settings, frame, reply));
                    if (reply.position() == reply.size()) continue;
                    frame = this.settings.getNextSend(false);
                    continue;
                }
                if (this.settings.getInterfaceType() == InterfaceType.PDU) {
                    messages.add(reply.array());
                    break;
                }
                throw new IllegalArgumentException("InterfaceType");
            }
        }
        return (byte[][])messages.toArray((T[])new byte[0][0]);
    }
}

