/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class GXDLMSXmlPdu {
    private Node xmlNode;
    private int command;
    private String description;
    private String error;
    private String errorUrl;
    private byte[] data;
    private int privateSleep;

    public final Node getXmlNode() {
        return this.xmlNode;
    }

    public final int getCommand() {
        return this.command;
    }

    public final void setCommand(int value) {
        this.command = value;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final void setData(byte[] value) {
        this.data = value;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String value) {
        this.description = value;
    }

    public final String getError() {
        return this.error;
    }

    public final void setError(String value) {
        this.error = value;
    }

    public final String getErrorUrl() {
        return this.errorUrl;
    }

    public final void setErrorUrl(String value) {
        this.errorUrl = value;
    }

    public final int getSleep() {
        return this.privateSleep;
    }

    public final void setSleep(int value) {
        this.privateSleep = value;
    }

    static String getOuterXml(Node node) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    public final String getPduAsXml() {
        if (this.getXmlNode() == null) {
            return "";
        }
        try {
            return GXDLMSXmlPdu.getOuterXml(this.xmlNode);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private static void compare(Node expectedNode, Node actualNode, ArrayList<String> list) {
        int cnt = expectedNode.getChildNodes().getLength();
        if (expectedNode.getNodeName().compareTo(actualNode.getNodeName()) != 0) {
            Node a = expectedNode.getAttributes().getNamedItem("Value");
            if (expectedNode.getNodeName().compareTo("None") == 0 && a != null && a.getNodeValue().compareTo("*") == 0) {
                return;
            }
            list.add(expectedNode.getNodeName() + "-" + actualNode.getNodeName());
            return;
        }
        if (cnt != actualNode.getChildNodes().getLength()) {
            if (expectedNode.getNodeName().equals("Array") || expectedNode.getNodeName().equals("Structure")) {
                if (cnt >= actualNode.getChildNodes().getLength()) {
                    cnt = actualNode.getChildNodes().getLength();
                }
            } else {
                list.add("Different amount: " + expectedNode.getNodeName() + "-" + actualNode.getNodeName());
                return;
            }
        }
        for (int pos = 0; pos != cnt; ++pos) {
            Node a;
            if (actualNode.getChildNodes().item(pos) == null) {
                list.add("Different values. Expected: '" + expectedNode.getChildNodes().item(pos).getNodeValue() + "'. Actual: 'null'.");
                continue;
            }
            if (actualNode.getChildNodes().item(pos).getChildNodes().getLength() != 0) {
                GXDLMSXmlPdu.compare(expectedNode.getChildNodes().item(pos), actualNode.getChildNodes().item(pos), list);
                continue;
            }
            if (expectedNode.getChildNodes().item(pos).getNodeValue().compareTo(actualNode.getChildNodes().item(pos).getNodeValue()) == 0 || (a = expectedNode.getChildNodes().item(pos).getAttributes().getNamedItem("Value")) != null && (expectedNode.getChildNodes().item(pos).getNodeName().compareTo("None") == 0 || expectedNode.getChildNodes().item(pos).getNodeName().compareTo(actualNode.getChildNodes().item(pos).getNodeName()) == 0) && a.getNodeValue().compareTo("*") == 0 || expectedNode.getFirstChild().getNodeName().equals("Structure") || expectedNode.getFirstChild().getNodeName().equals("Array") || expectedNode.getParentNode().getNodeName().equals("Array")) continue;
            list.add("Different values. Expected: '" + expectedNode.getChildNodes().item(pos).getNodeValue() + "'. Actual: '" + actualNode.getChildNodes().item(pos).getNodeValue() + "'.");
        }
    }

    public final ArrayList<String> compare(String xml) {
        Document doc;
        ArrayList<String> list = new ArrayList<String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        GXDLMSXmlPdu.compare(this.getXmlNode(), doc.getDocumentElement(), list);
        return list;
    }

    public final boolean isRequest() {
        boolean ret;
        switch (this.command) {
            case 5: 
            case 6: 
            case 37: 
            case 38: 
            case 83: 
            case 96: 
            case 98: 
            case 147: 
            case 192: 
            case 193: 
            case 195: 
            case 200: 
            case 201: 
            case 203: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        return ret;
    }

    public GXDLMSXmlPdu() {
    }

    public GXDLMSXmlPdu(int command, Node xml, byte[] pdu) {
        this.setCommand(command);
        this.xmlNode = xml;
        this.setData(pdu);
    }

    public String toString() {
        return this.getPduAsXml();
    }
}

