/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXDate;
import gurux.dlms.GXTime;
import gurux.dlms.GXUInt64;
import gurux.dlms.enums.ClockStatus;
import gurux.dlms.enums.DateTimeExtraInfo;
import gurux.dlms.enums.DateTimeSkips;
import gurux.dlms.internal.GXCommon;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public class GXDateTime {
    private Set<ClockStatus> status;
    private Calendar meterCalendar;
    private Set<DateTimeSkips> skip;
    private Set<DateTimeExtraInfo> extra;
    private int dayOfWeek = 0;

    public GXDateTime() {
        this.skip = new HashSet<DateTimeSkips>();
        this.meterCalendar = Calendar.getInstance();
        this.status = new HashSet<ClockStatus>();
        this.status.add(ClockStatus.OK);
        this.extra = new HashSet<DateTimeExtraInfo>();
    }

    public GXDateTime(Date value) {
        this.skip = new HashSet<DateTimeSkips>();
        this.meterCalendar = Calendar.getInstance();
        this.meterCalendar.setTime(value);
        this.status = new HashSet<ClockStatus>();
        this.status.add(ClockStatus.OK);
        this.extra = new HashSet<DateTimeExtraInfo>();
    }

    public GXDateTime(Calendar value) {
        this.skip = new HashSet<DateTimeSkips>();
        this.meterCalendar = value;
        this.status = new HashSet<ClockStatus>();
        this.status.add(ClockStatus.OK);
        this.extra = new HashSet<DateTimeExtraInfo>();
    }

    public GXDateTime(GXDateTime value) {
        this.skip = new HashSet<DateTimeSkips>();
        this.meterCalendar = Calendar.getInstance();
        this.meterCalendar = value.getMeterCalendar();
        this.status = new HashSet<ClockStatus>();
        this.extra = new HashSet<DateTimeExtraInfo>();
        if (value != null) {
            this.skip.addAll(value.getSkip());
            this.status.addAll(value.getStatus());
            this.extra.addAll(value.getExtra());
        }
    }

    public GXDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.meterCalendar = Calendar.getInstance();
        this.init(year, month, day, hour, minute, second, millisecond);
    }

    @Deprecated
    public GXDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int timeZone) {
        this.meterCalendar = Calendar.getInstance(GXDateTime.getTimeZone(timeZone, true));
        this.init(year, month, day, hour, minute, second, millisecond);
    }

    protected void init(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        int y = year;
        int m = month;
        int d = day;
        int h = hour;
        int min = minute;
        int s = second;
        int ms = millisecond;
        this.skip = new HashSet<DateTimeSkips>();
        this.extra = new HashSet<DateTimeExtraInfo>();
        this.status = new HashSet<ClockStatus>();
        this.status.add(ClockStatus.OK);
        if (y < 1 || y == 65535) {
            this.skip.add(DateTimeSkips.YEAR);
            Calendar tm = Calendar.getInstance();
            y = tm.get(1);
        }
        if (m == 254) {
            m = 0;
            this.extra.add(DateTimeExtraInfo.DST_BEGIN);
        } else if (m == 253) {
            m = 0;
            this.extra.add(DateTimeExtraInfo.DST_END);
        } else if (m < 1 || m > 12) {
            this.skip.add(DateTimeSkips.MONTH);
            m = 0;
        } else {
            --m;
        }
        if (d == 254) {
            d = 1;
            this.extra.add(DateTimeExtraInfo.LAST_DAY);
        } else if (d == 253) {
            d = 1;
            this.extra.add(DateTimeExtraInfo.LAST_DAY2);
        } else if (d == -1 || d == 0 || d > 31) {
            this.skip.add(DateTimeSkips.DAY);
            d = 1;
        }
        if (h < 0 || h > 24) {
            this.skip.add(DateTimeSkips.HOUR);
            h = 0;
        }
        if (min < 0 || min > 60) {
            this.skip.add(DateTimeSkips.MINUTE);
            min = 0;
        }
        if (s < 0 || s > 60) {
            this.skip.add(DateTimeSkips.SECOND);
            s = 0;
        }
        if (ms < 1 || ms > 1000) {
            this.skip.add(DateTimeSkips.MILLISECOND);
            ms = 0;
        }
        this.meterCalendar.set(y, m, d, h, min, s);
        if (ms != 0) {
            this.meterCalendar.set(14, ms);
        }
    }

    private static boolean isNumeric(char value) {
        return value >= '0' && value <= '9';
    }

    public GXDateTime(String value) {
        this(value, (Locale)null);
    }

    public GXDateTime(String value, Locale locale) {
        if (value != null) {
            SimpleDateFormat sd = locale != null ? (locale == Locale.ROOT ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss") : (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale)) : new SimpleDateFormat();
            this.init(value, sd.toPattern(), locale);
        }
    }

    public GXDateTime(String value, String pattern) {
        this.init(value, pattern, null);
    }

    public GXDateTime(String value, String pattern, Locale locale) {
        this.init(value, pattern, locale);
    }

    private static int timeZonePosition(String value) {
        int pos;
        char sep;
        if (value.length() > 5 && ((sep = value.charAt(pos = value.length() - 6)) == '-' || sep == '+')) {
            return pos;
        }
        return -1;
    }

    public void init(String value, String pattern, Locale locale) {
        if (this.skip == null) {
            this.skip = new HashSet<DateTimeSkips>();
        }
        if (this.extra == null) {
            this.extra = new HashSet<DateTimeExtraInfo>();
        }
        if (this.status == null) {
            this.status = new HashSet<ClockStatus>();
            this.status.add(ClockStatus.OK);
        }
        if (value != null) {
            int pos;
            boolean addTimeZone;
            StringBuilder format = new StringBuilder();
            format.append(pattern);
            this.remove(format);
            String v = value;
            if (value.indexOf("BEGIN") != -1) {
                this.extra.add(DateTimeExtraInfo.DST_BEGIN);
                v = v.replace("BEGIN", "01");
            }
            if (value.indexOf("END") != -1) {
                this.extra.add(DateTimeExtraInfo.DST_END);
                v = v.replace("END", "01");
            }
            if (value.indexOf("LASTDAY2") != -1) {
                this.extra.add(DateTimeExtraInfo.LAST_DAY2);
                v = v.replace("LASTDAY2", "01");
            }
            if (value.indexOf("LASTDAY") != -1) {
                this.extra.add(DateTimeExtraInfo.LAST_DAY);
                v = v.replace("LASTDAY", "01");
            }
            boolean bl = addTimeZone = !(this instanceof GXDate) && !(this instanceof GXTime);
            if (value.indexOf(42) != -1) {
                int lastFormatIndex = -1;
                for (int pos2 = 0; pos2 < v.length(); ++pos2) {
                    char c = v.charAt(pos2);
                    if (GXDateTime.isNumeric(c)) continue;
                    if (c == '*') {
                        int end = lastFormatIndex + 1;
                        c = format.charAt(end);
                        while (end + 1 < format.length() && format.charAt(end) == c) {
                            ++end;
                        }
                        v = v.substring(0, pos2) + "1" + v.substring(pos2 + 1);
                        String tmp = format.substring(lastFormatIndex + 1, end).trim();
                        if (tmp.startsWith("y")) {
                            addTimeZone = false;
                            this.skip.add(DateTimeSkips.YEAR);
                            continue;
                        }
                        if (tmp.equals("M") || tmp.equals("MM")) {
                            addTimeZone = false;
                            this.skip.add(DateTimeSkips.MONTH);
                            continue;
                        }
                        if (tmp.equals("dd") || tmp.equals("d")) {
                            addTimeZone = false;
                            this.skip.add(DateTimeSkips.DAY);
                            continue;
                        }
                        if (tmp.equals("h") || tmp.equals("hh") || tmp.equals("HH") || tmp.equals("H") || tmp.equals("a")) {
                            addTimeZone = false;
                            this.skip.add(DateTimeSkips.HOUR);
                            int pos22 = format.indexOf("a");
                            if (pos22 == -1) continue;
                            format.replace(pos22, pos22 + 1, "");
                            continue;
                        }
                        if (tmp.equals("mm") || tmp.equals("m")) {
                            addTimeZone = false;
                            this.skip.add(DateTimeSkips.MINUTE);
                            continue;
                        }
                        if (tmp.equals("ss") || tmp.equals("s")) {
                            this.skip.add(DateTimeSkips.SECOND);
                            continue;
                        }
                        if (tmp.isEmpty() || tmp.equals("G")) continue;
                        throw new IllegalArgumentException("Invalid date time format.");
                    }
                    lastFormatIndex = format.indexOf(String.valueOf(c), lastFormatIndex + 1);
                }
            }
            if (addTimeZone && (pos = GXDateTime.timeZonePosition(value)) != -1) {
                if (format.indexOf("XXX") == -1) {
                    format.append("XXX");
                }
                String zone = "GMT" + value.substring(pos);
                this.meterCalendar = Calendar.getInstance(TimeZone.getTimeZone(zone));
            } else if (addTimeZone && value.indexOf(90) != -1) {
                format.append("XXX");
                this.meterCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            } else {
                if (addTimeZone) {
                    this.getSkip().add(DateTimeSkips.DEVITATION);
                }
                this.meterCalendar = Calendar.getInstance();
            }
            SimpleDateFormat sd = null;
            try {
                sd = locale != null && locale != Locale.ROOT ? new SimpleDateFormat(format.toString().trim(), locale) : new SimpleDateFormat(format.toString().trim());
                this.meterCalendar.setTime(sd.parse(v));
                this.getSkip().add(DateTimeSkips.DAY_OF_WEEK);
                this.getSkip().add(DateTimeSkips.MILLISECOND);
            }
            catch (ParseException e) {
                try {
                    int index;
                    if (!this.getSkip().contains((Object)DateTimeSkips.SECOND) && (index = format.indexOf("mm")) != -1) {
                        String sep = format.substring(index - 1, index);
                        format.replace(index, index + 2, "mm" + sep + "ss");
                    }
                    sd.applyPattern(format.toString().trim());
                    this.meterCalendar.setTime(sd.parse(v));
                    this.getSkip().add(DateTimeSkips.MILLISECOND);
                }
                catch (ParseException e1) {
                    try {
                        int index;
                        if (!this.getSkip().contains((Object)DateTimeSkips.MILLISECOND) && (index = format.indexOf("ss")) != -1) {
                            String sep = format.substring(index - 1, index);
                            format.replace(index, index + 2, "ss" + sep + "SSS");
                        }
                        sd.applyPattern(format.toString().trim());
                        this.meterCalendar.setTime(sd.parse(v));
                    }
                    catch (ParseException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (Exception e2) {
                        throw new IllegalArgumentException(e);
                    }
                }
                catch (Exception e1) {
                    throw new IllegalArgumentException(e1);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Deprecated
    public final Calendar getCalendar() {
        return this.meterCalendar;
    }

    public final Calendar getLocalCalendar() {
        long meterTime = this.meterCalendar.getTimeInMillis();
        Calendar local = Calendar.getInstance();
        local.setTimeInMillis(meterTime);
        return local;
    }

    public final Calendar getLocalCalendar(TimeZone tz) {
        long meterTime = this.meterCalendar.getTimeInMillis();
        Calendar local = Calendar.getInstance(tz);
        local.setTimeInMillis(meterTime);
        return local;
    }

    public final Calendar getMeterCalendar() {
        return this.meterCalendar;
    }

    public final void setMeterCalendar(Calendar value) {
        this.meterCalendar = value;
    }

    @Deprecated
    public final Date getValue() {
        return this.meterCalendar.getTime();
    }

    @Deprecated
    public final void setValue(Date forvalue) {
        this.meterCalendar.setTime(forvalue);
    }

    @Deprecated
    public final void setValue(Date forvalue, int forDeviation) {
        this.meterCalendar = Calendar.getInstance(GXDateTime.getTimeZone(forDeviation, true));
        this.meterCalendar.setTime(forvalue);
    }

    public final Set<DateTimeSkips> getSkip() {
        return this.skip;
    }

    public final void setSkip(Set<DateTimeSkips> value) {
        this.skip = value;
    }

    public final void setUsed(Set<DateTimeSkips> value) {
        int val = 0;
        for (DateTimeSkips it : value) {
            val |= it.getValue();
        }
        int tmp = 0xFFFFFFFF & ~val;
        this.skip = DateTimeSkips.forValue(tmp);
    }

    public final int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public final void setDayOfWeek(int forValue) {
        this.dayOfWeek = forValue;
    }

    @Deprecated
    public final int getDeviation() {
        return -((this.meterCalendar.get(15) + this.meterCalendar.get(16)) / 60000);
    }

    @Deprecated
    public final void setDeviation(int forValue) {
        this.meterCalendar = Calendar.getInstance(GXDateTime.getTimeZone(forValue, true));
    }

    public final Set<ClockStatus> getStatus() {
        return this.status;
    }

    public final void setStatus(Set<ClockStatus> forValue) {
        this.status = forValue;
    }

    private void remove(StringBuilder format) {
        if (this instanceof GXDate) {
            this.remove(format, "HH", true);
            this.remove(format, "H", true);
            this.remove(format, "hh", true);
            this.remove(format, "h", true);
            this.remove(format, "mm", true);
            this.remove(format, "ss", true);
            this.remove(format, "m", true);
            this.remove(format, "a", true);
        } else if (this instanceof GXTime) {
            this.remove(format, "yyyy", true);
            this.remove(format, "yy", true);
            this.remove(format, "MM", true);
            this.remove(format, "M", true);
            this.remove(format, "dd", true);
            this.remove(format, "d", true);
        }
        String tmp = format.toString();
        format.setLength(0);
        format.append(tmp.trim());
    }

    public String toFormatString() {
        return this.toFormatString((Locale)null);
    }

    public String toFormatString(String pattern) {
        return this.toFormatString(pattern, true, null);
    }

    private String toFormatString(String pattern, boolean useLocalTime, Locale locale) {
        String sep;
        int index;
        StringBuilder format = new StringBuilder();
        format.append(pattern);
        this.remove(format);
        if (this.extra.contains((Object)DateTimeExtraInfo.DST_BEGIN)) {
            this.replace(format, "MM", "!");
            this.replace(format, "M", "!");
        } else if (this.extra.contains((Object)DateTimeExtraInfo.DST_END)) {
            this.replace(format, "MM", "#");
            this.replace(format, "M", "#");
        } else if (this.extra.contains((Object)DateTimeExtraInfo.LAST_DAY)) {
            this.replace(format, "dd", "%");
            this.replace(format, "d", "%");
        } else if (this.extra.contains((Object)DateTimeExtraInfo.LAST_DAY2)) {
            this.replace(format, "dd", "?");
            this.replace(format, "d", "?");
        }
        if (this.getSkip().contains((Object)DateTimeSkips.YEAR)) {
            this.replace(format, "yyyy");
            this.replace(format, "yy");
            this.replace(format, "y");
            this.remove(format, "XXX", false);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.MONTH)) {
            this.replace(format, "MM");
            this.replace(format, "M");
            this.remove(format, "XXX", false);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.DAY)) {
            this.replace(format, "dd");
            this.replace(format, "d");
            this.remove(format, "XXX", false);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.HOUR)) {
            this.replace(format, "HH");
            this.replace(format, "H");
            this.replace(format, "hh");
            this.replace(format, "h");
            this.remove(format, "a", false);
            this.remove(format, "XXX", false);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.MILLISECOND) || this.getMeterCalendar().get(14) == 0) {
            this.replace(format, "SSS");
        } else {
            index = format.indexOf("ss");
            if (index != -1) {
                sep = format.substring(index - 1, index);
                format.replace(index, index + 2, "ss" + sep + "SSS");
            }
        }
        if (this.getSkip().contains((Object)DateTimeSkips.SECOND)) {
            this.replace(format, "ss");
        } else if (format.indexOf("ss") == -1 && (index = format.indexOf("mm")) != -1) {
            sep = format.substring(index - 1, index);
            format.replace(index, index + 2, "mm" + sep + "ss");
        }
        if (this.getSkip().contains((Object)DateTimeSkips.MINUTE)) {
            this.replace(format, "mm");
            this.replace(format, "m");
            this.remove(format, "XXX", false);
        }
        SimpleDateFormat sd = locale != null && locale != Locale.ROOT ? new SimpleDateFormat(format.toString().trim(), locale) : new SimpleDateFormat(format.toString().trim());
        if (useLocalTime) {
            return sd.format(this.getLocalCalendar().getTime()).replace("!", "BEGIN").replace("#", "END").replace("%", "LASTDAY").replace("?", "LASTDAY2");
        }
        sd.setCalendar(this.getMeterCalendar());
        return sd.format(this.getMeterCalendar().getTime()).replace("!", "BEGIN").replace("#", "END").replace("%", "LASTDAY").replace("?", "LASTDAY2");
    }

    public String toFormatString(Locale locale) {
        return this.toFormatString(locale, true);
    }

    public String toFormatMeterString(Locale locale) {
        return this.toFormatString(locale, false);
    }

    public String toFormatMeterString(String pattern) {
        return this.toFormatString(pattern, false, null);
    }

    private String toFormatString(Locale locale, boolean useLocalTime) {
        SimpleDateFormat sd = locale != null ? (locale == Locale.ROOT ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss") : (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale)) : new SimpleDateFormat();
        if (!useLocalTime && !this.skip.contains((Object)DateTimeSkips.DEVITATION)) {
            sd.applyPattern(sd.toPattern() + "XXX");
        }
        if (!this.getSkip().isEmpty()) {
            return this.toFormatString(sd.toPattern(), useLocalTime, locale);
        }
        if (useLocalTime) {
            return sd.format(this.getLocalCalendar().getTime());
        }
        return sd.format(this.getMeterCalendar().getTime());
    }

    private void remove(StringBuilder value, String tag, boolean removeSeparator) {
        int pos = value.indexOf(tag);
        if (pos != -1) {
            int len = pos + tag.length();
            if (pos != 0 && removeSeparator) {
                --pos;
            }
            value.replace(pos, len, "");
        }
    }

    private void replace(StringBuilder value, String tag) {
        this.replace(value, tag, "*");
    }

    private void replace(StringBuilder value, String tag, String newValue) {
        int pos = value.indexOf(tag);
        if (pos != -1) {
            int len = pos + tag.length();
            value.replace(pos, len, newValue);
        }
    }

    public final String toString(Locale locale) {
        return this.toString(locale, true);
    }

    public final String toMeterString() {
        return this.toString(Locale.getDefault(), false);
    }

    public final String toMeterString(Locale locale) {
        return this.toString(locale, false);
    }

    private final String toString(Locale locale, boolean useLocalTime) {
        SimpleDateFormat sd = locale != null ? (locale == Locale.ROOT ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss") : (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale)) : new SimpleDateFormat();
        if (!useLocalTime && !this.skip.contains((Object)DateTimeSkips.DEVITATION)) {
            sd.applyPattern(sd.toPattern() + "XXX");
        }
        if (!this.getSkip().isEmpty()) {
            return this.toString(sd.toPattern(), locale, useLocalTime);
        }
        if (useLocalTime) {
            return sd.format(this.getLocalCalendar().getTime());
        }
        sd.setCalendar(this.getMeterCalendar());
        return sd.format(this.getMeterCalendar().getTime());
    }

    public final String toMeterString(String pattern) {
        return this.toString(pattern, null, false);
    }

    public final String toString(String pattern) {
        return this.toString(pattern, null, true);
    }

    private final String toString(String pattern, Locale locale, boolean useLocalTime) {
        if (!this.getSkip().isEmpty()) {
            String sep;
            int index;
            StringBuilder format = new StringBuilder();
            format.append(pattern);
            this.remove(format);
            if (this.getSkip().contains((Object)DateTimeSkips.YEAR)) {
                this.remove(format, "yyyy", true);
                this.remove(format, "yy", true);
                this.remove(format, "y", true);
                this.remove(format, "XXX", true);
            }
            if (this.getSkip().contains((Object)DateTimeSkips.MONTH)) {
                this.remove(format, "M", true);
                this.remove(format, "XXX", true);
            }
            if (this.getSkip().contains((Object)DateTimeSkips.DAY)) {
                this.remove(format, "d", true);
                this.remove(format, "XXX", true);
            }
            if (this.getSkip().contains((Object)DateTimeSkips.HOUR)) {
                this.remove(format, "HH", true);
                this.remove(format, "H", true);
                this.remove(format, "h", true);
                this.remove(format, "a", true);
                this.remove(format, "XXX", true);
            }
            if (this.getSkip().contains((Object)DateTimeSkips.MILLISECOND)) {
                this.remove(format, "SSS", true);
            } else {
                index = format.indexOf("ss");
                if (index != -1) {
                    sep = format.substring(index - 1, index);
                    format.replace(index, index + 2, "ss" + sep + "SSS");
                }
            }
            if (this.getSkip().contains((Object)DateTimeSkips.SECOND)) {
                this.remove(format, "ss", true);
            } else if (format.indexOf("ss") == -1 && (index = format.indexOf("mm")) != -1) {
                sep = format.substring(index - 1, index);
                format.replace(index, index + 2, "mm" + sep + "ss");
            }
            if (this.getSkip().contains((Object)DateTimeSkips.MINUTE)) {
                this.remove(format, "mm", true);
                this.remove(format, "m", true);
            }
            SimpleDateFormat sd = locale != null ? new SimpleDateFormat(format.toString().trim(), locale) : new SimpleDateFormat(format.toString().trim());
            if (useLocalTime) {
                sd.setCalendar(this.getLocalCalendar());
                return sd.format(this.getLocalCalendar().getTime());
            }
            sd.setCalendar(this.getMeterCalendar());
            return sd.format(this.getMeterCalendar().getTime());
        }
        SimpleDateFormat sd = new SimpleDateFormat(pattern);
        if (useLocalTime) {
            return sd.format(this.getLocalCalendar().getTime());
        }
        sd.setCalendar(this.getMeterCalendar());
        return sd.format(this.getMeterCalendar().getTime());
    }

    public final String toString() {
        String sep;
        int index;
        StringBuilder format = new StringBuilder();
        SimpleDateFormat sd = new SimpleDateFormat();
        format.append(sd.toPattern());
        this.remove(format);
        if (this.getSkip().contains((Object)DateTimeSkips.YEAR)) {
            this.remove(format, "yyyy", true);
            this.remove(format, "yy", true);
            this.remove(format, "y", true);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.MONTH)) {
            this.remove(format, "M", true);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.DAY)) {
            this.remove(format, "d", true);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.HOUR)) {
            this.remove(format, "HH", true);
            this.remove(format, "H", true);
            this.remove(format, "h", true);
            this.remove(format, "a", true);
        }
        if (this.getSkip().contains((Object)DateTimeSkips.MILLISECOND)) {
            this.remove(format, "SSS", true);
        } else {
            index = format.indexOf("ss");
            if (index != -1) {
                sep = format.substring(index - 1, index);
                format.replace(index, index + 2, "ss" + sep + "SSS");
            }
        }
        if (this.getSkip().contains((Object)DateTimeSkips.SECOND)) {
            this.remove(format, "ss", true);
        } else {
            index = format.indexOf("mm");
            if (index != -1) {
                sep = format.substring(index - 1, index);
                format.replace(index, index + 2, "mm" + sep + "ss");
            }
        }
        if (this.getSkip().contains((Object)DateTimeSkips.MINUTE)) {
            this.remove(format, "mm", true);
            this.remove(format, "m", true);
        }
        sd = new SimpleDateFormat(format.toString().trim());
        return sd.format(this.getLocalCalendar().getTime());
    }

    public static long getDifference(Calendar start, GXDateTime to) {
        long diff = 0L;
        Calendar cal = to.getLocalCalendar();
        if (!to.getSkip().contains((Object)DateTimeSkips.SECOND)) {
            diff = start.get(13) < cal.get(13) ? (diff += (long)(cal.get(13) - start.get(13)) * 1000L) : (diff -= (long)(start.get(13) - cal.get(13)) * 1000L);
        } else if (diff < 0L) {
            diff = 60000L + diff;
        }
        if (!to.getSkip().contains((Object)DateTimeSkips.MINUTE)) {
            diff = start.get(12) < cal.get(12) ? (diff += (long)(cal.get(12) - start.get(12)) * 60000L) : (diff -= (long)(start.get(12) - cal.get(12)) * 60000L);
        } else if (diff < 0L) {
            diff = 3600000L + diff;
        }
        if (!to.getSkip().contains((Object)DateTimeSkips.HOUR)) {
            diff = start.get(11) < cal.get(11) ? (diff += (long)((cal.get(11) - start.get(11)) * 60) * 60000L) : (diff -= (long)((start.get(11) - cal.get(11)) * 60) * 60000L);
        } else if (diff < 0L) {
            diff = 3600000L + diff;
        }
        if (!to.getSkip().contains((Object)DateTimeSkips.DAY)) {
            if (start.get(5) < cal.get(5)) {
                diff += (long)((cal.get(5) - start.get(5)) * 24 * 60 * 60000);
            } else if (start.get(5) != cal.get(5)) {
                diff = !to.getSkip().contains((Object)DateTimeSkips.DAY) ? (diff += (long)((cal.get(5) - start.get(5)) * 24 * 60) * 60000L) : (long)((GXCommon.daysInMonth(start.get(1), start.get(2)) - start.get(5) + cal.get(5)) * 24 * 60) * 60000L + diff;
            }
        } else if (diff < 0L) {
            diff = 86400000L + diff;
        }
        if (!to.getSkip().contains((Object)DateTimeSkips.MONTH)) {
            if (start.get(2) < cal.get(2)) {
                for (int m = start.get(2); m != cal.get(2); ++m) {
                    diff += (long)(GXCommon.daysInMonth(start.get(1), m) * 24 * 60) * 60000L;
                }
            } else {
                for (int m = cal.get(2); m != start.get(2); ++m) {
                    diff += (long)(-GXCommon.daysInMonth(start.get(1), m) * 24 * 60) * 60000L;
                }
            }
        } else if (diff < 0L) {
            diff = (long)(GXCommon.daysInMonth(start.get(1), start.get(2)) * 24 * 60) * 60000L + diff;
        }
        return diff;
    }

    public static TimeZone getTimeZone(int deviation, boolean dst) {
        if (deviation == 32768 || deviation == Short.MIN_VALUE) {
            return Calendar.getInstance().getTimeZone();
        }
        TimeZone tz = Calendar.getInstance().getTimeZone();
        if (dst) {
            if (tz.observesDaylightTime() && tz.getRawOffset() / 60000 == deviation - 60) {
                return tz;
            }
            String[] ids = TimeZone.getAvailableIDs((deviation - 60) * 60000);
            tz = null;
            for (int pos = 0; !(pos == ids.length || (tz = TimeZone.getTimeZone(ids[pos])).observesDaylightTime() && tz.getRawOffset() / 60000 == deviation - 60); ++pos) {
                tz = null;
            }
            if (tz != null) {
                return tz;
            }
        }
        if (tz != null && !tz.observesDaylightTime() && tz.getRawOffset() / 60000 == deviation) {
            return tz;
        }
        DecimalFormat df = new DecimalFormat("00");
        String tmp = df.format(deviation / 60) + ":" + df.format(Math.abs(deviation) % 60);
        String str = deviation == 0 ? "GMT" : (deviation > 0 ? "GMT+" + tmp : "GMT" + tmp);
        return TimeZone.getTimeZone(str);
    }

    public static GXDateTime fromUnixTime(long unixTime) {
        return new GXDateTime(new Date(unixTime * 1000L));
    }

    public static long toUnixTime(Date date) {
        return date.getTime() / 1000L;
    }

    public static long toUnixTime(GXDateTime date) {
        return date.getLocalCalendar().getTime().getTime() / 1000L;
    }

    public static GXDateTime fromHighResolutionTime(long highResolution) {
        return new GXDateTime(new Date(highResolution));
    }

    public static GXUInt64 toHighResolutionTime(Date date) {
        return new GXUInt64(date.getTime());
    }

    public static GXUInt64 toHighResolutionTime(GXDateTime date) {
        return new GXUInt64(date.getLocalCalendar().getTime().getTime());
    }

    public Set<DateTimeExtraInfo> getExtra() {
        return this.extra;
    }

    public void setExtra(Set<DateTimeExtraInfo> value) {
        this.extra = value;
    }
}

