/*
 * Decompiled with CFR 0.152.
 */
package gurux.dlms;

import gurux.dlms.GXByteBuffer;
import gurux.dlms.GXDLMS;
import gurux.dlms.GXDLMSSettings;
import gurux.dlms.enums.InterfaceType;
import gurux.dlms.internal.GXCommon;
import gurux.dlms.plc.GXDLMSPlcMeterInfo;
import gurux.dlms.plc.GXDLMSPlcRegister;
import gurux.dlms.plc.enums.PlcDestinationAddress;
import gurux.dlms.plc.enums.PlcHdlcSourceAddress;
import gurux.dlms.plc.enums.PlcSourceAddress;
import java.util.ArrayList;
import java.util.List;

public class GXPlcSettings {
    private byte[] systemTitle;
    private GXDLMSSettings settings;
    private int initialCredit;
    private int currentCredit;
    private byte deltaCredit;
    private int macSourceAddress;
    private int macDestinationAddress;
    private byte responseProbability;
    private int allowedTimeSlots;
    private byte[] clientSystemTitle;

    public final int getInitialCredit() {
        return this.initialCredit;
    }

    public final void setInitialCredit(int value) {
        this.initialCredit = value;
    }

    public final int getCurrentCredit() {
        return this.currentCredit;
    }

    public final void setCurrentCredit(int value) {
        this.currentCredit = value;
    }

    public final byte getDeltaCredit() {
        return this.deltaCredit;
    }

    public final void setDeltaCredit(byte value) {
        this.deltaCredit = value;
    }

    public final byte[] getSystemTitle() {
        if (this.settings != null && this.settings.getInterfaceType() != InterfaceType.PLC && this.settings.getCipher() != null) {
            return this.settings.getCipher().getSystemTitle();
        }
        return this.systemTitle;
    }

    public final void setSystemTitle(byte[] value) {
        if (this.settings != null && this.settings.getInterfaceType() != InterfaceType.PLC && this.settings.getCipher() != null) {
            this.settings.getCipher().setSystemTitle(value);
        }
        this.systemTitle = value;
    }

    public final int getMacSourceAddress() {
        return this.macSourceAddress;
    }

    public final void setMacSourceAddress(int value) {
        this.macSourceAddress = value;
    }

    public final int getMacDestinationAddress() {
        return this.macDestinationAddress;
    }

    public final void setMacDestinationAddress(int value) {
        this.macDestinationAddress = value;
    }

    public final byte getResponseProbability() {
        return this.responseProbability;
    }

    public final void setResponseProbability(byte value) {
        this.responseProbability = value;
    }

    public final int getAllowedTimeSlots() {
        return this.allowedTimeSlots;
    }

    public final void setAllowedTimeSlots(int value) {
        this.allowedTimeSlots = value;
    }

    public final byte[] getClientSystemTitle() {
        return this.clientSystemTitle;
    }

    public final void setClientSystemTitle(byte[] value) {
        this.clientSystemTitle = value;
    }

    public final void reset() {
        this.initialCredit = 7;
        this.currentCredit = 7;
        this.deltaCredit = 0;
        if (this.settings.getInterfaceType() == InterfaceType.PLC) {
            if (this.settings.isServer()) {
                this.macSourceAddress = PlcSourceAddress.NEW.getValue();
                this.macDestinationAddress = PlcSourceAddress.INITIATOR.getValue();
            } else {
                this.macSourceAddress = PlcSourceAddress.INITIATOR.getValue();
                this.macDestinationAddress = PlcDestinationAddress.ALL_PHYSICAL.getValue();
            }
        } else if (this.settings.isServer()) {
            this.macSourceAddress = PlcSourceAddress.NEW.getValue();
            this.macDestinationAddress = PlcHdlcSourceAddress.INITIATOR.getValue();
        } else {
            this.macSourceAddress = PlcHdlcSourceAddress.INITIATOR.getValue();
            this.macDestinationAddress = PlcDestinationAddress.ALL_PHYSICAL.getValue();
        }
        this.responseProbability = (byte)100;
        this.allowedTimeSlots = this.settings.getInterfaceType() == InterfaceType.PLC ? 10 : 20;
    }

    public GXPlcSettings(GXDLMSSettings s) {
        this.settings = s;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] discoverRequest() {
        GXByteBuffer bb = new GXByteBuffer();
        if (this.settings.getInterfaceType() != InterfaceType.PLC && this.settings.getInterfaceType() != InterfaceType.PLC_HDLC) {
            throw new IllegalArgumentException("Invalid interface type.");
        }
        if (this.settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
            bb.set(GXCommon.LLC_SEND_BYTES);
        }
        bb.setUInt8(29);
        bb.setUInt8(this.getResponseProbability());
        bb.setUInt16(this.getAllowedTimeSlots());
        bb.setUInt8(0);
        bb.setUInt8(0);
        int val = 0;
        int clientAddress = this.settings.getClientAddress();
        int serverAddress = this.settings.getServerAddress();
        int da = this.settings.getPlc().getMacDestinationAddress();
        int sa = this.settings.getPlc().getMacSourceAddress();
        try {
            if (this.settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
                this.settings.getPlc().setInitialCredit(0);
                this.settings.getPlc().setCurrentCredit(0);
                this.settings.getPlc().setMacSourceAddress(3073);
                this.settings.getPlc().setMacDestinationAddress(4095);
                this.settings.setClientAddress(102);
                this.settings.setServerAddress(13311);
            } else {
                val = this.settings.getPlc().getInitialCredit() << 5;
                val |= this.settings.getPlc().getCurrentCredit() << 2;
                val |= this.settings.getPlc().getDeltaCredit() & 3;
                this.settings.getPlc().setMacSourceAddress(3072);
                this.settings.setClientAddress(1);
                this.settings.setServerAddress(0);
            }
            byte[] byArray = GXDLMS.getMacFrame(this.settings, (byte)19, (byte)val, bb);
            return byArray;
        }
        finally {
            this.settings.setClientAddress(clientAddress);
            this.settings.setServerAddress(serverAddress);
            this.settings.getPlc().setMacDestinationAddress(da);
            this.settings.getPlc().setMacSourceAddress(sa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] discoverReport(byte[] systemTitle, boolean newMeter) {
        GXByteBuffer bb = new GXByteBuffer();
        if (this.settings.getInterfaceType() != InterfaceType.PLC && this.settings.getInterfaceType() != InterfaceType.PLC_HDLC) {
            throw new IllegalArgumentException("Invalid interface type.");
        }
        int alarmDescription = this.settings.getInterfaceType() == InterfaceType.PLC ? (newMeter ? 1 : 130) : 0;
        if (this.settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
            bb.set(GXCommon.LLC_REPLY_BYTES);
        }
        bb.setUInt8(30);
        bb.setUInt8(1);
        bb.set(systemTitle);
        if (alarmDescription != 0) {
            bb.setUInt8(1);
        }
        bb.setUInt8(alarmDescription);
        int clientAddress = this.settings.getClientAddress();
        int serverAddress = this.settings.getServerAddress();
        int macSourceAddress = this.settings.getPlc().getMacSourceAddress();
        int macTargetAddress = this.settings.getPlc().getMacDestinationAddress();
        try {
            if (this.settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
                this.settings.getPlc().setMacDestinationAddress(PlcHdlcSourceAddress.INITIATOR.getValue());
            } else {
                this.settings.setClientAddress(0);
                this.settings.setServerAddress(253);
            }
            byte[] byArray = GXDLMS.getMacFrame(this.settings, (byte)19, (byte)0, bb);
            return byArray;
        }
        finally {
            this.settings.setClientAddress(clientAddress);
            this.settings.setServerAddress(serverAddress);
            this.settings.getPlc().setMacSourceAddress(macSourceAddress);
            this.settings.getPlc().setMacDestinationAddress(macTargetAddress);
        }
    }

    public final List<GXDLMSPlcMeterInfo> parseDiscover(GXByteBuffer value, int sa, int da) {
        ArrayList<GXDLMSPlcMeterInfo> list = new ArrayList<GXDLMSPlcMeterInfo>();
        int count = value.getUInt8();
        for (int pos = 0; pos != count; ++pos) {
            GXDLMSPlcMeterInfo info = new GXDLMSPlcMeterInfo();
            info.setSourceAddress(sa);
            info.setDestinationAddress(da);
            byte[] st = this.settings.getInterfaceType() == InterfaceType.PLC_HDLC ? new byte[8] : new byte[6];
            value.get(st);
            info.setSystemTitle(st);
            if (value.getUInt8() != 0) {
                info.setAlarmDescriptor(value.getUInt8());
            }
            list.add(info);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] registerRequest(byte[] initiatorSystemTitle, byte[] systemTitle) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(28);
        bb.set(initiatorSystemTitle);
        bb.setUInt8(1);
        bb.set(systemTitle);
        bb.setUInt16(this.getMacSourceAddress());
        int val = this.settings.getPlc().getInitialCredit() << 5;
        val |= this.settings.getPlc().getCurrentCredit() << 2;
        val |= this.settings.getPlc().getDeltaCredit() & 3;
        int clientAddress = this.settings.getClientAddress();
        int serverAddress = this.settings.getServerAddress();
        int macSourceAddress = this.settings.getPlc().getMacSourceAddress();
        int macTargetAddress = this.settings.getPlc().getMacDestinationAddress();
        try {
            if (this.settings.getInterfaceType() == InterfaceType.PLC_HDLC) {
                this.settings.getPlc().setInitialCredit(0);
                this.settings.getPlc().setCurrentCredit(0);
                this.settings.getPlc().setMacSourceAddress(3073);
                this.settings.getPlc().setMacDestinationAddress(4095);
                this.settings.setClientAddress(102);
                this.settings.setServerAddress(13311);
            } else {
                this.settings.setClientAddress(1);
                this.settings.setServerAddress(0);
                this.settings.getPlc().setMacSourceAddress(3072);
                this.settings.getPlc().setMacDestinationAddress(4095);
            }
            byte[] byArray = GXDLMS.getMacFrame(this.settings, (byte)19, (byte)val, bb);
            return byArray;
        }
        finally {
            this.settings.setClientAddress(clientAddress);
            this.settings.setServerAddress(serverAddress);
            this.settings.getPlc().setMacSourceAddress(macSourceAddress);
            this.settings.getPlc().setMacDestinationAddress(macTargetAddress);
        }
    }

    public final void parseRegisterRequest(GXByteBuffer value) {
        byte[] st = this.settings.getInterfaceType() == InterfaceType.PLC_HDLC ? new byte[8] : new byte[6];
        value.get(st);
        int count = value.getUInt8();
        for (int pos = 0; pos != count; ++pos) {
            st = this.settings.getInterfaceType() == InterfaceType.PLC_HDLC ? new byte[8] : new byte[6];
            value.get(st);
            this.setSystemTitle(st);
            this.setMacSourceAddress(value.getUInt16());
        }
    }

    public final GXDLMSPlcRegister parseDiscoverRequest(GXByteBuffer value) {
        GXDLMSPlcRegister ret = new GXDLMSPlcRegister();
        ret.setResponseProbability(value.getUInt8());
        ret.setAllowedTimeSlots(value.getUInt16());
        ret.setDiscoverReportInitialCredit(value.getUInt8());
        ret.setICEqualCredit(value.getUInt8());
        return ret;
    }

    public final byte[] pingRequest(byte[] systemTitle) {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(25);
        bb.set(systemTitle);
        return GXDLMS.getMacFrame(this.settings, (byte)19, (byte)0, bb);
    }

    public final byte[] parsePing(GXByteBuffer value) {
        return value.subArray(1, 6);
    }

    public final byte[] repeaterCallRequest() {
        GXByteBuffer bb = new GXByteBuffer();
        bb.setUInt8(31);
        bb.setUInt16(99);
        bb.setUInt8(0);
        bb.setUInt8(0);
        return GXDLMS.getMacFrame(this.settings, (byte)19, (byte)-4, bb);
    }
}

